/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration;

import io.axoniq.axonserver.migration.MigrationBaseProperties;
import io.axoniq.axonserver.migration.migrators.Migrator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MigrationRunner
implements CommandLineRunner {
    private final Logger logger = LoggerFactory.getLogger(MigrationRunner.class);
    private final List<Migrator> migrators;
    private final MigrationBaseProperties migrationProperties;
    private final ApplicationContext context;

    public void run(String ... options) throws Exception {
        if (this.migrators.isEmpty()) {
            throw new IllegalArgumentException("There are no Migrators to run. Did you disable all migrations?");
        }
        do {
            try {
                for (Migrator migrator : this.migrators) {
                    migrator.migrate();
                }
                if (!this.migrationProperties.isContinuous()) continue;
                Thread.sleep(this.migrationProperties.getContinuousTimeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("Migration interrupted");
            }
            catch (ExecutionException executionException) {
                this.logger.error("Error during migration", executionException.getCause());
            }
            catch (TimeoutException e) {
                this.logger.error("Error during migration", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("Unknown error during migration", (Throwable)e);
            }
        } while (this.migrationProperties.isContinuous());
        this.logger.info("Migration completed");
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        Thread.sleep(2000L);
        System.exit(0);
    }

    public MigrationRunner(List<Migrator> migrators, MigrationBaseProperties migrationProperties, ApplicationContext context) {
        this.migrators = migrators;
        this.migrationProperties = migrationProperties;
        this.context = context;
    }
}

