/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.source.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import io.axoniq.axonserver.migration.source.EventProducer;
import io.axoniq.axonserver.migration.source.SnapshotEvent;
import io.axoniq.axonserver.migration.source.mongo.MongoDomainEvent;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.DateTimeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.migration.source"}, havingValue="MONGO")
public class MongoEventProducer
implements EventProducer {
    private final MongoTemplate template;
    private FindIterable<Document> eventsCursor = null;
    MongoCursor<Document> eventsIterator = null;
    private FindIterable<Document> snapshotCursor = null;
    MongoCursor<Document> snapshotIterator = null;
    final Duration LOOK_BACK_DURATION;
    final Duration SNAPSHOTS_LOOK_BACK_DURATION;

    public MongoEventProducer(MongoTemplate template, @Value(value="${axoniq.migration.eventsLookBackSeconds:10}") int eventsLookBackSeconds, @Value(value="${axoniq.migration.snapshotsLookBackSeconds:15}") int snapshotsLookBackSeconds) {
        this.template = template;
        this.LOOK_BACK_DURATION = Duration.ofSeconds(eventsLookBackSeconds);
        this.SNAPSHOTS_LOOK_BACK_DURATION = Duration.ofSeconds(snapshotsLookBackSeconds);
    }

    public List<? extends MongoDomainEvent> findEvents(long lastToken, int batchSize) {
        if (this.eventsCursor == null && lastToken == -1L) {
            MongoCollection eventCollection = this.template.getCollection("domainevents");
            this.eventsCursor = eventCollection.find(Filters.and((Bson[])new Bson[]{Filters.lt((String)"timestamp", (Object)DateTimeUtils.formatInstant((TemporalAccessor)Instant.now().minus(this.LOOK_BACK_DURATION)))}));
            this.eventsCursor = this.eventsCursor.sort((Bson)new BasicDBObject("timestamp", (Object)1).append("sequenceNumber", (Object)1));
            this.eventsCursor = this.eventsCursor.batchSize(batchSize);
            this.eventsIterator = this.eventsCursor.iterator();
        } else if (this.eventsCursor == null) {
            MongoCollection eventCollection = this.template.getCollection("domainevents");
            this.eventsCursor = eventCollection.find(Filters.and((Bson[])new Bson[]{Filters.gte((String)"timestamp", (Object)DateTimeUtils.formatInstant((TemporalAccessor)Instant.ofEpochMilli(lastToken))), Filters.and((Bson[])new Bson[]{Filters.lte((String)"timestamp", (Object)Instant.now().minus(this.LOOK_BACK_DURATION).toString())})}));
            this.eventsCursor = this.eventsCursor.batchSize(batchSize);
            this.eventsIterator = this.eventsCursor.iterator();
        }
        return this.getResults(this.eventsIterator, batchSize);
    }

    public List<? extends SnapshotEvent> findSnapshots(String lastProcessedTimestamp, int batchSize) {
        if (this.snapshotCursor == null && Instant.parse(lastProcessedTimestamp).equals(Instant.ofEpochMilli(0L))) {
            MongoCollection snapshotCollection = this.template.getCollection("snapshotevents");
            this.snapshotCursor = snapshotCollection.find(Filters.and((Bson[])new Bson[]{Filters.lt((String)"timestamp", (Object)Instant.now().minus(this.SNAPSHOTS_LOOK_BACK_DURATION).toString())}));
            this.snapshotCursor = this.snapshotCursor.sort((Bson)new BasicDBObject("timestamp", (Object)1).append("sequenceNumber", (Object)1));
            this.snapshotCursor = this.snapshotCursor.batchSize(batchSize);
            this.snapshotIterator = this.snapshotCursor.iterator();
        } else if (this.snapshotCursor == null) {
            MongoCollection snapshotCollection = this.template.getCollection("snapshotevents");
            this.snapshotCursor = snapshotCollection.find(Filters.and((Bson[])new Bson[]{Filters.gt((String)"timestamp", (Object)lastProcessedTimestamp), Filters.and((Bson[])new Bson[]{Filters.lte((String)"timestamp", (Object)Instant.now().minus(this.SNAPSHOTS_LOOK_BACK_DURATION).toString())})}));
            this.snapshotCursor = this.snapshotCursor.batchSize(batchSize);
            this.snapshotIterator = this.snapshotCursor.iterator();
        }
        return this.getResults(this.snapshotIterator, batchSize);
    }

    private List<MongoDomainEvent> getResults(MongoCursor<Document> iterator, int batchSize) {
        ArrayList<MongoDomainEvent> results = new ArrayList<MongoDomainEvent>();
        MongoCursor<Document> itr = iterator;
        while (results.size() < batchSize && itr.hasNext()) {
            Document document = (Document)itr.next();
            ArrayList events = (ArrayList)document.get((Object)"events");
            if (events != null) {
                events.forEach(doc -> results.add(this.toEvent(doc)));
                continue;
            }
            results.add(this.toEvent(document));
        }
        return results;
    }

    private MongoDomainEvent toEvent(Document document) {
        return new MongoDomainEvent(document.getString((Object)"timestamp"), document.getString((Object)"serializedPayload"), document.getString((Object)"serializedMetaData"), document.getString((Object)"eventIdentifier"), document.getString((Object)"payloadType"), document.getString((Object)"payloadRevision"), document.getString((Object)"type"), document.getString((Object)"aggregateIdentifier"), document.getLong((Object)"sequenceNumber").longValue());
    }
}

