/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster.replication.file;

import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.exception.LeadershipTransferInProgressException;
import java.io.File;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties {
    private long warnFreeSpace;
    private int forceInterval;
    private int validationSegments;
    private int syncInterval;
    private String logStorageFolder;
    private long secondaryCleanupDelay;
    private long minFreeSpace;
    private String indexSuffix;
    private int minActiveBackups;
    protected Boolean forceCleanMmapIndex;
    protected Boolean useMmapIndex;
    private int segmentSize;
    private int primaryCleanupDelay;
    private long numberOfSegments;
    private static final boolean WINDOWS;
    private int maxIndexesInMemory;
    private static final String FILENAME_PATTERN;
    private int flags;
    private String logSuffix;

    static {
        FILENAME_PATTERN = "%s" + File.separator + "%020d%s";
        WINDOWS = System.getProperty(LeadershipTransferInProgressException.E((Object)"\u0013 R=\u001d>\u0019"), StateChanged.E((Object)"RwhKyl")).toLowerCase().startsWith(LeadershipTransferInProgressException.E((Object)"\u000b:\u0012"));
    }

    public String getLogStorageFolder() {
        StorageProperties a;
        return a.logStorageFolder;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a;
        if (a.useMmapIndex != null) {
            return a.useMmapIndex;
        }
        return false;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a;
        return a.primaryCleanupDelay;
    }

    public long getSegmentSize() {
        StorageProperties a;
        return a.segmentSize;
    }

    public int getMinActiveBackups() {
        StorageProperties a;
        return a.minActiveBackups;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTempFile(String string, Long l2) {
        void a;
        Object a2 = l2;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.getStorage((String)a);
        objectArray[1] = a2;
        objectArray[2] = a3.indexSuffix + ".temp";
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File indexFile(String string, Long l2) {
        void a;
        Object a2 = l2;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.getStorage((String)a);
        objectArray[1] = a2;
        objectArray[2] = a3.indexSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setIndexSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.indexSuffix = a;
    }

    public void setMinActiveBackups(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.minActiveBackups = a;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a;
        if (a.forceCleanMmapIndex != null) {
            return a.forceCleanMmapIndex;
        }
        return WINDOWS;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a = bl;
        StorageProperties a2 = this;
        a2.forceCleanMmapIndex = a;
    }

    public void setUseMmapIndex(Boolean bl) {
        Object a = bl;
        StorageProperties a2 = this;
        a2.useMmapIndex = a;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        a2.minFreeSpace = a.toBytes();
    }

    public long minFreeSpace() {
        StorageProperties a;
        return a.minFreeSpace;
    }

    public void setNumberOfSegments(long a) {
        a.numberOfSegments = a;
    }

    public int getFlags() {
        StorageProperties a;
        return a.flags;
    }

    public long getSecondaryCleanupDelay() {
        StorageProperties a;
        return a.secondaryCleanupDelay;
    }

    public void setLogStorageFolder(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.logStorageFolder = a;
    }

    public int getForceInterval() {
        StorageProperties a;
        return a.forceInterval;
    }

    public long getSyncInterval() {
        StorageProperties a;
        return a.syncInterval;
    }

    public void setMaxIndexesInMemory(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.maxIndexesInMemory = a;
    }

    public void setValidationSegments(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.validationSegments = a;
    }

    public void setForceInterval(Duration duration) {
        Duration a = duration;
        StorageProperties a2 = this;
        a2.forceInterval = (int)a.toMillis();
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a;
        return a.maxIndexesInMemory;
    }

    public String getIndexSuffix() {
        StorageProperties a;
        return a.indexSuffix;
    }

    public void setSyncInterval(Duration duration) {
        Duration a = duration;
        StorageProperties a2 = this;
        a2.syncInterval = (int)a.toMillis();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.primaryCleanupDelay = a;
    }

    public void setLogSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.logSuffix = a;
    }

    public String getStorage(String string) {
        Object a = string;
        StorageProperties a2 = this;
        return a2.logStorageFolder + File.separator + (String)a;
    }

    public int getValidationSegments() {
        StorageProperties a;
        return a.validationSegments;
    }

    public long warnFreeSpace() {
        StorageProperties a;
        return a.warnFreeSpace;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        a2.warnFreeSpace = a.toBytes();
    }

    public long getNumberOfSegments() {
        StorageProperties a;
        return a.numberOfSegments;
    }

    public String getLogSuffix() {
        StorageProperties a;
        return a.logSuffix;
    }

    public void setSecondaryCleanupDelay(long a) {
        a.secondaryCleanupDelay = a;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        Assert.isTrue((a.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)LeadershipTransferInProgressException.E((Object)"/6\u001b>\u0019=\bs\u000f:\u00066\\>\t \bs\u001e6\\?\u0019 \u000fs\b;\u001d=\\aMgKgD`JgK"));
        Assert.isTrue((a.toBytes() > 0L ? 1 : 0) != 0, (String)StateChanged.E((Object)"O}{uyvh8oqf}<uikh8~}<usjy8hp}v<("));
        a2.segmentSize = (int)a.toBytes();
    }

    public StorageProperties() {
        StorageProperties a;
        StorageProperties storageProperties = a;
        StorageProperties storageProperties2 = a;
        StorageProperties storageProperties3 = a;
        StorageProperties storageProperties4 = a;
        StorageProperties storageProperties5 = a;
        StorageProperties storageProperties6 = a;
        StorageProperties storageProperties7 = a;
        StorageProperties storageProperties8 = a;
        storageProperties8.forceCleanMmapIndex = true;
        storageProperties8.syncInterval = 1000;
        storageProperties7.forceInterval = 1000;
        storageProperties7.logSuffix = ".log";
        storageProperties6.indexSuffix = ".index";
        storageProperties6.validationSegments = 2;
        storageProperties5.flags = 0;
        storageProperties5.primaryCleanupDelay = 5;
        storageProperties4.segmentSize = 0x1000000;
        storageProperties4.numberOfSegments = 1000L;
        storageProperties3.secondaryCleanupDelay = 30L;
        storageProperties3.logStorageFolder = "log";
        storageProperties2.minActiveBackups = 1;
        storageProperties2.maxIndexesInMemory = 5;
        storageProperties.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public File logFile(String string, Long l2) {
        void a;
        Object a2 = l2;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.getStorage((String)a);
        objectArray[1] = a2;
        objectArray[2] = a3.logSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setFlags(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.flags = a;
    }
}

