/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import db.callback.CleanupRepairs;
import db.callback.MigrateControlDB;
import db.callback.SeMigration;
import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.component.instance.Clients;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.f;
import io.axoniq.axonserver.enterprise.cluster.HealthBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.MatchingTagsNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.NodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.SubscriptionCountBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.internal.ClusterHealth;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.DefaultInstructionAckSource;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.command.CommandProviderInbound;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.localstorage.DefaultEventDecorator;
import io.axoniq.axonserver.localstorage.EventDecorator;
import io.axoniq.axonserver.localstorage.transformation.DefaultEventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.replication.ReplicationGroupProvider;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.flywaydb.core.api.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class AxonServerStandardConfiguration {
    private final Logger k = LoggerFactory.getLogger(AxonServerStandardConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={EventTransformerFactory.class})
    public EventTransformerFactory eventTransformerFactory() {
        return new DefaultEventTransformerFactory();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @Qualifier(value="queryInstructionAckSource")
    public InstructionAckSource<QueryProviderInbound> queryInstructionAckSource() {
        return new DefaultInstructionAckSource(a -> QueryProviderInbound.newBuilder().setAck(a).build());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public NodeSelectionStrategy nodeSelectionStrategy(CommandRegistrationCache commandRegistrationCache, QueryRegistrationCache queryRegistrationCache, ClientIdRegistry clientIdRegistry, Clients clients, MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterTagsCache clusterTagsCache, FeatureChecker featureChecker, ClusterHealth clusterHealth, ReplicationGroupProvider replicationGroupProvider) {
        void a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        AxonServerStandardConfiguration a9 = commandRegistrationCache;
        AxonServerStandardConfiguration a10 = this;
        a9 = new SubscriptionCountBasedNodeSelectionStrategy((CommandRegistrationCache)a9, (QueryRegistrationCache)a8, (ClientIdRegistry)a7, (Clients)a6, (MessagingPlatformConfiguration)a5);
        a9 = new MatchingTagsNodeSelectionStrategy((ClusterTagsCache)a4, (MessagingPlatformConfiguration)a5, (FeatureChecker)a3, (NodeSelectionStrategy)a9);
        return new HealthBasedNodeSelectionStrategy((ClusterHealth)a2, arg_0 -> ((ReplicationGroupProvider)a).replicationGroup(arg_0), (NodeSelectionStrategy)a9, a5.getName());
    }

    @Bean
    public DiskSpaceHealthIndicator diskSpaceHealthIndicator() {
        return null;
    }

    @Bean
    public ApplicationEventMulticaster applicationEventMulticaster() {
        AxonServerStandardConfiguration a;
        return new f(a);
    }

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    public FlywayMigrationStrategy cleanMigrateStrategy() {
        return a -> {
            a.repair();
            a.migrate();
        };
    }

    @Bean
    @Qualifier(value="platformInstructionAckSource")
    public InstructionAckSource<PlatformOutboundInstruction> platformInstructionAckSource() {
        return new DefaultInstructionAckSource(a -> PlatformOutboundInstruction.newBuilder().setAck(a).build());
    }

    @Bean
    @Qualifier(value="commandInstructionAckSource")
    public InstructionAckSource<SerializedCommandProviderInbound> commandInstructionAckSource() {
        return new DefaultInstructionAckSource(a -> new SerializedCommandProviderInbound(CommandProviderInbound.newBuilder().setAck(a).build()));
    }

    public AxonServerStandardConfiguration() {
        AxonServerStandardConfiguration a;
    }

    @Bean
    @Qualifier(value="taskScheduler")
    public ScheduledExecutorService scheduler() {
        return Executors.newScheduledThreadPool(10, (ThreadFactory)new DaemonThreadFactory(MessageJson.E((Object)"OsHy\u0016aXz^vN~^`")));
    }

    @Bean
    @ConditionalOnMissingBean(value={EventDecorator.class})
    public EventDecorator eventDecorator() {
        return new DefaultEventDecorator();
    }

    @Bean
    public FlywayConfigurationCustomizer flywayConfigurationCustomizer() {
        return a -> {
            Callback[] callbackArray = new Callback[3];
            callbackArray[0] = new CleanupRepairs();
            callbackArray[1] = new SeMigration();
            callbackArray[2] = new MigrateControlDB();
            a.callbacks(callbackArray);
        };
    }
}

