/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.transport.rest.v2.ResourcesRestControllerV2;
import io.axoniq.axonserver.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private boolean pluginsEnabled;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private Duration keepAliveTimeout;
    private final Map<String, Boolean> preview;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private String pluginCleanPolicy;
    private int executorThreadCount;
    private int port;
    private String controldbBackupLocation;
    private String internalHostname;
    private String pluginCacheDirectory;
    private static final Logger auditLog;
    private int internalPort;
    private int metricsSynchronizationRate;
    private int eventStoreProcessorsThreadCount;
    private String hostname;
    private int maxMessageSize;
    private String internalDomain;
    private final SystemInfoProvider systemInfoProvider;
    private int grpcBufferedMessages;
    private static final int RESERVED = 10000;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private String name;
    private int httpPort;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private String pidFileLocation;
    private int eventStoreBackgroundThreadCount;
    private String domain;
    private boolean setWebSocketAllowedOrigins;
    private Duration metricsInterval;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private int clusterExecutorThreadCount;
    private static final Logger logger;
    private Duration keepAliveTime;
    private String pluginPackageDirectory;
    private String webSocketAllowedOrigins;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private Duration minKeepAliveTime;

    public void setEventStoreProcessorsThreadCount(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.eventStoreProcessorsThreadCount = a;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a;
        return a.preview;
    }

    public void setPort(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.port = a;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a;
        if (a.maxMessageSize == 0) {
            return 4184304;
        }
        return a.maxMessageSize - 10000;
    }

    public void setPluginCleanPolicy(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.pluginCleanPolicy = a;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public void setInternalHostname(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.internalHostname = a;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a;
        return a.setWebSocketAllowedOrigins;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a;
        return a.pluginPackageDirectory;
    }

    public void setHostname(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.hostname = a;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a;
        return a.pluginCacheDirectory;
    }

    public void setExecutorThreadCount(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.executorThreadCount = a;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a;
        if (StringUtils.isEmpty((String)a.internalHostname)) {
            a.internalHostname = a.getHostname();
        }
        return a.internalHostname;
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a = eventTransformationConfiguration;
        MessagingPlatformConfiguration a2 = this;
        a2.eventTransformation = a;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a;
        return a.clusterExecutorThreadCount;
    }

    public void setMetricsInterval(Duration duration) {
        Object a = duration;
        MessagingPlatformConfiguration a2 = this;
        a2.metricsInterval = a;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a;
        MessagingPlatformConfiguration a2 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a;
        a.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a2;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a = bl;
        MessagingPlatformConfiguration a2 = this;
        a2.setWebSocketAllowedOrigins = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a;
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        String string3 = a2 = a2 ? MessageJson.E((Object)"{Uf^`UsW2") : "";
        if (StringUtils.isEmpty((String)a)) {
            logger.error(ResourcesRestControllerV2.E((Object)"p,F/Wc],GcW&G&A.Z-VcRcE\"_*WcH>[,@7]\"^&\u001d"), (Object)a2);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a2 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a.charAt(0))) {
            logger.warn(MessageJson.E((Object)"oz^2@oS}HfUsVw\u001bzZa\u001bp^wU2HwO2Za\u001bsU2rB\u001bs_vIwHa\u00152ozRa\u001b\u007fZk\u001bbI}_gXw\u001bgUeZ|Ow_2IwHgWfH<"), (Object)a2);
            return;
        }
        int n = a.indexOf(46);
        if (n != -1) {
            void a4;
            void a5;
            void v1 = a;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a5)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(ResourcesRestControllerV2.E((Object)"p,]%Z$F1Z-TcW,^\"Z-\u0013%A,^cH>[,@7]\"^&\u00133A,C&A7Jy\u0013+\\0G-R.V~H>\u001fcW,^\"Z-\u000e8N"), objectArray);
                a4.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a2;
            objectArray[1] = a;
            objectArray[2] = string4;
            objectArray[3] = a5;
            logger.warn(MessageJson.E((Object)"[\\|T`R|\\2_}VsR|\u001bbZ`O2Tt\u001bfSw\u001biFzTaO|Z\u007f^2\u001ciF5\u00012S}HfUsVw\u0006iF>\u001bvT\u007fZ{U/@o"), objectArray);
            a4.accept(string4, a5);
        }
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a = duration;
        MessagingPlatformConfiguration a2 = this;
        a2.keepAliveTimeout = a;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a;
        return a.keepAliveTimeout.toMillis();
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a;
        return a.internalPort;
    }

    private /* synthetic */ void G() {
        MessagingPlatformConfiguration a;
        if (a.datasourceUrl != null && !a.datasourceUrl.contains(MessageJson.E((Object)"(VwV(")) && !a.datasourceUrl.contains(ResourcesRestControllerV2.E((Object)"R;\\-@&A5V1\u001e \\-U*T'Q"))) {
            throw new FailedToStartException(MessageJson.E((Object)"FSw\u001bvZfZpZa^2UsVw\u001btT`\u001bSC}U2hwId^`\u001b\u007fNaO2Yw\u001b5ZjT|HwId^`\u0016qT|]{\\vY5\u00152rt\u001bkTg\u001bsIw\u001b\u007fRuIsO{Uu\u001btI}V2Z|\u001b}Wv^`\u001bd^`H{T|\u001bwUaN`^2OzZf\u001bfSw\u001bQT|O`T~\u001bVy2Ra\u001b{U2\u001csC}Ua^`MwI?X}UfI}WvY5\u001bsUv\u001bgKvZf^2Oz^2HbI{Uu\u0015vZfZaTgIq^<N`W2K`Tb^`Ok\u001bfT2Na^2_sOsYsHw\u001b|Z\u007f^2\u001csC}Ua^`MwI?X}UtRu_p\u001c<"));
        }
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a;
        return a.eventTransformation;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a;
        return a.pidFileLocation;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a;
        return a.minKeepAliveTime.toMillis();
    }

    public void setGrpcBufferedMessages(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.grpcBufferedMessages = a;
    }

    public void setInternalDomain(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.internalDomain = a;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a;
        if (a.internalDomain == null) {
            a.internalDomain = a.getDomain();
        }
        return a.internalDomain;
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.eventStoreBackgroundThreadCount = a;
    }

    public int getPort() {
        MessagingPlatformConfiguration a;
        return a.port;
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a = dataSize;
        MessagingPlatformConfiguration a2 = this;
        Assert.isTrue((a.toBytes() >= 0L ? 1 : 0) != 0, (String)ResourcesRestControllerV2.E((Object)"~\"Kc^&@0R$Vc@*I&\u0013.F0GcQ&\u0013$A&R7V1\u00137[\"]c\u0003"));
        Assert.isTrue((a.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)MessageJson.E((Object)"_Zj\u001b\u007f^aHs\\w\u001baRh^2VgHf\u001bp^2WwHa\u001bfSsU2\t#\u000f%\u000f*\b$\u000f%"));
        a2.maxMessageSize = (int)a.toBytes();
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a;
        return a.metricsInterval;
    }

    public String getName() {
        MessagingPlatformConfiguration a;
        if (a.name == null) {
            a.name = a.getHostname();
        }
        return a.name;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a;
        return a.forceConnectionToPrimaryOrMessagingNode;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a;
        return a.controldbBackupLocation;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a2;
            block1: {
                block2: {
                    a = sslConfiguration;
                    a2 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a != null) break block2;
                    if (a2.ssl == null) break block1;
                    auditLog.info(ResourcesRestControllerV2.E((Object)"\u0010`\u000f\u0013 \\-U*T6A\"G*\\-\u0013\u0011v\u000e|\u0015v\u0007\u001d"));
                    messagingPlatformConfiguration = a2;
                    break block3;
                }
                if (a2.ssl == null || a.isEnabled() != a2.ssl.isEnabled()) {
                    auditLog.info(MessageJson.E((Object)"hAw2Ra\u001b|Te\u001biF<"), (Object)AuditLog.enablement((boolean)a.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a2;
        }
        messagingPlatformConfiguration.ssl = a;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a = bl;
        MessagingPlatformConfiguration a2 = this;
        a2.pluginsEnabled = a;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a;
        messagingPlatformConfiguration.j();
        messagingPlatformConfiguration.E();
        messagingPlatformConfiguration.G();
    }

    public void setInternalPort(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.internalPort = a;
    }

    public void setPluginPackageDirectory(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.pluginPackageDirectory = a;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a;
        return a.ssl;
    }

    static {
        logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
        auditLog = AuditLog.getLogger();
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a;
        return a.pluginCleanPolicy;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a;
        return a.grpcBufferedMessages;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a;
        return a.executorThreadCount;
    }

    public void setPluginCacheDirectory(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.pluginCacheDirectory = a;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a;
        if (a.httpPort == 0) {
            a.httpPort = a.systemInfoProvider.getPort();
        }
        return a.httpPort;
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        return a2.preview.getOrDefault(a, false);
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a2;
            block1: {
                block2: {
                    a = accessControlConfiguration;
                    a2 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a != null) break block2;
                    if (a2.accesscontrol == null) break block1;
                    auditLog.info(ResourcesRestControllerV2.E((Object)"r P&@0\u0013 \\-G1\\/\u0013 \\-U*T6A\"G*\\-\u0013\u0011v\u000e|\u0015v\u0007\u001d"));
                    messagingPlatformConfiguration = a2;
                    break block3;
                }
                if (a2.accesscontrol == null || a.isEnabled() != a2.accesscontrol.isEnabled()) {
                    auditLog.info(MessageJson.E((Object)"SXq^aH2X}UfI}W2Ra\u001b|Te\u001biF<"), (Object)AuditLog.enablement((boolean)a.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a2;
        }
        messagingPlatformConfiguration.accesscontrol = a;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.clusterExecutorThreadCount = a;
    }

    public void setDomain(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.domain = a;
    }

    public void setName(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.name = a;
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a;
        return a.maxMessageSize;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a;
        return a.keepAliveTime.toMillis();
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a;
        return a.accesscontrol;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a = duration;
        MessagingPlatformConfiguration a2 = this;
        a2.minKeepAliveTime = a;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a) {
                logger.warn(MessageJson.E((Object)"x}N~_2U}O2_wOwI\u007fR|^2S}HfUsVw\u001btI}V2R|^f\u001bs_vIwHa\u00012@o"), (Object)a.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a;
        return a.webSocketAllowedOrigins;
    }

    public void setControldbBackupLocation(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.controldbBackupLocation = a;
    }

    private /* synthetic */ void j() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a;
            a.preview.forEach((string, bl) -> {
                Boolean a = bl;
                String a2 = string;
                if (Boolean.TRUE.equals(a)) {
                    auditLog.info(ResourcesRestControllerV2.E((Object)"\u0013A&E*V4\u0013,UcU&R7F1VcH>\u0013&]\"Q/V'\u001d"), (Object)a2);
                }
            });
            auditLog.info(ResourcesRestControllerV2.E((Object)"\u0000\\-U*T6A\"G*\\-\u0013*]*G*R/Z9V'\u00134Z7[c`\u0010\u007fcH>\u0013\"]'\u0013\"P V0@cP,]7A,_cH>\u001d"), (Object)AuditLog.enablement((boolean)a.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a.accesscontrol.isEnabled()));
        }
    }

    public void setPidFileLocation(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.pidFileLocation = a;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a = string;
        MessagingPlatformConfiguration a2 = this;
        a2.webSocketAllowedOrigins = a;
    }

    private /* synthetic */ void E() {
        MessagingPlatformConfiguration a;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a;
        messagingPlatformConfiguration.E(a.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a;
            MessagingPlatformConfiguration a2;
            Object a3 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
            messagingPlatformConfiguration.setHostname((String)a);
            messagingPlatformConfiguration.setDomain((String)a3);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a;
        messagingPlatformConfiguration2.E(a.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a;
            MessagingPlatformConfiguration a2;
            Object a3 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a);
            messagingPlatformConfiguration.setInternalDomain((String)a3);
        });
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a;
        return a.eventStoreProcessorsThreadCount;
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a;
        return a.pluginsEnabled;
    }

    public void setKeepAliveTime(Duration duration) {
        Object a = duration;
        MessagingPlatformConfiguration a2 = this;
        a2.keepAliveTime = a;
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a) {
                logger.warn(ResourcesRestControllerV2.E((Object)"\u0000\\6_'\u0013-\\7\u0013'V7V1^*]&\u0013+\\0G-R.VcU1\\.\u0013*]&GcR'W1V0@y\u00138N"), (Object)a.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a;
        return a.eventStoreBackgroundThreadCount;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a = n;
        MessagingPlatformConfiguration a2 = this;
        a2.metricsSynchronizationRate = a;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a = bl;
        MessagingPlatformConfiguration a2 = this;
        a2.forceConnectionToPrimaryOrMessagingNode = a;
    }
}

