/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.cluster.replication.file.StorageProperties;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.util.ObjectUtils;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="axoniq.axonserver.replication")
@Configuration
public class RaftProperties
extends StorageProperties {
    private boolean logCompactionEnabled;
    private boolean forceSnapshotOnJoin;
    private int maxEntriesPerBatch;
    private int initialElectionTimeout;
    private int flowBuffer;
    private int minElectionTimeout;
    private int snapshotFlowBuffer;
    private int heartbeatTimeout;
    private int waitForLeaderTimeout;
    private int maxReplicationRound;
    private int maxElectionTimeout;
    private final SystemInfoProvider systemInfoProvider;
    private int logRetentionHours;
    private int maxSnapshotChunksPerBatch;

    public int getMaxEntriesPerBatch() {
        RaftProperties a;
        return a.maxEntriesPerBatch;
    }

    public void setWaitForLeaderTimeout(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.waitForLeaderTimeout = a;
    }

    public int getHeartbeatTimeout() {
        RaftProperties a;
        return a.heartbeatTimeout;
    }

    public void setMaxReplicationRound(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.maxReplicationRound = a;
    }

    public void setMinElectionTimeout(Duration duration) {
        Duration a = duration;
        RaftProperties a2 = this;
        a2.minElectionTimeout = (int)a.toMillis();
    }

    public void setLogCompactionEnabled(boolean bl) {
        boolean a = bl;
        RaftProperties a2 = this;
        a2.logCompactionEnabled = a;
    }

    public int getInitialElectionTimeout() {
        RaftProperties a;
        return a.initialElectionTimeout;
    }

    public int getMaxElectionTimeout() {
        RaftProperties a;
        return a.maxElectionTimeout;
    }

    public boolean isLogCompactionEnabled() {
        RaftProperties a;
        return a.logCompactionEnabled;
    }

    public RaftProperties(SystemInfoProvider systemInfoProvider) {
        RaftProperties a;
        RaftProperties a2 = systemInfoProvider;
        RaftProperties raftProperties = a = this;
        RaftProperties raftProperties2 = a;
        RaftProperties raftProperties3 = a;
        RaftProperties raftProperties4 = a;
        RaftProperties raftProperties5 = a;
        RaftProperties raftProperties6 = a;
        RaftProperties raftProperties7 = a;
        raftProperties7.initialElectionTimeout = 0;
        raftProperties7.minElectionTimeout = 1000;
        raftProperties6.maxElectionTimeout = 2500;
        raftProperties6.heartbeatTimeout = 300;
        raftProperties5.maxEntriesPerBatch = 10;
        raftProperties5.flowBuffer = 1000;
        raftProperties4.snapshotFlowBuffer = 50;
        raftProperties4.maxSnapshotChunksPerBatch = 1000;
        raftProperties3.maxReplicationRound = 10;
        raftProperties3.logCompactionEnabled = true;
        raftProperties2.logRetentionHours = 1;
        raftProperties2.forceSnapshotOnJoin = true;
        raftProperties.waitForLeaderTimeout = -1;
        raftProperties.systemInfoProvider = a2;
    }

    public boolean isForceCleanMmapIndex() {
        RaftProperties a;
        if (a.forceCleanMmapIndex != null) {
            return a.forceCleanMmapIndex;
        }
        return a.systemInfoProvider.javaOnWindows();
    }

    public int getSnapshotFlowBuffer() {
        RaftProperties a;
        return a.snapshotFlowBuffer;
    }

    public boolean isUseMmapIndex() {
        RaftProperties a;
        return (Boolean)ObjectUtils.E((Object)a.useMmapIndex, (Object)true);
    }

    public boolean isForceSnapshotOnJoin() {
        RaftProperties a;
        return a.forceSnapshotOnJoin;
    }

    public int getFlowBuffer() {
        RaftProperties a;
        return a.flowBuffer;
    }

    public void setInitialElectionTimeout(Duration duration) {
        Duration a = duration;
        RaftProperties a2 = this;
        a2.initialElectionTimeout = (int)a.toMillis();
    }

    public int getMaxSnapshotChunksPerBatch() {
        RaftProperties a;
        return a.maxSnapshotChunksPerBatch;
    }

    public void setForceSnapshotOnJoin(boolean bl) {
        boolean a = bl;
        RaftProperties a2 = this;
        a2.forceSnapshotOnJoin = a;
    }

    public int getMaxReplicationRound() {
        RaftProperties a;
        return a.maxReplicationRound;
    }

    public int getLogRetentionHours() {
        RaftProperties a;
        return a.logRetentionHours;
    }

    public void setMaxSnapshotChunksPerBatch(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.maxSnapshotChunksPerBatch = a;
    }

    public void setFlowBuffer(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.flowBuffer = a;
    }

    public int getWaitForLeaderTimeout() {
        RaftProperties a;
        if (a.waitForLeaderTimeout == -1) {
            a.waitForLeaderTimeout = a.maxElectionTimeout;
        }
        return a.waitForLeaderTimeout;
    }

    public void setMaxElectionTimeout(Duration duration) {
        Duration a = duration;
        RaftProperties a2 = this;
        a2.maxElectionTimeout = (int)a.toMillis();
    }

    @PostConstruct
    public void validate() {
        RaftProperties a;
        RaftProperties raftProperties = a;
        Assert.isTrue((raftProperties.maxElectionTimeout > raftProperties.minElectionTimeout ? 1 : 0) != 0, (String)EmbeddedDBPropertiesProvider.E((Object)"1#\u0004b\u0019.\u0019!\b+\u0013,\\6\u0015/\u0019-\t6\\/\t1\bb\u001e'\\%\u000e'\u001d6\u00190\\6\u0014#\u0012b\u0011+\u0012b\u0019.\u0019!\b+\u0013,\\6\u0015/\u0019-\t6"));
    }

    public void setHeartbeatTimeout(Duration duration) {
        Duration a = duration;
        RaftProperties a2 = this;
        a2.heartbeatTimeout = (int)a.toMillis();
    }

    public void setSnapshotFlowBuffer(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.snapshotFlowBuffer = a;
    }

    public int getMinElectionTimeout() {
        RaftProperties a;
        return a.minElectionTimeout;
    }

    public void setLogRetentionHours(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.logRetentionHours = Math.max(a, 1);
    }

    public void setMaxEntriesPerBatch(int n) {
        int a = n;
        RaftProperties a2 = this;
        a2.maxEntriesPerBatch = a;
    }
}

