/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupJpa;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@Entity(name="Context")
@Table(name="adm_context")
class AdminContextJpa
implements Serializable,
AdminContext {
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;
    @ManyToOne
    @JoinColumn(name="replication_group_id")
    private AdminReplicationGroupJpa replicationGroup;
    @Column(name="META_DATA")
    @Lob
    private String metaData;
    @Id
    private String name;
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;

    protected AdminContextJpa() {
        AdminContextJpa a;
    }

    public void setMetaDataMap(Map<String, String> map) {
        Object a22 = map;
        AdminContextJpa a = this;
        a.metaData = null;
        try {
            a.metaData = new ObjectMapper().writeValueAsString(a22);
            return;
        }
        catch (JsonProcessingException a22) {
            a22.printStackTrace();
            return;
        }
    }

    public boolean equals(Object object) {
        Object a = this;
        Object a2 = object;
        if (a == a2) {
            return true;
        }
        if (a2 == null || a.getClass() != a2.getClass()) {
            return false;
        }
        a2 = (AdminContextJpa)a2;
        return Objects.equals(a.name, ((AdminContextJpa)a2).name);
    }

    AdminContextJpa(String string) {
        Object a = string;
        AdminContextJpa a2 = this;
        a2.name = a;
    }

    public boolean isChangePending() {
        AdminContextJpa a;
        if (a.changePending != null && a.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setMetaData(String string) {
        Object a = string;
        AdminContextJpa a2 = this;
        a2.metaData = a;
    }

    public String toString() {
        AdminContextJpa a;
        return "Context{name='" + a.name + "'}";
    }

    public Map<String, String> getMetaDataMap() {
        AdminContextJpa adminContextJpa = this;
        if (adminContextJpa.metaData == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)new ObjectMapper().readValue(adminContextJpa.metaData, Map.class);
        }
        catch (IOException a) {
            a.printStackTrace();
            return Collections.emptyMap();
        }
    }

    public AdminReplicationGroup getReplicationGroup() {
        AdminContextJpa a;
        return a.replicationGroup;
    }

    public String getMetaData() {
        AdminContextJpa a;
        return a.metaData;
    }

    public Date getPendingSince() {
        AdminContextJpa a;
        return a.pendingSince;
    }

    public void changePending(Boolean bl) {
        Boolean a = bl;
        AdminContextJpa a2 = this;
        a2.changePending = a;
        if (a2.changePending != null && a.booleanValue()) {
            AdminContextJpa adminContextJpa = a2;
            adminContextJpa.pendingSince = new Date();
            return;
        }
        a2.pendingSince = null;
    }

    public String getName() {
        AdminContextJpa a;
        return a.name;
    }

    public int hashCode() {
        AdminContextJpa a;
        Object[] objectArray = new Object[1];
        objectArray[0] = a.name;
        return Objects.hash(objectArray);
    }

    public void setReplicationGroup(AdminReplicationGroup adminReplicationGroup) {
        AdminContextJpa a = adminReplicationGroup;
        AdminContextJpa a2 = this;
        a2.replicationGroup = (AdminReplicationGroupJpa)a;
    }

    public void setName(String string) {
        Object a = string;
        AdminContextJpa a2 = this;
        a2.name = a;
    }
}

