/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.jpa.AdminContextJpa;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupMemberJpa;
import io.axoniq.axonserver.configuration.admin.jpa.ClusterNodeJpa;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

@Entity
@Table(name="adm_replication_group", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class AdminReplicationGroupJpa
implements AdminReplicationGroup {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminReplicationGroupMemberJpa> members;
    private String name;
    @Id
    private String replicationGroupId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminContextJpa> contexts;
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;

    AdminReplicationGroupJpa(String string) {
        AdminReplicationGroupJpa a;
        Object a2 = string;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a = this;
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a;
        adminReplicationGroupJpa.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa3 = a;
        adminReplicationGroupJpa.contexts = new HashSet();
        adminReplicationGroupJpa.name = a2;
    }

    public String getName() {
        AdminReplicationGroupJpa a;
        return a.name;
    }

    @PrePersist
    public void prePersist() {
        AdminReplicationGroupJpa a;
        if (a.replicationGroupId == null) {
            a.replicationGroupId = UUID.randomUUID().toString();
        }
    }

    public void addContext(AdminContext adminContext) {
        AdminReplicationGroupJpa a;
        AdminReplicationGroupJpa a2 = adminContext;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a = this;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.contexts.add((AdminContextJpa)a2);
    }

    public void setPendingSince(Date date) {
        Object a = date;
        AdminReplicationGroupJpa a2 = this;
        a2.pendingSince = a;
    }

    private static /* synthetic */ boolean E(AdminReplicationGroupMember adminReplicationGroupMember, AdminReplicationGroupMemberJpa adminReplicationGroupMemberJpa) {
        AdminReplicationGroupMember a = adminReplicationGroupMemberJpa;
        AdminReplicationGroupMember a2 = adminReplicationGroupMember;
        return a.getClusterNode().getName().equals(a2.getClusterNode().getName());
    }

    public Set<? extends AdminContext> getContexts() {
        AdminReplicationGroupJpa a;
        return a.contexts;
    }

    public void setChangePending(boolean bl) {
        boolean a = bl;
        AdminReplicationGroupJpa a2 = this;
        boolean bl2 = a;
        a2.changePending = bl2;
        if (bl2) {
            AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
            adminReplicationGroupJpa.pendingSince = new Date();
            return;
        }
        a2.pendingSince = null;
    }

    public void setReplicationGroupId(String string) {
        Object a = string;
        AdminReplicationGroupJpa a2 = this;
        a2.replicationGroupId = a;
    }

    public boolean equals(Object object) {
        Object a = this;
        Object a2 = object;
        if (a == a2) {
            return true;
        }
        if (a2 == null || a.getClass() != a2.getClass()) {
            return false;
        }
        a2 = (AdminReplicationGroupJpa)a2;
        return Objects.equals(a.name, ((AdminReplicationGroupJpa)a2).name);
    }

    public AdminContext addContext(String string) {
        Object a = string;
        AdminReplicationGroupJpa a2 = this;
        a = new AdminContextJpa((String)a);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
        a.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        Object object = a;
        adminReplicationGroupJpa.contexts.add(object);
        return object;
    }

    public void setName(String string) {
        Object a = string;
        AdminReplicationGroupJpa a2 = this;
        a2.name = a;
    }

    public void addMember(AdminReplicationGroupMember adminReplicationGroupMember) {
        AdminReplicationGroupJpa a = adminReplicationGroupMember;
        AdminReplicationGroupJpa a2 = this;
        a = a2.E((AdminReplicationGroupMember)a);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
        a.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.members.add(a);
    }

    @PreRemove
    public void preRemove() {
        AdminReplicationGroupJpa a;
        new HashSet(a.members).forEach(adminReplicationGroupMember -> {
            AdminReplicationGroupJpa a = adminReplicationGroupMember;
            AdminReplicationGroupJpa a2 = this;
            ((ClusterNodeJpa)a.getClusterNode()).removeReplicationGroup((AdminReplicationGroup)a2);
        });
        a.members.clear();
    }

    public String getReplicationGroupId() {
        AdminReplicationGroupJpa a;
        return a.replicationGroupId;
    }

    public boolean isChangePending() {
        AdminReplicationGroupJpa a;
        if (a.changePending != null && a.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    public void clearContexts() {
        AdminReplicationGroupJpa a;
        a.contexts.clear();
    }

    public Date getPendingSince() {
        AdminReplicationGroupJpa a;
        return a.pendingSince;
    }

    public Set<AdminReplicationGroupMember> getMembers() {
        AdminReplicationGroupJpa a;
        return new HashSet<AdminReplicationGroupMember>(a.members);
    }

    public int hashCode() {
        AdminReplicationGroupJpa a;
        Object[] objectArray = new Object[1];
        objectArray[0] = a.name;
        return Objects.hash(objectArray);
    }

    public void removeContext(AdminContext adminContext) {
        AdminReplicationGroupJpa a = adminContext;
        AdminReplicationGroupJpa a2 = this;
        a.setReplicationGroup(null);
        a2.contexts.remove(a);
    }

    public void removeMember(AdminReplicationGroupMember adminReplicationGroupMember) {
        AdminReplicationGroupJpa a = adminReplicationGroupMember;
        AdminReplicationGroupJpa a2 = this;
        a2.members.stream().filter(arg_0 -> AdminReplicationGroupJpa.E((AdminReplicationGroupMember)a, arg_0)).findFirst().ifPresent(adminReplicationGroupMemberJpa -> {
            AdminReplicationGroupJpa a = adminReplicationGroupMemberJpa;
            AdminReplicationGroupJpa a2 = this;
            AdminReplicationGroupJpa adminReplicationGroupJpa = a;
            adminReplicationGroupJpa.setReplicationGroup(null);
            adminReplicationGroupJpa.getClusterNode().getReplicationGroups().remove(a);
            a.setClusterNode(null);
            a2.members.remove(a);
        });
    }

    public void setContexts(Set<AdminContext> set) {
        Set<AdminContext> a = set;
        AdminReplicationGroupJpa a2 = this;
        a2.contexts = a.stream().map(adminContext -> {
            AdminReplicationGroupJpa a = adminContext;
            AdminReplicationGroupJpa a2 = this;
            if (a instanceof AdminContextJpa) {
                return (AdminContextJpa)a;
            }
            return new AdminContextJpa(a.getName());
        }).collect(Collectors.toSet());
    }

    protected AdminReplicationGroupJpa() {
        AdminReplicationGroupJpa a;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a;
        a.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a;
        adminReplicationGroupJpa.contexts = new HashSet();
    }

    public void setMembers(Set<AdminReplicationGroupMember> set) {
        Set<AdminReplicationGroupMember> a = set;
        AdminReplicationGroupJpa a2 = this;
        if (a != null) {
            a2.members = a.stream().map(adminReplicationGroupMember -> {
                AdminReplicationGroupJpa a = adminReplicationGroupMember;
                AdminReplicationGroupJpa a2 = this;
                if (a instanceof AdminReplicationGroupMemberJpa) {
                    return (AdminReplicationGroupMemberJpa)a;
                }
                throw new IllegalArgumentException("Expecting AdminReplicationGroupMemberJpa, got: " + a.getClass());
            }).collect(Collectors.toSet());
            return;
        }
        a2.members = null;
    }
}

