/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalCommandMessageHandler;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final Logger i;
    private final MessagingPlatformConfiguration m;
    private volatile boolean f;
    private final AdminConfigurationFactory h;
    private final ClusterTagsCache B;
    private final Limits b;
    private final ApplicationEventPublisher d;
    private final RemoteConnections D;
    private final CurrentNodeProvider I;
    private final AdminNodes k;

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a = string;
        ClusterController a2 = this;
        return Optional.ofNullable(a2.D.get((String)a));
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a;
        Object a2 = string;
        ClusterController clusterController2 = a = this;
        clusterController2.i.info(TaskPublisher.E((Object)"Hs`sxs,xcri,,mq"), a2);
        clusterController2.d.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a2));
        if (clusterController2.m.getName().equals(a2)) {
            ClusterController clusterController3 = a;
            clusterController = clusterController3;
            clusterController3.k.deleteAllByNameNot((String)a2);
            clusterController3.D.closeAll();
        } else {
            a.k.findById((String)a2).ifPresent(arg_0 -> a.E((String)a2, arg_0));
            clusterController = a;
        }
        clusterController.d.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a2));
        a.D.sync();
    }

    private /* synthetic */ void E(NodeInfo nodeInfo) {
        ClusterController a = nodeInfo;
        ClusterController a2 = this;
        if (a.getNodeName().equals(a2.m.getName())) {
            return;
        }
        a2.D.connect((NodeInfo)a, true);
    }

    public Set<String> remoteNodeNames() {
        ClusterController a;
        return a.D.nodes();
    }

    public boolean isRunning() {
        ClusterController a;
        return a.f;
    }

    public void closeConnection(String string) {
        Object a = string;
        ClusterController a2 = this;
        a2.D.disconnect((String)a);
    }

    public void deleteOtherNodes() {
        ClusterController a;
        ClusterController clusterController = a;
        a.k.deleteAllByNameNot(clusterController.getName());
        clusterController.D.sync();
    }

    public String getName() {
        ClusterController a;
        return a.getMe().getName();
    }

    private /* synthetic */ void E() {
        Object a;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.k.findById(clusterController2.m.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.k.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.m.getName();
                a = String.format(InternalCommandMessageHandler.E((Object)"\u001f\u001b.\u001c9\u0000(N2\u00018\u000b|\u0000=\u00039N4\u000f/N?\u0006=\u0000;\u000b8B|\u00009\u0019|\u0000=\u00039Ny\u001drN\u000f\u001a=\u001c(N\u001d\u00163\u0000\u000f\u000b.\u00189\u001c|\u00195\u001a4N.\u000b?\u0001*\u000b.\u0017|\b5\u00029@"), objectArray);
                throw new FailedToStartException((String)a);
            }
            ClusterController clusterController3 = clusterController;
            a = clusterController3.h.clusterNode(clusterController3.m.getName(), clusterController.m.getFullyQualifiedHostname(), clusterController.m.getFullyQualifiedInternalHostname(), clusterController.m.getPort(), clusterController.m.getInternalPort(), clusterController.m.getHttpPort());
            clusterController3.k.save((ClusterNode)a);
            return;
        }
        a = (ClusterNode)((Optional)object).get();
        if (!a.getInternalHostName().equals(clusterController.m.getFullyQualifiedInternalHostname()) || !a.getGrpcInternalPort().equals(clusterController.m.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a.getInternalHostName();
            objectArray[1] = a.getGrpcInternalPort();
            objectArray[2] = clusterController.m.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.m.getInternalPort();
            object = String.format(TaskPublisher.E((Object)"Uyd~sbb,xcri1\u007f6exxs~xmz,~cexxm{i9|y~b,>)e63h?,~me,udwbqir 6,xia,`mzys\u007f6)e63h8,Exw~b,WtybEidzs~6{\u007fx~,diuc`idu6j\u007f`s\""), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    @Transactional
    public void start() {
        ClusterController a;
        a.E();
        a.f = true;
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a;
        ClusterController a2 = nodeInfo;
        ClusterController clusterController = a = this;
        clusterController.E((NodeInfo)a2);
        clusterController.D.updateNodeInfo((NodeInfo)a2);
        clusterController.d.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a2));
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a;
        return a.k.findAll().peek(clusterNode -> {
            ClusterController a = clusterNode;
            ClusterController a2 = this;
            if (a == null) {
                return null;
            }
            a.setTags(a2.B.getClusterTags().getOrDefault(a.getName(), Collections.emptyMap()));
            return a;
        });
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a;
        void a2;
        ClusterController clusterController = this;
        if (a2.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.D.get((String)a2);
        ClusterNode clusterNode = a = remoteConnection == null ? (ClusterNode)clusterController.k.findById((String)a2).orElse(null) : remoteConnection.getClusterNode();
        if (a == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a);
    }

    private /* synthetic */ ClusterNode E(String string) {
        Object a = string;
        ClusterController a2 = this;
        if ((a = a2.D.get((String)a)) == null) {
            return null;
        }
        return a.getClusterNode();
    }

    public void publishEvent(Object object) {
        Object a = object;
        ClusterController a2 = this;
        a2.d.publishEvent(a);
    }

    public ClusterNode getNode(String string) {
        Object a = string;
        Object a2 = this;
        if (((String)a).equals(a2.getName())) {
            return a2.getMe();
        }
        a = a2.k.findById((String)a).orElseGet(() -> ((ClusterController)a2).E((String)a));
        return a2.E((ClusterNode)a);
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a;
        return a.D.activeConnections();
    }

    public boolean isActive(String string) {
        String a = string;
        ClusterController a2 = this;
        if (a.equals(a2.m.getName()) || a2.D.get(a) != null && a2.D.get(a).isConnected()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a = clusterController;
        ClusterController clusterController4 = a;
        ClusterController clusterController5 = a;
        ClusterController clusterController6 = a;
        a.i = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.m = messagingPlatformConfiguration2;
        clusterController6.k = clusterNodeRepository;
        clusterController5.h = adminConfigurationFactory2;
        clusterController5.B = clusterTagsCache2;
        clusterController4.d = applicationEventPublisher2;
        clusterController4.b = limits2;
        clusterController3.D = remoteConnections2;
        clusterController3.I = clusterController2;
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a;
        return a.nodes().filter(clusterNode -> {
            ClusterController a = clusterNode;
            ClusterController a2 = this;
            return a2.isActive(a.getName());
        });
    }

    private /* synthetic */ ClusterNode E(NodeInfo nodeInfo) {
        ClusterController a;
        ClusterController a2 = nodeInfo;
        ClusterController clusterController = a = this;
        clusterController.i.info(InternalCommandMessageHandler.E((Object)"/8\n|\u00003\n9N'\u0013"), (Object)a2);
        a2 = clusterController.h.clusterNode((NodeInfo)a2);
        return clusterController.k.save((ClusterNode)a2);
    }

    private /* synthetic */ void E(String string) {
        Object a = string;
        ClusterController a2 = this;
        if (a2.D.contains((String)a) || a2.m.getName().equals(a)) {
            return;
        }
        a2.b.getMaxClusterSize().ifPresent(arg_0 -> a2.E((String)a, arg_0));
    }

    public int getPhase() {
        return 50;
    }

    public ClusterNode getMe() {
        ClusterController a;
        ClusterController clusterController = a;
        return clusterController.E((ClusterNode)clusterController.I.get());
    }

    public void stop() {
        a.f = false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(String string, Integer n) {
        Integer a = n;
        ClusterController a2 = this;
        if (a2.D.size() + 1 >= a) {
            void a3;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a3);
        }
    }

    private /* synthetic */ void E(String string, ClusterNode clusterNode) {
        Object a = string;
        ClusterController a2 = this;
        a2.k.deleteById((String)a);
    }

    public boolean isAdminNode() {
        ClusterController a;
        return a.I.isAdmin();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a;
        return a.D.connections();
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a = nodeInfo;
        ClusterController a2 = this;
        ClusterController clusterController = a;
        a2.E(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a2.m.getName())) {
            ClusterController clusterController2 = a2;
            clusterController2.i.info(InternalCommandMessageHandler.E((Object)":.\u00175\u0000;N(\u0001|\u00043\u00072N+\u0007(\u0006|\r)\u001c.\u000b2\u001a|\u00003\n9N2\u000f1\u000bfN'\u0013"), (Object)a.getNodeName());
            return clusterController2.getMe();
        }
        if (a.getInternalHostName().equals(a2.m.getInternalHostname()) && a.getGrpcInternalPort() == a2.m.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, TaskPublisher.E((Object)"Umxbyx6fyex,u`c\u007fbid,aebd6\u007fwas,~cexxm{i6mxh6exxs~xmz,fcdx"));
        }
        ClusterNode clusterNode = a2.k.findById(a.getNodeName()).orElseGet(() -> a2.E((NodeInfo)a));
        if (!a2.D.contains(a.getNodeName())) {
            a2.E((NodeInfo)a);
        }
        return clusterNode;
    }
}

