/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.access.application.ApplicationRolesProvider;
import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.localstorage.file.ValidationResult;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final LogReplicationService L;
    private static final DataSize E = DataSize.ofMegabytes((long)32L);
    private final Supplier<ScheduledExecutorService> i;
    private final ExecutorService m;
    private final ApplicationEventPublisher f;
    private final LeaderElectionService h;
    private Server B;
    private final Logger b;
    private AdvancedTlsX509KeyManager.Closeable d;
    private boolean D;
    private final MessagingPlatformConfiguration I;
    private final List<AxonServerInternalService> k;

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a;
        void a2;
        void a3;
        void a4;
        void a5;
        MessagingClusterServer a6;
        MessagingClusterServer a7 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a6 = this;
        MessagingClusterServer messagingClusterServer2 = a6;
        MessagingClusterServer messagingClusterServer3 = a6;
        MessagingClusterServer messagingClusterServer4 = a6;
        messagingClusterServer4.b = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.I = a7;
        messagingClusterServer3.L = a5;
        messagingClusterServer3.h = a4;
        messagingClusterServer2.k = a3;
        messagingClusterServer2.i = a2;
        messagingClusterServer.f = a;
        messagingClusterServer.m = Executors.newFixedThreadPool(a7.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(ValidationResult.E((Object)"mh{wza|)k|kg{pav#")));
    }

    public int getPhase() {
        return 50;
    }

    public boolean isRunning() {
        MessagingClusterServer a;
        return a.D;
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void E(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a2 = new LinkedList(a.interceptors());
        if (a.requiresContextInterceptor()) {
            a2.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a, (List)a2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a;
            String string = ValidationResult.E((Object)"ja$]WB");
            if (messagingClusterServer.I.getSsl() != null && messagingClusterServer.I.getSsl().isEnabled()) {
                Object object = messagingClusterServer.I.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(ApplicationRolesProvider.E((Object)"!A/W)HnX8V.J%K6\\2\u00173J,\u0017#\\2MmZ(X)Wm_)U%\u0019.V4\u00193\\4"));
                }
                Object object2 = messagingClusterServer.I.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(ValidationResult.E((Object)"evk`m\u007f*o|aj}a|rkv w}h t|mxeza#ok}#bghk$`kz$}az"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.d = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.i.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a = NettyServerBuilder.forPort((int)messagingClusterServer.I.getInternalPort(), (ServerCredentials)object);
                string = ApplicationRolesProvider.E((Object)"\u0013j\f\u0019%W![,\\$");
                nettyServerBuilder = a;
            } else {
                a = NettyServerBuilder.forPort((int)messagingClusterServer.I.getInternalPort());
                nettyServerBuilder = a;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.I.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a.maxInboundMessageSize((int)Math.max(E.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.I.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.I));
            messagingClusterServer.k.forEach(arg_0 -> MessagingClusterServer.E((NettyServerBuilder)a, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a.addService((BindableService)messagingClusterServer.h);
            a.addService((BindableService)messagingClusterServer2.L);
            if (messagingClusterServer2.I.getKeepAliveTime() > 0L) {
                a.keepAliveTime(messagingClusterServer.I.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a.keepAliveTimeout(messagingClusterServer.I.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.I.getGrpcBufferedMessages()));
            a.executor((Executor)messagingClusterServer.m);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ValidationResult.E((Object)"mh{wza|)lk}w#"))));
                a.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ApplicationRolesProvider.E((Object)"#U5J4\\2\u00147V2R%Km"))));
                a.channelType(EpollServerSocketChannel.class);
            } else {
                a.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ValidationResult.E((Object)"mh{wza|)lk}w#"))));
                a.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ApplicationRolesProvider.E((Object)"#U5J4\\2\u00147V2R%Km"))));
                a.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.B = a.build();
            messagingClusterServer.B.start();
            messagingClusterServer.b.info(ValidationResult.E((Object)"O|aj.Wkvxa|$Mh{wza|$]a|rkv.wze|pk`.k`$~k|p4$uy.).\u007fs"), (Object)messagingClusterServer.I.getInternalPort(), (Object)string);
            messagingClusterServer.f.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.D = true;
            return;
        }
        catch (Exception a) {
            throw new FailedToStartException(ApplicationRolesProvider.E((Object)"\u0013M!K4P.^`x8V.\u0019\u0013\\2O%K`z,L3M%K`j%K6\\2\u0019&X)U%]`"), (Throwable)a);
        }
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.d != null) {
            messagingClusterServer.d.close();
        }
        messagingClusterServer.m.shutdown();
        try {
            if (!messagingClusterServer.B.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.b.debug(ApplicationRolesProvider.E((Object)"\u007f/K#\\&L,U9\u00193M/I0P.^`z,L3M%K`j%K6\\2"));
                messagingClusterServer2.B.shutdownNow();
            }
        }
        catch (InterruptedException a) {
            messagingClusterServer.b.debug(ValidationResult.E((Object)"M`pkv|q~pk`.`{vgji$}l{pjkyj.kh$gjza|joh.Evk`Wkvxa|"), (Throwable)a);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.D = false;
        messagingClusterServer.b.info(ApplicationRolesProvider.E((Object)"x8V.\u0019\u0013\\2O%K`z,L3M%K`j%K6\\2\u00193M/I0\\$"));
    }
}

