/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.axoniq.axonserver.websocket.WebsocketProcessorContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final MessagingPlatformConfiguration c;
    private final Map<String, RaftGroup> G;
    private final ReplicationGroupController L;
    public static final String E = "replication-logs";
    private final LifecycleController i;
    private final Map<String, Long> m;
    private final RaftGroupRepositoryManager f;
    private final ApplicationEventPublisher h;
    private final AtomicBoolean B;
    private final GrpcRaftGroupFactory b;
    private final FileSystemMonitor d;
    private final Logger D;
    private volatile boolean I;
    private final RaftProperties k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.I) {
            throw new IllegalStateException(WebsocketProcessorContext.E((Object)"$,\u0005?\u0012;W:\u0003(\u0005=\u00029X:\u001f<\u0003-\u0018>\u0019i\u001e'W9\u0005&\u0010;\u0012:\u0004"));
        }
        GrpcRaftController a2 = (RaftGroup)grpcRaftController.G.get(a);
        if (a2 != null) {
            return a2.localNode();
        }
        Map map = grpcRaftController.G;
        synchronized (map) {
            a2 = (RaftGroup)grpcRaftController.G.get(a);
            if (a2 == null) {
                void a3;
                if (grpcRaftController.E((String)a)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, EmbeddedDBPropertiesProvider.E((Object)".'\f.\u0015!\u001d6\u0015-\u0012b\u001b0\u00137\fb\u0018'\u0010'\b+\u0013,\\+\u0012b\f0\u0013%\u000e'\u000f1"));
                }
                a2 = grpcRaftController.E((String)a, (String)a3);
                a2.startAndWait(null);
            }
        }
        return a2.localNode();
    }

    public String getMyName() {
        GrpcRaftController a;
        return a.c.getName();
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a;
        Node a2;
        Object a3 = string2;
        GrpcRaftController a4 = this;
        a2 = Node.newBuilder().setNodeId((String)a3).setHost(a4.c.getFullyQualifiedInternalHostname()).setPort(a4.c.getInternalPort()).setNodeName((String)a2).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a4;
        a3 = grpcRaftController.E((String)a, (String)a3);
        a3.raftConfiguration().update(Collections.singletonList(a2));
        grpcRaftController.D.debug(WebsocketProcessorContext.E((Object)"$=\u0016;\u0003i\u0011;\u0018$W \u0019 \u0003\u001b\u0016/\u0003\u000e\u0005&\u00029W2\n"), (Object)a);
        Object object = a3;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    private /* synthetic */ MessagingPlatformException E(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a2.c.getName() + ": Not a member of " + (String)a);
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        return a2.L.findReplicationGroupByContext((String)a).map(arg_0 -> a2.getRaftNode(arg_0)).orElseThrow(() -> a2.E((String)a));
    }

    public boolean isRunning() {
        GrpcRaftController a;
        return a.I;
    }

    public RaftNode getRaftNode(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        if (!a2.I) {
            throw new IllegalStateException(WebsocketProcessorContext.E((Object)"\u0000\u0019 \u0003 \u0016%\u001e3\u0016=\u001e&\u0019i\u0018;W:\u001f<\u0003-\u0018>\u0019i\u001e'W9\u0005&\u0010;\u0012:\u0004"));
        }
        if (!a2.G.containsKey(a)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a2.c.getName() + ": Not a member of " + (String)a);
        }
        return ((RaftGroup)a2.G.get(a)).localNode();
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a;
        GrpcRaftController a2;
        Object a3 = string2;
        GrpcRaftController grpcRaftController = a2 = this;
        grpcRaftController.f.prepareDeleteNodeFromReplicationGroup((String)a, (String)a3);
        grpcRaftController.h.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a, (String)a3));
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a;
        return a.G.keySet();
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a = raftGroup;
        GrpcRaftController a2 = this;
        GrpcRaftController grpcRaftController = a;
        while (!grpcRaftController.localNode().B() || a.logEntryProcessor().c() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(EmbeddedDBPropertiesProvider.E((Object)"5,\b'\u000e0\t2\bb\u000b*\u0015.\u0019b\u000b#\u00156\u0015,\u001bb\b-\\ \u0019!\u0013/\u0019b\u0010'\u001d&\u00190"));
            }
        }
        return a.localNode();
    }

    public int electionTimeout() {
        GrpcRaftController a;
        return a.k.getMaxElectionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup E(String string, String string2) {
        Object a = string2;
        GrpcRaftController a2 = this;
        Map map = a2.G;
        synchronized (map) {
            void a3;
            block4: {
                GrpcRaftController grpcRaftController = a2;
                grpcRaftController.D.info(EmbeddedDBPropertiesProvider.E((Object)"\u0007?Fb\u0015,\u00156\\0\u00192\u0010+\u001f#\b+\u0013,\\%\u000e-\t2"), (Object)a3);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.G.get(a3);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a = a2.b.create((String)a3, (String)a);
            a.localNode().j(arg_0 -> a2.E((RaftGroup)a, arg_0));
            a2.G.put(a3, a);
            return a;
        }
    }

    public RaftGroup getRaftGroup(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        return (RaftGroup)a2.G.get(a);
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a;
        if (a.I) {
            a.G.forEach((string, raftGroup) -> {
                String a = raftGroup;
                String a2 = string;
                ((GrpcRaftGroup)a).E();
            });
        }
    }

    private /* synthetic */ boolean E(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        if (a2.m.getOrDefault(a, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(RaftNode raftNode, StateChanged stateChanged) {
        void a;
        void a2;
        GrpcRaftController grpcRaftController = this;
        void v0 = a2;
        Object a3 = v0.E();
        long l2 = a.j();
        if (v0.G() && !a2.E()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a3, l2));
            return;
        }
        if (a2.E() && !a2.G()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a3, () -> ((RaftNode)a).E(), l2));
            return;
        }
        if (a2.c()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a3, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a.j())) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a3, a.j(), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        GrpcRaftController a9;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a9 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a9;
        GrpcRaftController grpcRaftController5 = a9;
        GrpcRaftController grpcRaftController6 = a9;
        GrpcRaftController grpcRaftController7 = a9;
        a9.D = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a9;
        grpcRaftController7.G = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a9;
        grpcRaftController8.m = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a9;
        grpcRaftController7.B = new AtomicBoolean();
        grpcRaftController6.c = a8;
        grpcRaftController6.f = a7;
        grpcRaftController5.L = a6;
        grpcRaftController5.k = a5;
        grpcRaftController4.h = a4;
        grpcRaftController4.b = a3;
        grpcRaftController3.d = a2;
        grpcRaftController3.i = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(RaftGroup raftGroup, StateChanged stateChanged) {
        void a;
        GrpcRaftController a2 = stateChanged;
        GrpcRaftController a3 = this;
        a3.E(a.localNode(), (StateChanged)a2);
    }

    public boolean isHealthy(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        return a2.getRaftNodeForContext((String)a).c();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a;
        return a.f.contexts();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a;
        return a.G.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a;
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a == false) {
            a3.E((String)a2);
        }
        a3.G.remove(a2);
        GrpcRaftController grpcRaftController = a3;
        grpcRaftController.L.deleteReplicationGroup((String)a2, (boolean)a);
        grpcRaftController.h.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a2, (boolean)a));
    }

    public int getPhase() {
        return 100;
    }

    public void stop() {
        GrpcRaftController a;
        GrpcRaftController grpcRaftController = a;
        grpcRaftController.d.unregisterPath(E);
        grpcRaftController.G.forEach((string, raftGroup) -> {
            String a = raftGroup;
            String a2 = string;
            a.stop();
        });
        a.I = false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a2 = grpcRaftController;
        if (a == null) {
            void a3;
            a2.D.info(EmbeddedDBPropertiesProvider.E((Object)"9\u0001x\\\u0010\u00192\u0010+\u001f#\b+\u0013,\\%\u000e-\t2\\1\b#\u000e6\u0019&"), (Object)a.groupId());
            if (a3.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a2;
                grpcRaftController2.i.setCleanShutdown();
                grpcRaftController2.B.set(true);
                return;
            }
        } else {
            a2.D.warn(WebsocketProcessorContext.E((Object)"2\nsW\u001b\u00129\u001b \u0014(\u0003 \u0018'W.\u0005&\u00029W:\u0003(\u0005=W/\u0016 \u001b,\u0013"), (Object)a.groupId(), a);
        }
    }

    public boolean ready() {
        GrpcRaftController a;
        return a.B.get();
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a = new File(grpcRaftController.k.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.E((File)a);
        grpcRaftController2.d.registerPath(E, ((File)a).toPath(), grpcRaftController.k.minFreeSpace(), grpcRaftController.k.warnFreeSpace());
        a = grpcRaftController2.f.getMyReplicationGroups();
        a.forEach(replicationGroupMember -> {
            GrpcRaftController a = replicationGroupMember;
            GrpcRaftController a2 = this;
            a2.E(a.groupId(), a.nodeId());
        });
        grpcRaftController.I = true;
        AtomicInteger atomicInteger = new AtomicInteger(a.size());
        a.forEach(replicationGroupMember -> {
            GrpcRaftController a = replicationGroupMember;
            GrpcRaftController a2 = this;
            try {
                void a3;
                GrpcRaftController grpcRaftController = a2;
                grpcRaftController.D.info(EmbeddedDBPropertiesProvider.E((Object)"\u0007?Fb.'\f.\u0015!\u001d6\u0015-\u0012b\u001b0\u00137\fb\u000f6\u001d0\b+\u0012%"), (Object)a.groupId());
                ((RaftGroup)grpcRaftController.G.get(a.groupId())).start(a.role()).whenComplete((arg_0, arg_1) -> a2.E((ReplicationGroupMember)a, (AtomicInteger)a3, arg_0, arg_1));
                return;
            }
            catch (Exception a3) {
                a2.D.warn(WebsocketProcessorContext.E((Object)"\f4Mi1(\u001e%\u0012-W=\u0018i\u001e'\u001e=\u001e(\u001b \r,W;\u00129\u001b \u0014(\u0003 \u0018'0;\u0018<\u0007"), (Object)a.groupId(), (Object)a3);
                return;
            }
        });
        grpcRaftController.D.info(EmbeddedDBPropertiesProvider.E((Object)".'\f.\u0015!\u001d6\u0015-\u0012b\u001b0\u00137\fb\u001f-\u00126\u000e-\u0010.\u00190\\0\t,\u0012+\u0012%"));
        if (a.isEmpty()) {
            grpcRaftController.B.set(true);
        }
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        if ((a = (RaftGroup)a2.G.get(a)) != null) {
            return Optional.of(a.localNode());
        }
        return Optional.empty();
    }

    public String getMyLabel(List<Node> list) {
        Object a = list;
        GrpcRaftController a2 = this;
        a = a.iterator();
        while (a.hasNext()) {
            Node node = (Node)a.next();
            if (!node.getNodeName().equals(a2.c.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(WebsocketProcessorContext.E((Object)"\n\u0018<\u001b-W'\u0018=W/\u001e'\u0013i\u0014<\u0005;\u0012'\u0003i\u0019&\u0013,W \u0019i\u0019&\u0013,\u0004"));
    }

    private /* synthetic */ void E(String string) {
        Object a = string;
        GrpcRaftController a2 = this;
        a2.m.put(a, System.currentTimeMillis() + 2L * (long)a2.k.getMaxElectionTimeout());
    }
}

