/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.admin.application.api.EventProcessorInfo;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.logging.ClusterEventsLogger;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final TaskPublisher h;
    private final ClusterController B;
    private final LicenseManager b;
    private final Logger d;
    private final RaftGroupServiceFactory D;
    private final FeatureChecker I;
    private final AddressValidator k;

    private /* synthetic */ void E(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.I.getMaxClusterSize().ifPresent(n -> {
            Integer a = n;
            ClusterChangesHandler a2 = this;
            if (a2.B.nodes().count() >= (long)a.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a2.I.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a2 = clusterChangesHandler2.D.getLeader(RaftAdminGroup.E());
        if (!clusterChangesHandler2.B.getName().equals(a2)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a2);
        }
        a2 = clusterChangesHandler.B.getNode(a.getNodeName());
        if (!(a2 == null || a2.getInternalHostName().equals(a.getInternalHostName()) && a2.getGrpcInternalPort().equals(a.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, EventProcessorInfo.E((Object)"j)EfOl\u000b~B}C)_aN)XhFl\u000bgJdN)JgO)O`MoN{Ng_)Bg_lYgJe\u000baDz_)EhFl\u000bhEm\u000byD{_)JeYlJmR)NqBz_z"));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.k.validateAddress(a.getInternalHostName(), a.getGrpcInternalPort());
        a2 = clusterChangesHandler3.E();
        clusterChangesHandler3.D.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a2)).build();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a3 = clusterChangesHandler.B.getNode((String)a2);
        if (a3 == null) {
            return;
        }
        if (a3.getReplicationGroups().stream().anyMatch(a -> {
            if (a.getReplicationGroup() != null) {
                if (a.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(EventProcessorInfo.E((Object)"efOl\u000bz_`Ge\u000bdNdIlY)Do\u000bjDg_lS}X'"));
        }
        clusterChangesHandler.D.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a2).build().toByteArray());
    }

    public void deleteNode(String string) {
        String a = string;
        ClusterChangesHandler a2 = this;
        ClusterNode clusterNode = a2.B.getNode(a);
        if (clusterNode == null) {
            a2.d.info(ClusterEventsLogger.E((Object)"%l\rl\u0015lAG\u000em\u00043Ar\u001c)L)/f\u0005lAg\u000e}Ao\u000e|\u000fmO"), (Object)a);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.E((ClusterController)a2.B, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a2.h.publishScheduledTask(RaftAdminGroup.E(), UnregisterNodeTask.class.getName(), (Object)a, Duration.ofSeconds(1L));
        if (a.equals(a2.B.getName())) {
            a2.E(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a;
            ClusterChangesHandler a2 = adminReplicationGroupMember;
            ClusterChangesHandler a3 = this;
            a3.h.publishScheduledTask(RaftAdminGroup.E(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a, a2.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    private /* synthetic */ byte[] E() {
        ClusterChangesHandler a;
        return a.b.readLicense();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        ClusterChangesHandler a7;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a7 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a7;
        ClusterChangesHandler clusterChangesHandler5 = a7;
        a7.d = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.B = a6;
        clusterChangesHandler5.h = a5;
        clusterChangesHandler4.D = a4;
        clusterChangesHandler4.I = a3;
        clusterChangesHandler3.k = a2;
        clusterChangesHandler3.b = a;
    }
}

