/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public interface IndexManager {
    default public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        IndexManager a = backupIndexConfig;
        IndexManager a2 = this;
        throw new UnsupportedOperationException("Backing up the index via this method is not supported for " + a2.getClass().getSimpleName());
    }

    public void addExistingIndex(FileVersion var1);

    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String var1, long var2, long var4);

    public List<File> indexFiles(FileVersion var1);

    default public boolean canBatchIndexParallel() {
        return false;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion var1);

    public SegmentIndexEntries lastIndexEntries(String var1, long var2);

    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String var1, long var2, long var4, long var6, long var8, long var10);

    public void cleanup(boolean var1);

    default public void removeFromGlobalIndex(long a) {
    }

    public Mono<Void> activateVersion(FileVersion var1);

    public boolean remove(FileVersion var1);

    public void createIndex(FileVersion var1, Map<String, List<IndexEntry>> var2);

    public void createNewVersion(long var1, int var3, Map<String, List<IndexEntry>> var4);

    public boolean removeAllVersions(long var1);

    public void addToActiveSegment(Long var1, Map<String, List<IndexEntry>> var2);

    public Optional<Long> getLastSequenceNumber(String var1, EventStorageEngine.SearchHint var2, long var3);

    public long size();

    default public void complete(long a) {
        IndexManager a2;
        a2.complete(new FileVersion(a, 0));
    }

    public boolean validIndex(FileVersion var1);

    public void init();

    default public boolean limitedSegmentChecks() {
        return false;
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String var1, long var2, long var4, long var6, long var8);

    public Mono<Void> activateVersion(FileVersion var1, File var2);

    public void complete(FileVersion var1);

    public void addToActiveSegment(long var1, String var3, IndexEntry var4);

    public Stream<File> getBackupFilenames(long var1, int var3);
}

