/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.d;
import io.axoniq.axonserver.localstorage.query.QueryMetadata;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final String l;
    private final Counter C;
    private final EventType a;
    private static final String F = "aggregateMap";
    private final ConcurrentSkipListMap<FileVersion, d> j;
    private final ConcurrentNavigableMap<Long, Integer> c;
    private ScheduledFuture<?> G;
    private static final ScheduledExecutorService L;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> E;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> i;
    private final RemoteAggregateSequenceNumberResolver m;
    private final Supplier<IndexManager> f;
    private final AtomicLong h;
    private final MeterFactory.RateMeter B;
    protected final String b;
    private final MeterFactory.RateMeter d;
    private static final Logger D;
    protected final Supplier<StorageProperties> I;
    private final Counter k;

    /*
     * WARNING - void declaration
     */
    public Optional<Long> E(String string, int n, long l2) {
        void a42222;
        void a42222;
        void a;
        Map map;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a42222 : standardIndexManager.i.descendingKeySet()) {
            if (n2 >= a3) {
                return Optional.empty();
            }
            if (a42222 > a2 || (map = (Map)standardIndexManager.i.get(a42222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a42222 : standardIndexManager.c.entrySet()) {
            if (n2 >= a3) {
                return Optional.empty();
            }
            if ((Long)a42222.getKey() > a2) continue;
            map = standardIndexManager.E(new FileVersion(((Long)a42222.getKey()).longValue(), ((Integer)a42222.getValue()).intValue()), (String)a);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.f.get();
        Optional a42222 = Optional.empty();
        if (iterator != null) {
            Optional a42222 = iterator.E((String)a, (int)(a3 - n2), (long)a2);
        }
        if (a42222.isEmpty() && standardIndexManager.m != null && n2 < a3 && !standardIndexManager.c.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a42222 = standardIndexManager2.m.getLastSequenceNumber(standardIndexManager2.b, (String)a, (int)(a3 - n2), (Long)standardIndexManager.c.keySet().last() - 1L);
        }
        return a42222;
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a;
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager standardIndexManager = a = this;
        standardIndexManager.E((FileVersion)a2, (Map)standardIndexManager.i.get(a2.E()));
        a.i.remove(a2.E());
        a.j();
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        return Mono.defer(() -> a2.E((FileVersion)a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int E(long l2, long l3, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a;
        void a2;
        StandardIndexManager a3;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a4 = standardIndexManager;
        if (!(a3 = a3.range((long)a2, (long)a, EventType.I.equals((Object)a4.a))).isEmpty()) {
            void a5;
            void a6;
            a6.put(a5, a3);
        }
        return a3.size();
    }

    private /* synthetic */ void j() {
        StandardIndexManager a;
        StandardIndexManager standardIndexManager = a;
        standardIndexManager.h.set(standardIndexManager.c.keySet().stream().skip(((StorageProperties)a.I.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        d d2 = (d)a2.j.remove(a);
        if (d2 != null) {
            d2.close();
        }
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.E.remove(a);
        if (FileUtils.E((File)((StorageProperties)standardIndexManager.I.get()).index(a2.l, (FileVersion)a)) && FileUtils.E((File)((StorageProperties)a2.I.get()).bloomFilter(a2.l, (FileVersion)a))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a;
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = new HashMap();
        a2.forEach((arg_0, arg_1) -> StandardIndexManager.E((Map)a3, arg_0, arg_1));
        standardIndexManager.j((FileVersion)a, (Map)a3);
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        void a;
        void a2;
        StandardIndexManager standardIndexManager = this;
        for (Long l3 : standardIndexManager.i.descendingKeySet()) {
            StandardIndexManager a3 = (IndexEntries)((Map)standardIndexManager.i.get(l3)).get(a2);
            if (a3 == null || a3.firstSequenceNumber() >= a) continue;
            StandardIndexManager standardIndexManager2 = a3;
            return new SegmentIndexEntries(new FileVersion(l3.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a, EventType.I.equals((Object)standardIndexManager.a)));
        }
        if (!standardIndexManager.c.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a2, (long)a, ((Long)standardIndexManager.c.keySet().first()).longValue());
        }
        return null;
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a;
            block4: {
                a = fileVersion;
                StandardIndexManager a2 = this;
                if (!a2.c.containsKey(a.E()) || ((Integer)a2.c.get(a.E())).intValue() != a.E()) break block3;
                if (a2.E((FileVersion)a) == null || a2.E((FileVersion)a) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                D.warn(QueryMetadata.E((Object)"L%c(o *0ed|%f-n%~!*-d o<*\"e6*7o#g!d00dq9"), (Object)a, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, (Supplier)a);
    }

    private /* synthetic */ File E(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        return ((StorageProperties)a2.I.get()).index(a2.l, (FileVersion)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries E(FileVersion fileVersion, String string) {
        int n;
        void a;
        void a2;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.E((FileVersion)a2, (String)a)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a3 = standardIndexManager.E((FileVersion)a2);
                return a3.E((String)a);
            }
            catch (IndexNotFoundException a3) {
                return null;
            }
            catch (Exception a3) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a2.E() + " segment.", a3);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        return a2.E((FileVersion)a).E();
    }

    private /* synthetic */ boolean E(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        return ((StorageProperties)a2.I.get()).dataFile(a2.l, (FileVersion)a).exists();
    }

    private static /* synthetic */ void E(Map.Entry a) {
        ((d)a.getValue()).close();
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        void a;
        void a2;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.c.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a3 = standardIndexManager.E(fileVersion, (String)a2);
            if (a3 == null || a3.firstSequenceNumber() >= a) continue;
            StandardIndexManager standardIndexManager2 = a3;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a, EventType.I.equals((Object)standardIndexManager.a)));
        }
        IndexManager a4 = (IndexManager)standardIndexManager.f.get();
        if (a4 != null) {
            return a4.lastIndexEntriesFromClosedSegments((String)a2, (long)a, (Long)standardIndexManager.c.keySet().last() - 1L);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        StandardIndexManager a2;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a5 = standardIndexManager;
        if (a5.c.containsKey((long)a4)) {
            throw new IndexNotFoundException((long)a4 + ": already completed");
        }
        a5.i.computeIfAbsent((long)a4, a -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.E((IndexEntry)a2, arg_0)).add((IndexEntry)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void j(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a;
        StandardIndexManager a2 = this;
        StandardIndexManager a3 = fileVersion;
        if (a2.E((FileVersion)a3)) {
            a2.E((FileVersion)a3, (Map)a);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a2.f.get();
        if (standardIndexManager != null) {
            standardIndexManager.j((FileVersion)a3, (Map)a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        void a;
        void a2;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a3 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.D) ? ((StorageProperties)a3.I.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a3.E((String)a2, a222, (long)a);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.i.clear();
        standardIndexManager2.E.clear();
        standardIndexManager2.j.forEach((fileVersion, d2) -> {
            FileVersion a = d2;
            FileVersion a2 = fileVersion;
            a.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.j.clear();
        if (standardIndexManager3.G != null && !standardIndexManager.G.isDone()) {
            standardIndexManager.G.cancel(true);
        }
        if (a != false) {
            standardIndexManager.c.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.c.clear();
        StandardIndexManager a2 = (IndexManager)standardIndexManager4.f.get();
        if (a2 != null) {
            a2.cleanup((boolean)a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a;
        File file;
        Map a2;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.I.get();
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.E((File)(file = storageProperties.indexTemp(standardIndexManager.l, a.E())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a3 = maker2.hashMap(F, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.E()).createOrOpen();
                try {
                    a3.putAll(a2);
                    if (a3 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a3.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.l, (FileVersion)a).toPath(), copyOptionArray);
        }
        catch (IOException a3) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.l, (FileVersion)a), (Throwable)a3);
        }
        StandardIndexManager standardIndexManager2 = a3 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.l, (FileVersion)a).getAbsolutePath(), a2.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.j();
        standardIndexManager2.E(a2.keySet());
        standardIndexManager2.G();
        standardIndexManager.E.put(a, a3);
        standardIndexManager.c.put(a.E(), a.E());
        standardIndexManager.E((FileVersion)a);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a;
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        if (a3.c.containsKey(a2.E())) {
            return a3.E((FileVersion)a2, (File)a);
        }
        IndexManager indexManager = (IndexManager)a3.f.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a2, (File)a);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream E(StorageProperties storageProperties, Map.Entry entry) {
        void a;
        Map.Entry a2 = entry;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a.index(a3.l, ((Long)a2.getKey()).longValue());
        fileArray[1] = a.bloomFilter(a3.l, ((Long)a2.getKey()).longValue());
        return Stream.of(fileArray);
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        a2.c.put(a.E(), a.E());
        a2.j();
    }

    private static /* synthetic */ Mono E(File file, File file2) {
        File a = file2;
        File a2 = file;
        return Mono.fromSupplier(() -> a2).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a = a;
            File a2 = a2;
            return FileUtils.E((File)a2, (File)a);
        });
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a3 = (StorageProperties)standardIndexManager.I.get();
        return standardIndexManager.c.entrySet().stream().filter(arg_0 -> StandardIndexManager.E((long)a2, (int)a, arg_0)).flatMap(arg_0 -> standardIndexManager.E((StorageProperties)a3, arg_0));
    }

    private static /* synthetic */ Integer E(FileVersion fileVersion, Long l2, Integer n) {
        Integer a = n;
        FileVersion a2 = fileVersion;
        return a == null ? a2.E() : Math.max(a2.E(), a);
    }

    private static /* synthetic */ boolean E(long l2, int n, Map.Entry entry) {
        long a;
        Map.Entry a2 = entry;
        int a3 = n;
        if ((Long)a2.getKey() > a || (Integer)a2.getValue() > a3) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager a7;
        Object a8 = string;
        StandardIndexManager standardIndexManager = a7 = this;
        StandardIndexManager standardIndexManager2 = a7;
        StandardIndexManager standardIndexManager3 = a7;
        StandardIndexManager standardIndexManager4 = a7;
        a7.i = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a7;
        standardIndexManager4.E = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a7;
        a7.j = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a7;
        standardIndexManager3.c = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a7;
        standardIndexManager3.h = new AtomicLong();
        standardIndexManager3.I = a6;
        standardIndexManager2.l = a5;
        standardIndexManager2.b = a8;
        standardIndexManager.a = a4;
        standardIndexManager.m = a3;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8;
        stringArray[2] = "type";
        stringArray[3] = a4.name();
        a8 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a7;
        void v10 = a2;
        a7.B = a2.rateMeter((MetricName)BaseMetricName.ia, (Tags)a8);
        a7.d = v10.rateMeter((MetricName)BaseMetricName.da, (Tags)a8);
        standardIndexManager9.C = v10.counter((MetricName)BaseMetricName.ba, (Tags)a8);
        standardIndexManager9.k = a2.counter((MetricName)BaseMetricName.Xa, (Tags)a8);
        L.scheduleAtFixedRate(() -> {
            Object a;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.I.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.j.size() > storageProperties.getMaxIndexesInMemory()) {
                a = standardIndexManager.j.pollFirstEntry();
                D.debug(QueryMetadata.E((Object)"q90dI(e7c*mdc*n!rdq9"), (Object)standardIndexManager.b, a.getKey());
                standardIndexManager.G = L.schedule(() -> StandardIndexManager.E((Map.Entry)a), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.E.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a = standardIndexManager4.E.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                D.debug(GlobalSubscriptionMetricRegistry.E((Object)"5\u000ftR\u001c\u0017#\u001d8\u0017*R,\u001e!\u001d#R(\u001b\"\u0006+\u0000n\u0014!\u0000n\t3R(\u0000!\u001fn\u001f+\u001f!\u00007"), (Object)standardIndexManager5.b, a.getKey());
                standardIndexManager5.k.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a7.f = a;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a6 = standardIndexManager;
        a6((String)a5, (Supplier)a4, (String)a3, (EventType)a2, null, (MeterFactory)a, () -> null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> E(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        return Mono.fromSupplier(() -> a4.E((FileVersion)a3)).filter(a -> {
            if (!a.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.E((File)a2, arg_0)).doOnSuccess(arg_0 -> a4.E((FileVersion)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono E(FileVersion fileVersion) {
        void a;
        StandardIndexManager standardIndexManager = this;
        Object a2 = ((StorageProperties)standardIndexManager.I.get()).transformedIndex(standardIndexManager.l, (FileVersion)a);
        return standardIndexManager.activateVersion((FileVersion)a, (File)a2);
    }

    private /* synthetic */ void E(FileVersion fileVersion, Void void_) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        a2.c.put(a.E(), a.E());
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a;
        FileVersion a22;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a22;
                            void a4;
                            standardIndexManager2 = this;
                            a22 = new FileVersion((long)a4, (int)a22);
                            if (a == null) {
                                a = Collections.emptyMap();
                            }
                            if (!FileUtils.E((File)(a4 = ((StorageProperties)standardIndexManager2.I.get()).transformedIndex(standardIndexManager2.l, a22)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.I.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.I.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(F, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.E()).createOrOpen();
                try {
                    a.forEach((string, list) -> {
                        void a;
                        int n;
                        List a2 = list;
                        HTreeMap a3 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a2.get(0);
                        Integer[] integerArray = new Integer[a2.size()];
                        int n2 = n = 0;
                        while (n2 < a2.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a2.get(n3)).E();
                            n2 = n;
                        }
                        a3.put((Object)a, (Object)new StandardIndexEntries(indexEntry.j(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.I.get()).bloomFilter(standardIndexManager2.l, a22).getAbsolutePath(), a.keySet().size(), ((StorageProperties)standardIndexManager2.I.get()).getBloomIndexFpp());
        hTreeMap2.j();
        hTreeMap2.E(a.keySet());
        hTreeMap2.G();
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.I.get();
        String[] stringArray = FileUtils.E((File)new File(standardIndexManager.l), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a = FileUtils.E((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.l, (FileVersion)a).exists()) {
                standardIndexManager.c.compute(a.E(), (arg_0, arg_1) -> StandardIndexManager.E((FileVersion)a, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a);
            }
            n3 = ++n;
        }
        standardIndexManager.j();
    }

    private static /* synthetic */ IndexEntries E(IndexEntry indexEntry, String string) {
        Object a = string;
        IndexEntry a2 = indexEntry;
        return new StandardIndexEntries(a2.j());
    }

    static {
        D = LoggerFactory.getLogger(StandardIndexManager.class);
        L = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(QueryMetadata.E((Object)"c*n!rig%d%m!xi")));
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a = fileVersion;
        StandardIndexManager a2 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a2.I.get()).index(a2.l, (FileVersion)a);
        fileArray[1] = ((StorageProperties)a2.I.get()).bloomFilter(a2.l, (FileVersion)a);
        return Arrays.asList(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void E(Map map, String string2, List list) {
        void a;
        List a2 = list;
        Map a3 = map;
        a3.computeIfAbsent(a, string -> {
            String a = string;
            List a2 = a2;
            return new StandardIndexEntries(((IndexEntry)a2.get(0)).j());
        }).addAll(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(Long l2, String string, List list) {
        void a2;
        void a3;
        Object a4 = list;
        StandardIndexManager a5 = this;
        a5.i.computeIfAbsent(a3, a -> new ConcurrentHashMap()).computeIfAbsent(a2, arg_0 -> StandardIndexManager.E((List)a4, arg_0)).addAll((List)a4);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        Integer n;
        void a;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.I.get();
        if (standardIndexManager.i.remove((long)a) == null && (n = (Integer)standardIndexManager.c.remove((long)a)) != null) {
            FileVersion fileVersion;
            int a22;
            int n2 = a22 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a, a22);
                if (storageProperties.index(standardIndexManager.l, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a22;
            }
            FileVersion a22 = new FileVersion((long)a, n.intValue());
            fileVersion = (d)standardIndexManager.j.remove(a22);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.E.remove(a22);
        }
        if (FileUtils.E((File)storageProperties.index(standardIndexManager.l, (long)a)) && FileUtils.E((File)storageProperties.bloomFilter(standardIndexManager.l, (long)a))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ d E(FileVersion fileVersion2) {
        StandardIndexManager a = fileVersion2;
        StandardIndexManager a2 = this;
        try {
            return a2.j.computeIfAbsent(a, fileVersion -> {
                StandardIndexManager a = fileVersion;
                StandardIndexManager a2 = this;
                return new d(a2, (FileVersion)a);
            }).E();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a = (d)a2.j.remove(a);
            if (a != null) {
                a.close();
            }
            throw indexNotFoundException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a;
        void a2;
        void a3;
        void a4;
        long a5;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a6 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.c.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a5 < a4) {
                return a6;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.E(fileVersion, (String)a3);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.b;
            objectArray[1] = a3;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            D.debug(GlobalSubscriptionMetricRegistry.E((Object)"5\u000ftR\"\u001d!\u0019;\u0002\u000f\u0015)\u0000+\u0015/\u0006+R5\u000fn\u001b R=\u0017)\u001f+\u001c:R5\u000fn\u0014!\u0007 \u0016n\t3"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.E((long)a2, (long)a, (SortedMap)a6, fileVersion, indexEntries);
                if (standardIndexManager2.E((long)a2, (long)(a7 -= (long)n), indexEntries)) {
                    return a6;
                }
            }
            a5 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.f.get();
        if (indexManager != null) {
            void a7;
            a6.putAll(indexManager.lookupAggregateInClosedSegments((String)a3, (long)a2, (long)a, (long)a7, (long)a4, a5));
        }
        return a6;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean E(FileVersion fileVersion2, String string) {
        void a;
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        if ((a2 = a3.E.computeIfAbsent(a2, fileVersion -> {
            StandardIndexManager a = fileVersion;
            StandardIndexManager a2 = this;
            D.debug(QueryMetadata.E((Object)"q90de4o**&f+e)*\"c(~!xdl+xdq9"), (Object)a2.b, (Object)a.E());
            StorageProperties storageProperties = (StorageProperties)a2.I.get();
            a = new PersistedBloomFilter(storageProperties.bloomFilter(a2.l, (FileVersion)a).getAbsolutePath(), 0, 0.03f);
            if (!a.E()) {
                return null;
            }
            a2.C.increment();
            StandardIndexManager standardIndexManager = a;
            standardIndexManager.E();
            return standardIndexManager;
        })) != null && !a2.E((String)a)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean E(long l2, long l3, IndexEntries indexEntries) {
        void a;
        void a2;
        StandardIndexManager a3;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a4 = standardIndexManager;
        if (!a3.isEmpty() && a2 >= a3.firstSequenceNumber() || a <= 0L) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        void a;
        void a2;
        Iterator iterator;
        void a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = this;
        TreeMap a6 = new TreeMap();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.b;
        objectArray[1] = a5;
        objectArray[2] = (long)a4;
        objectArray[3] = (long)a3;
        D.debug(GlobalSubscriptionMetricRegistry.E((Object)"\t3Hn\u001e!\u001d%\u0007>3)\u0015<\u0017)\u0013:\u0017n\t3R#\u001b !+\u0003;\u0017 \u0011+<;\u001f,\u0017<R5\u000fbR\"\u0013=\u0006\u001d\u0017?\u0007+\u001c-\u0017\u0000\u0007#\u0010+\u0000n\t3"), objectArray);
        long l6 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.i.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l7 = (Long)iterator.next();
            if (l6 < a2) {
                return a6;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.i.getOrDefault(l7, Collections.emptyMap()).get(a5);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.E((long)a4, (long)a3, (SortedMap)a6, new FileVersion(l7.longValue(), 0), indexEntries);
                if (standardIndexManager2.E((long)a4, (long)(a -= (long)n), indexEntries)) {
                    return a6;
                }
            }
            l6 = l7;
            iterator2 = iterator;
        }
        TreeMap treeMap = a6;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a5, (long)a4, (long)a3, (long)a, (long)a2, l6));
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> map) {
        void a;
        Object a2 = l2;
        StandardIndexManager a3 = this;
        if (a3.c.containsKey(a2)) {
            throw new IndexNotFoundException((Long)a2 + ": already completed");
        }
        a.forEach((arg_0, arg_1) -> a3.E((Long)a2, arg_0, arg_1));
    }

    public long size() {
        return 0L;
    }

    private static /* synthetic */ IndexEntries E(List list, String string) {
        String a = string;
        List a2 = list;
        return new StandardIndexEntries(((IndexEntry)a2.get(0)).j());
    }
}

