/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.query.QueryMetadata;
import io.axoniq.axonserver.websocket.WebsocketProcessorContext;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private int flags;
    private String indexSuffix;
    private int primaryCleanupDelay;
    private int sksRocksdbCacheSize;
    private int readBufferSize;
    private int segmentSize;
    private boolean bulkIndexAllowParallel;
    private String newIndexSuffix;
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private int entriesPerSegment;
    private static final String FILE_FORMAT = "%020d%s";
    private int eventsPerSegmentPrefetch;
    private int segmentsForSequenceNumberCheck;
    private int globalIndexSegmentsCheck;
    private int sksMaxOpenedPositionIndexFiles;
    private long warnFreeSpace;
    private int maxIndexesInMemory;
    private String sksAggregateIdEncoder;
    private Boolean forceCleanMmapIndex;
    private int secondaryCleanupDelay;
    private Map<String, String> storages;
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private Duration[] retentionTime;
    private GlobalIndexPreload globalIndexPreload;
    private int maxBloomFiltersInMemory;
    private int validationSegments;
    private long minFreeSpace;
    private String indexFormat;
    private final SystemInfoProvider systemInfoProvider;
    private String globalIndexSuffix;
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private String sksPositionIndexFileSuffix;
    private long forceInterval;
    private Boolean forceClean;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private long syncInterval;
    private String eventsSuffix;
    private float bloomIndexFpp;
    private String bloomIndexSuffix;
    private int memoryMappedSegments;
    private boolean keepOldVersions;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private static final String PATH_FORMAT = "%s/%020d%s";
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private String storage;
    private boolean useMmapIndex;
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private Duration globalIndexPreloadTimeout;

    public void setSksAggregateIdEncoder(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.sksAggregateIdEncoder = a;
    }

    public StorageProperties withSksRocksdbCacheSize(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().sksRocksdbCacheSize = a;
        return a2.E();
    }

    public void setSksMaxOpenedPositionIndexFiles(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.sksMaxOpenedPositionIndexFiles = a;
    }

    public void setBloomIndexSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.bloomIndexSuffix = a;
    }

    public boolean isCleanRequired() {
        StorageProperties a;
        if (Boolean.TRUE.equals(a.forceClean) || a.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a;
        return a.eventsPerSegmentPrefetch;
    }

    public void setMemoryMappedSegments(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.memoryMappedSegments = a;
    }

    /*
     * WARNING - void declaration
     */
    public String getStorage(String string, String string2) {
        void a;
        Object a2 = string2;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.getStorage((String)a);
        objectArray[1] = a2;
        return String.format(WebsocketProcessorContext.E((Object)"R:Xl\u0004"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.bloomFilter((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File oldBloomFilter(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public void setFlags(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.flags = a;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        a2.warnFreeSpace = a.toBytes();
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration duration) {
        Object a = duration;
        StorageProperties a2 = this;
        a2.E().globalIndexPreloadTimeout = a;
        return a2.E();
    }

    /*
     * WARNING - void declaration
     */
    public File newTransformedIndex(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.transformedIndex((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setPrimaryCleanupDelay(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.primaryCleanupDelay = a;
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a;
        return a.maxBloomFiltersInMemory;
    }

    public void setRetentionTime(Duration[] durationArray) {
        Duration[] a = durationArray;
        Duration[] a2 = this;
        a2.retentionTime = a;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a = bl;
        StorageProperties a2 = this;
        a2.forceCleanMmapIndex = a;
    }

    public void setMaxIndexesInMemory(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.maxIndexesInMemory = a;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        Assert.isTrue((a.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)WebsocketProcessorContext.E((Object)"$,\u0010$\u0012'\u0003i\u0004 \r,W$\u0002:\u0003i\u0015,W%\u0012:\u0004i\u0003!\u0016'W{F}@}OzA}@"));
        Assert.isTrue((a.toBytes() > 0L ? 1 : 0) != 0, (String)QueryMetadata.E((Object)"\u0017o#g!d0*7c>odg1y0*&odm6o%~!xd~,k**t"));
        a2.segmentSize = (int)a.toBytes();
    }

    public StorageProperties withIndexFormat(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.E().indexFormat = a;
        return a2.E();
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.index((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setSksRocksdbCacheSize(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.sksRocksdbCacheSize = a;
    }

    public StorageProperties(SystemInfoProvider systemInfoProvider) {
        StorageProperties a;
        StorageProperties a2 = systemInfoProvider;
        StorageProperties storageProperties = a = this;
        StorageProperties storageProperties2 = a;
        StorageProperties storageProperties3 = a;
        StorageProperties storageProperties4 = a;
        StorageProperties storageProperties5 = a;
        StorageProperties storageProperties6 = a;
        StorageProperties storageProperties7 = a;
        StorageProperties storageProperties8 = a;
        StorageProperties storageProperties9 = a;
        StorageProperties storageProperties10 = a;
        StorageProperties storageProperties11 = a;
        a.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a;
        StorageProperties storageProperties14 = a;
        StorageProperties storageProperties15 = a;
        StorageProperties storageProperties16 = a;
        StorageProperties storageProperties17 = a;
        StorageProperties storageProperties18 = a;
        storageProperties18.segmentsForSequenceNumberCheck = 10;
        storageProperties18.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties17.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
        storageProperties17.entriesPerSegment = 1000000;
        storageProperties16.globalIndexPreload = GlobalIndexPreload.D;
        storageProperties16.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties15.sksPositionIndexFileSuffix = ".rindex";
        storageProperties15.sksAggregateIdEncoder = "plain";
        storageProperties14.sksMaxOpenedPositionIndexFiles = 100;
        storageProperties14.sksRocksdbCacheSize = (int)DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties13.bulkIndexAllowParallel = false;
        storageProperties13.systemInfoProvider = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setSecondaryCleanupDelay(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.secondaryCleanupDelay = a;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setUseMmapIndex(Boolean bl) {
        Boolean a = bl;
        StorageProperties a2 = this;
        a2.useMmapIndex = a;
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a;
        return a.globalIndexSegmentsCheck;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a;
        return a.primaryCleanupDelay;
    }

    public String getStorage(String string) {
        Object a = string;
        StorageProperties a2 = this;
        String string2 = (String)a2.storages.get(a);
        if (string2 == null) {
            if (PRIMARY_STORAGE_KEY.equals(a)) {
                return a2.storage;
            }
            Object object = a;
            throw new IllegalStateException("Storage " + (String)object + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + (String)object);
        }
        return string2;
    }

    public long getSyncInterval() {
        StorageProperties a;
        return a.syncInterval;
    }

    public void setBloomIndexFpp(float f2) {
        float a = f2;
        StorageProperties a2 = this;
        a2.bloomIndexFpp = a;
    }

    public void setForceClean(Boolean bl) {
        Object a = bl;
        StorageProperties a2 = this;
        a2.forceClean = a;
    }

    private /* synthetic */ StorageProperties E() {
        StorageProperties storageProperties = this;
        try {
            return (StorageProperties)storageProperties.clone();
        }
        catch (CloneNotSupportedException a) {
            throw new RuntimeException(a.getMessage(), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        return new File((String)a + File.separator + a3.dataFile((FileVersion)a2));
    }

    public StorageProperties withForceClean(boolean bl) {
        boolean a = bl;
        StorageProperties a2 = this;
        a2.E().forceClean = a;
        return a2.E();
    }

    public void setGlobalIndexSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.globalIndexSuffix = a;
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a;
        return a.secondaryCleanupDelay;
    }

    public String getNewIndexSuffix() {
        StorageProperties a;
        return a.newIndexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.newIndex((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a = globalIndexPreload;
        StorageProperties a2 = this;
        a2.E().globalIndexPreload = a;
        return a2.E();
    }

    public StorageProperties withMaxIndexesInMemory(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().maxIndexesInMemory = a;
        return a2.E();
    }

    public int getSksMaxOpenedPositionIndexFiles() {
        StorageProperties a;
        return a.sksMaxOpenedPositionIndexFiles;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a = dataSize;
        StorageProperties a2 = this;
        a2.minFreeSpace = a.toBytes();
    }

    public void setValidationSegments(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.validationSegments = a;
    }

    public void setEntriesPerSegment(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.entriesPerSegment = a;
    }

    public String getPrimaryStorage(String string) {
        Object a = string;
        StorageProperties a2 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2.storages.getOrDefault(PRIMARY_STORAGE_KEY, a2.storage);
        objectArray[1] = a;
        return String.format(QueryMetadata.E((Object)"ayk/7"), objectArray);
    }

    public String dataFile(FileVersion fileVersion) {
        StorageProperties a = fileVersion;
        StorageProperties a2 = this;
        if (a.E() == 0) {
            return a2.dataFile(a.E());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a.E();
        objectArray[1] = a.E();
        objectArray[2] = a2.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public long minFreeSpace() {
        StorageProperties a;
        return a.minFreeSpace;
    }

    public void setGlobalIndexSegmentsCheck(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.globalIndexSegmentsCheck = a;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setMaxBloomFiltersInMemory(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.maxBloomFiltersInMemory = a;
    }

    public long getRetentionTime(int n) {
        int a = n;
        StorageProperties a2 = this;
        if (a < 0 || a >= a2.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a2.retentionTime[a].toMillis();
    }

    public int getFlags() {
        StorageProperties a;
        return a.flags;
    }

    public boolean isKeepOldVersions() {
        StorageProperties a;
        return a.keepOldVersions;
    }

    public int getValidationSegments() {
        StorageProperties a;
        return a.validationSegments;
    }

    public int getEntriesPerSegment() {
        StorageProperties a;
        return a.entriesPerSegment;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a;
        if (a.forceCleanMmapIndex != null) {
            return a.forceCleanMmapIndex;
        }
        return a.systemInfoProvider.javaOnWindows();
    }

    public void setForceInterval(long a) {
        a.forceInterval = a;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.transformedIndex((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public String getSksPositionIndexFileSuffix() {
        StorageProperties a;
        return a.sksPositionIndexFileSuffix;
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().globalIndexSegmentsCheck = a;
        return a2.E();
    }

    public void setBulkIndexAllowParallel(boolean bl) {
        boolean a = bl;
        StorageProperties a2 = this;
        a2.bulkIndexAllowParallel = a;
    }

    public Boolean getForceClean() {
        StorageProperties a;
        return a.forceClean;
    }

    public String getSksAggregateIdEncoder() {
        StorageProperties a;
        return a.sksAggregateIdEncoder;
    }

    public void setEventsPerSegmentPrefetch(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.eventsPerSegmentPrefetch = a;
    }

    public int getSegmentSize() {
        StorageProperties a;
        return a.segmentSize;
    }

    public void setIndexFormat(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.indexFormat = a;
    }

    public boolean isBulkIndexAllowParallel() {
        StorageProperties a;
        return a.bulkIndexAllowParallel;
    }

    public void setGlobalIndexPreloadTimeout(Duration duration) {
        Object a = duration;
        StorageProperties a2 = this;
        a2.globalIndexPreloadTimeout = a;
    }

    /*
     * WARNING - void declaration
     */
    public File oldDataFile(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a;
        return a.globalIndexPreload;
    }

    public void setKeepOldVersions(boolean bl) {
        boolean a = bl;
        StorageProperties a2 = this;
        a2.keepOldVersions = a;
    }

    public String getIndexSuffix() {
        StorageProperties a;
        return a.indexSuffix;
    }

    public StorageProperties withBulkIndexAllowParallel(boolean bl) {
        boolean a = bl;
        StorageProperties a2 = this;
        a2.E().bulkIndexAllowParallel = a;
        return a2.E();
    }

    /*
     * WARNING - void declaration
     */
    public File transformedDataFile(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            throw new RuntimeException(WebsocketProcessorContext.E((Object)"\u0014(\u0019'\u0018=W=\u0005(\u0019:\u0011&\u0005$W=\u0018i\u0001,\u0005:\u001e&\u0019iG"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getSksRocksdbCacheSize() {
        StorageProperties a;
        return a.sksRocksdbCacheSize;
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a;
        return a.globalIndexPreloadTimeout;
    }

    public void setSksPositionIndexFileSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.sksPositionIndexFileSuffix = a;
    }

    public StorageProperties withSksMaxOpenedPositionIndexFiles(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().sksMaxOpenedPositionIndexFiles = a;
        return a2.E();
    }

    public void setStorages(Map<String, String> map) {
        Object a = map;
        StorageProperties a2 = this;
        if (a2.storages != null && a2.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a2.storages.putAll(a);
            return;
        }
        a2.storages = a;
    }

    public void setReadBufferSize(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.readBufferSize = a;
    }

    public String getBloomIndexSuffix() {
        StorageProperties a;
        return a.bloomIndexSuffix;
    }

    public StorageProperties withKeepOldVersions(boolean bl) {
        boolean a = bl;
        StorageProperties a2 = this;
        a2.E().keepOldVersions = a;
        return a2.E();
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a;
        return a.maxIndexesInMemory;
    }

    public float getBloomIndexFpp() {
        StorageProperties a;
        return a.bloomIndexFpp;
    }

    public void setIndexSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.indexSuffix = a;
    }

    public StorageProperties withRetentionTime(Duration[] durationArray) {
        Duration[] a = durationArray;
        Duration[] a2 = this;
        a2.E().retentionTime = a;
        return a2.E();
    }

    /*
     * WARNING - void declaration
     */
    public StorageProperties(SystemInfoProvider systemInfoProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        Object a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StorageProperties a8;
        StorageProperties storageProperties = object;
        Object object = string6;
        StorageProperties storageProperties2 = a8 = storageProperties;
        StorageProperties storageProperties3 = a8;
        StorageProperties storageProperties4 = a8;
        a8((SystemInfoProvider)a7);
        storageProperties4.eventsSuffix = a6;
        storageProperties4.indexSuffix = a5;
        storageProperties3.bloomIndexSuffix = a4;
        storageProperties3.globalIndexSuffix = a3;
        storageProperties2.newIndexSuffix = a2;
        storageProperties2.sksPositionIndexFileSuffix = a;
    }

    public long getForceInterval() {
        StorageProperties a;
        return a.forceInterval;
    }

    public void setEventsSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.eventsSuffix = a;
    }

    public StorageProperties withSksAggregateIdEncoder(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.E().sksAggregateIdEncoder = a;
        return a2.E();
    }

    public long warnFreeSpace() {
        StorageProperties a;
        return a.warnFreeSpace;
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a;
        return a.segmentsForSequenceNumberCheck;
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a;
        return a.globalIndexSuffix;
    }

    public StorageProperties withSegmentSize(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().segmentSize = a;
        return a2.E();
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().segmentsForSequenceNumberCheck = a;
        return a2.E();
    }

    public int getReadBufferSize() {
        StorageProperties a;
        return a.readBufferSize;
    }

    public String getIndexFormat() {
        StorageProperties a;
        return a.indexFormat;
    }

    public void setSyncInterval(long a) {
        a.syncInterval = a;
    }

    /*
     * WARNING - void declaration
     */
    public File oldIndex(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a;
        return a.storages;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, FileVersion fileVersion) {
        void a;
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.E() == 0) {
            return a3.newIndexTemp((String)a, a2.E());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a;
        objectArray[1] = a2.E();
        objectArray[2] = a2.E();
        objectArray[3] = a3.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a = globalIndexPreload;
        StorageProperties a2 = this;
        a2.globalIndexPreload = a;
    }

    public String getEventsSuffix() {
        StorageProperties a;
        return a.eventsSuffix;
    }

    public StorageProperties withMaxBloomFiltersInMemory(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.E().maxBloomFiltersInMemory = a;
        return a2.E();
    }

    public void setStorage(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.storage = a;
        if (a2.storages != null) {
            if (!a2.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a2.storages.put(PRIMARY_STORAGE_KEY, a);
                return;
            }
        } else {
            a2.storages = new HashMap();
            a2.storages.put(PRIMARY_STORAGE_KEY, a);
        }
    }

    public void setNewIndexSuffix(String string) {
        Object a = string;
        StorageProperties a2 = this;
        a2.newIndexSuffix = a;
    }

    public void setSegmentsForSequenceNumberCheck(int n) {
        int a = n;
        StorageProperties a2 = this;
        a2.segmentsForSequenceNumberCheck = a;
    }

    public String dataFile(long a) {
        StorageProperties a2;
        Object[] objectArray = new Object[2];
        objectArray[0] = a;
        objectArray[1] = a2.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, long l2) {
        void a;
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = (long)a;
        objectArray[2] = a3.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public int getMemoryMappedSegments() {
        StorageProperties a;
        return a.memoryMappedSegments;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a;
        return a.useMmapIndex;
    }
}

