/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.enterprise.replication.admin.PluginChangesHandler;
import io.axoniq.axonserver.logging.b;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger k = AuditLog.getLogger();

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a = adminUserDeleted;
        AuditLog a2 = this;
        if (k.isDebugEnabled()) {
            k.debug(a.toString());
        }
    }

    public static String username(String a) {
        if (a == null) {
            return PluginChangesHandler.E((Object)"\u00172E<E*F<^ \u0015");
        }
        return StringUtils.sanitize((String)a);
    }

    public static String username(Principal a) {
        if (a == null) {
            return ClientEventProcessorInfo.E((Object)"\u0018\u000bJ\u0005J\u0013I\u0005Q\u0019\u001a");
        }
        return StringUtils.sanitize((String)a.getName());
    }

    public static String enablement(boolean a) {
        if (a) {
            return PluginChangesHandler.E((Object)"n\u001dj\u0011g\u0016o");
        }
        return ClientEventProcessorInfo.E((Object)".m9e(h/`");
    }

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a = abstractAuthenticationEvent;
        AuditLog a2 = this;
        if (a instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a.getAuthentication();
        if (k.isDebugEnabled()) {
            k.debug(a.toString());
            return;
        }
        if (a instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            k.info(PluginChangesHandler.E((Object)"g<L:Es\\:_;\u000b&X6Y=J>Ns\t(Vq\u0005"), (Object)authentication.getName());
            return;
        }
        if (a instanceof AbstractAuthenticationFailureEvent) {
            a = (AbstractAuthenticationFailureEvent)a;
            k.error(ClientEventProcessorInfo.E((Object)"h\u0005C\u0003JJS\u0003P\u0002\u0004\u001fW\u000fV\u0004E\u0007AJ\u0006\u0011YH\u0004,e#h/`P\u0004\u0011Y"), (Object)authentication.getName(), (Object)a.getException().getMessage());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a = adminUserUpdated;
        AuditLog a2 = this;
        if (k.isDebugEnabled()) {
            k.debug(a.toString());
        }
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + b.k.E()[2].getName()));
    }

    public AuditLog() {
        AuditLog a;
    }
}

