/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.subscription.metric.ApplicationSubscriptionMetricRegistry;
import io.axoniq.axonserver.transport.rest.ResponseEntityFactory;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final long b;
    private final int d = 25000;
    private final Logger D;
    private final Map<String, ActiveQuery> I;
    private final long k;

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.D = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.d = 25000;
        QueryCache queryCache3 = this;
        queryCache.I = new ConcurrentHashMap();
        queryCache.k = defaultQueryTimeout;
        if (a > 0L) {
            this.b = a;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.b = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    private /* synthetic */ void E() {
        QueryCache a;
        if ((long)a.I.size() >= a.b) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a.b + "/" + a.b + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(ActiveQuery activeQuery, String string) {
        void a;
        Object a2 = string;
        QueryCache a3 = this;
        a3.D.debug(ApplicationSubscriptionMetricRegistry.E((Object)"w'Y8X-@-\u00149A-F1\u00143IhR'FhE=Q:Mh\\)Z,X-Fh],Q&@!R!Q,\u0014*MhW$]-Z<g<F-U%},\u00143If"), (Object)a.c(), a2);
        if (a.E((String)a2)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            if (a.E((String)a2, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(ResponseEntityFactory.E((Object)"Azl{gvv|m{\"am5jtlqnpp5'f\"ymfv"), objectArray))) {
                a3.remove(a.c());
            }
        }
    }

    public int size() {
        QueryCache a;
        return a.I.size();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a;
        QueryCache a2 = activeQuery;
        QueryCache a3 = this;
        a3.E((ActiveQuery)a2, a.G());
    }

    public boolean isEmpty() {
        QueryCache a;
        return a.I.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a;
        QueryCache a2;
        QueryCache a3 = activeQuery;
        QueryCache queryCache = a2 = this;
        queryCache.E();
        return (ActiveQuery)queryCache.I.putIfAbsent(a, a3);
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a;
        return a.I.entrySet();
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a = queryHandlerDisconnected;
        QueryCache a2 = this;
        a2.I.forEach((arg_0, arg_1) -> a2.E((TopologyEvents.QueryHandlerDisconnected)a, arg_0, arg_1));
    }

    public ActiveQuery get(String string) {
        Object a = string;
        QueryCache a2 = this;
        return (ActiveQuery)a2.I.get(a);
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a3;
        long l2 = System.currentTimeMillis() - a3.k;
        return a3.entrySet().stream().filter(a2 -> {
            if (((ActiveQuery)a2.getValue()).E() < l2) {
                return true;
            }
            return false;
        }).filter(a -> {
            if (!((ActiveQuery)a.getValue()).E()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public ActiveQuery remove(String string) {
        QueryCache a;
        Object a2 = string;
        QueryCache queryCache = a = this;
        queryCache.D.debug(ResponseEntityFactory.E((Object)"Ppoztp\"xgfqtepKq\"n\u007f"), a2);
        return (ActiveQuery)queryCache.I.remove(a2);
    }
}

