/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.managed.ManagedAxonServerClientStatusService;
import io.axoniq.axonserver.message.command.CommandExecutionException;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final Predicate<String> E;
    private static final Logger i;
    public static final String m = "_none";
    private final FeatureChecker f;
    private final RaftConfigServiceFactory h;
    private final ApplicationEventPublisher B;
    private final DistributeLicenseService b;
    private final ClusterTemplateController d;
    private final ClusterTopology D;
    private final ClusterController I;
    private static final Logger k;

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void E(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a = clusterRestController;
        k.info(ManagedAxonServerClientStatusService.E((Object)" 7\u0006\u0011[\u001e\u001e=\u000e)\b8[/\u00179\b8\u001e>[8\u001e!\u000b \u001a8\u001el\u001f#\f\"\u0017#\u001a(U"), (Object)AuditLog.username((Principal)object));
        if (a.D.isAdminNode()) {
            ServletOutputStream resp;
            object = CommandExecutionException.E((Object)"\u000ff\u0019y\u0018o\u001e'\u0018o\u0001z\u0000k\u0018oBs\u0001f");
            String string = a.d.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(ManagedAxonServerClientStatusService.E((Object)"\u000f)\u00038T<\u0017-\u0012\"@l\u0018$\u001a>\b)\u000fq\u000e8\u001daC"));
            v1.addHeader(CommandExecutionException.E((Object)"I\u0003d\u0018o\u0002~AN\u0005y\u001ce\u001fc\u0018c\u0003d"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(ManagedAxonServerClientStatusService.E((Object)"\"#\u000el\u0018-\u0015l\u000e?\u001el\u000f$\u0012?[*\u000e\"\u00188\u0012#\u0015-\u0017%\u000f5[#\u0015 \u0002l\u001d>\u0014![-\u001f!\u0012\"[\"\u0014(\u001e"));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterRestController a8;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a8 = clusterRestController;
        ClusterRestController clusterRestController4 = a8;
        ClusterRestController clusterRestController5 = a8;
        ClusterRestController clusterRestController6 = a8;
        a8.E = new ContextNameValidation();
        a8.I = a7;
        clusterRestController5.h = a6;
        clusterRestController5.f = a5;
        clusterRestController4.b = a4;
        clusterRestController4.B = a3;
        clusterRestController3.D = a2;
        clusterRestController3.d = a;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void E(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a;
        ClusterRestController clusterRestController = this;
        k.info(CommandExecutionException.E((Object)"7q\u0011WLX\t{\u0019o\u001f~Lf\u0005i\td\u001foL\u007f\u001cn\r~\t$"), (Object)AuditLog.username((Principal)a));
        i.info(ManagedAxonServerClientStatusService.E((Object)"\u0002\u001e;[ \u0012/\u001e\"\b)[9\u000b \u0014-\u001f)\u001f`[<\u001e>\u001d#\t!\u0012\"\u001cl\u0017%\u0018)\u0015?\u001el\u000e<\u001f-\u000f)UbU"));
        try {
            void licenseFile;
            clusterRestController.b.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, CommandExecutionException.E((Object)"D\u0003*\u0000o\rn\txLl\u0003xLU\rn\u0001c\u0002$LO\u0002y\u0019x\t*\u0018b\r~L~\u0004oLU\rn\u0001c\u0002*\u001eo\u001cf\u0005i\r~\u0005e\u0002*\u000bx\u0003\u007f\u001c*\u0005yLi\u001eo\r~\tnLh\tl\u0003x\t*\u0019z\u0000e\rn\u0005d\u000b*\r*\u0000c\u000fo\u0002y\t$"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @PostMapping
    public ResponseEntity<RestResponse> E(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        k.info(CommandExecutionException.E((Object)"7q\u0011WLX\t{\u0019o\u001f~L~\u0003*\u0006e\u0005dLi\u0000\u007f\u001f~\txLk\u0018*\u0017wVq\u0011$"), objectArray);
        a = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.I.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, ManagedAxonServerClientStatusService.E((Object)"8-\u0015\"\u00148[/\u0014!\u0019%\u0015)[&\u0014%\u0015%\u0015+[/\u0014\"\u000f)\u00038[;\u00128\u0013l\u0015#8#\u00158\u001e4\u000f?U"));
            }
            if (!RaftAdminGroup.E((String)string) && !jsonClusterNode.E.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            i.debug(CommandExecutionException.E((Object)"\rn\b\"E0LX\tm\u0005y\u0018o\u001ec\u0002mLg\u0015y\tf\n*\rd\b*\rn\bc\u0002mLg\t*\u0018eLi\u0003d\u0018o\u0014~L(\u0017wN$"), (Object)string);
            clusterRestController = jsonClusterNode;
            a.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            i.debug(ManagedAxonServerClientStatusService.E((Object)"\u001a(\u001fdRv[\u001e\u001e+\u0012?\u000f)\t%\u0015+[!\u0002?\u001e \u001dl\u001a\"\u001fl\u001a(\u001f%\u0015+[!\u001el\u000f#[\"\u0014l\u0018#\u00158\u001e4\u000f?U"));
            clusterRestController = jsonClusterNode;
            a.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            i.debug(CommandExecutionException.E((Object)"\rn\b\"E0LX\tm\u0005y\u0018o\u001ec\u0002mLg\u0015y\tf\n*\rd\b*\rn\bc\u0002mLg\t*\u0018eLk\u0000fLi\u0003d\u0018o\u0014~\u001f$"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.I.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, ManagedAxonServerClientStatusService.E((Object)"\u0002\u0014(\u001el\u001a \t)\u001a(\u0002l\t)\u001c%\b8\u001e>\u001e([%\u0015l\u001al\u0018 \u000e?\u000f)\t")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.h.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a.build());
            clusterRestController4.B.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, CommandExecutionException.E((Object)"-i\u000fo\u001c~\tnL`\u0003c\u0002*\u001eo\u001d\u007f\ty\u0018&Lg\rsL~\ra\t*\r*\u001bb\u0005f\t*\u0018eLz\u001ee\u000fo\u001fy")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping
    public List<JsonClusterNode> E(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a = clusterRestController;
        k.info(CommandExecutionException.E((Object)"Q\u0017w1*>o\u001d\u007f\ty\u0018*\u0018eLf\u0005y\u0018*\u0002e\bo\u001f$"), (Object)AuditLog.username((Principal)object));
        return a.I.nodes().map(clusterNode -> {
            ClusterRestController a = clusterNode;
            ClusterRestController a2 = this;
            ClusterRestController clusterRestController = a;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a2.I.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    static {
        k = AuditLog.getLogger();
        i = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode E(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        k.info(ManagedAxonServerClientStatusService.E((Object)" 7\u0006\u0011[\u001e\u001e=\u000e)\b8[\"\u0014(\u001el\u001f)\u000f-\u0012 \bl\u001d#\tl\u00001U"), (Object)AuditLog.username((Principal)a), object);
        a = name.I.getNode((String)object);
        if (a == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a, (boolean)name.I.isActive((String)object));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void E(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        k.info(ManagedAxonServerClientStatusService.E((Object)" 7\u0006\u0011[\u001e\u001e=\u000e)\b8[8\u0014l\u001f)\u0017)\u000f)[\"\u0014(\u001el\u00001U"), (Object)AuditLog.username((Principal)a), object);
        name.h.getRaftConfigService().deleteNode((String)object);
    }
}

