/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.component.processor.balancing.AutoLoadBalancer;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.config.TagsConfiguration;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@RestController(value="EventsRestController")
@RequestMapping(value={"/v1"})
public class EventsRestController {
    private final Logger D;
    private final EventDispatcher I;
    private static final Logger k = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void j(SseEmitter sseEmitter, SerializedEventWithToken serializedEventWithToken) {
        void a;
        EventsRestController a22 = serializedEventWithToken;
        EventsRestController a3 = this;
        try {
            a.send(SseEmitter.event().id(String.valueOf(a22.E() + 1L)).data((Object)new JsonEvent(a22.E())));
            return;
        }
        catch (Exception a22) {
            Exception exception = a22;
            a3.D.debug(AutoLoadBalancer.E((Object)"X\u0011~\fm\u001dt\u0006sIr\u0007=\u001ax\u0007y\u0000s\u000e=\fk\fs\u001d=D=\u0012`"), (Object)exception.getMessage(), (Object)a22);
            a.completeWithError((Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter E(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String string, @RequestParam(value="aggregateId", required=false) String string2, @RequestParam(value="initialSequence", defaultValue="0", required=false) long l2, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean bl, @RequestParam(value="trackingToken", defaultValue="0", required=false) long l3, @RequestParam(value="timeout", defaultValue="3600", required=false) long l4, @RequestParam(value="maxEvents", defaultValue="10000", required=false) long l5, @Parameter(hidden=true) Authentication authentication) {
        void a;
        EventsRestController eventsRestController;
        void a22;
        void trackingToken;
        void initialSequence;
        Disposable aggregateId;
        void context;
        void a3;
        EventsRestController eventsRestController2 = eventsRestController;
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a3);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = (long)initialSequence;
        objectArray[4] = (long)trackingToken;
        k.info(TagsConfiguration.E((Object)"\u001b\u0015=.;\u0013\u001dN\u0012\u000b1\u001b%\u001d4N&\u00012N!\u0000`\u000b6\u000b.\u001am\u001d4\u001c%\u000f-N/\b`\u000f'\t2\u000b'\u000f4\u000b`L;\u0013bB`\u001d4\u000f2\u001a)\u0000'N!\u001a`\u001d%\u001f5\u000b.\r%N;\u0013lN4\u0001+\u000b.N;\u0013n"), objectArray);
        SseEmitter a22 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis((long)a22)));
        if (aggregateId != null) {
            void allowSnapshots;
            GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId((String)aggregateId).setAllowSnapshots((boolean)allowSnapshots).setInitialSequence((long)initialSequence).build();
            eventsRestController = new ObjectMapper();
            aggregateId = eventsRestController2.I.aggregateEvents((String)context, (Authentication)ObjectUtils.E((Object)a3, (Object)GrpcContextAuthenticationProvider.I), getAggregateEventsRequest).subscribe(arg_0 -> eventsRestController2.E(a22, (ObjectMapper)eventsRestController, arg_0), arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
                EventsRestController a = a22;
                EventsRestController a2 = this;
                a2.c((SseEmitter)a);
            });
            eventsRestController2.E(a22, () -> ((Disposable)aggregateId).dispose());
            return a22;
        }
        GetEventsRequest getEventsRequest = GetEventsRequest.newBuilder().setTrackingToken((long)trackingToken).setNumberOfPermits((long)a).setClientId(AutoLoadBalancer.E((Object)";X:I")).build();
        eventsRestController = Sinks.many().unicast().onBackpressureBuffer();
        eventsRestController2.I.events((String)context, (Authentication)ObjectUtils.E((Object)a3, (Object)GrpcContextAuthenticationProvider.I), eventsRestController.asFlux()).subscribe(serializedEventWithToken -> {
            void a;
            EventsRestController a2 = serializedEventWithToken;
            EventsRestController a3 = this;
            a3.j((SseEmitter)a, (SerializedEventWithToken)a2);
        }, arg_0 -> ((SseEmitter)a22).completeWithError(arg_0), () -> {
            EventsRestController a = a22;
            EventsRestController a2 = this;
            a2.c((SseEmitter)a);
        });
        eventsRestController.emitNext((Object)getEventsRequest, Sinks.EmitFailureHandler.FAIL_FAST);
        eventsRestController2.E(a22, () -> EventsRestController.E((Sinks.Many)eventsRestController));
        return a22;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void j(SseEmitter sseEmitter, ObjectMapper objectMapper, SerializedEvent serializedEvent) {
        EventsRestController a22 = sseEmitter;
        EventsRestController a = this;
        try {
            void a3;
            void a4;
            a22.send(SseEmitter.event().data((Object)a4.writeValueAsString((Object)new JsonEvent(a3.E()))));
            return;
        }
        catch (Exception a22) {
            a.D.debug(TagsConfiguration.E((Object)"\u0005\u0016#\u000b0\u001a)\u0001.N/\u0000`\u001d%\u0000$\u0007.\t`\u000b6\u000b.\u001a`C`\u0015="), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void c(SseEmitter sseEmitter) {
        void a;
        EventsRestController eventsRestController = this;
        try {
            a.send(SseEmitter.event().comment(TagsConfiguration.E((Object)"\u0005\u0000$N/\b`\u001d4\u001c%\u000f-")));
            return;
        }
        catch (Exception a2) {
            eventsRestController.D.debug(AutoLoadBalancer.E((Object)",o\u001br\u001b=\u0006sIn\fs\rt\u0007zI~\u0006p\u0019q\fi\fy"), (Throwable)a2);
            return;
        }
        finally {
            a.complete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> E(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @Valid @RequestBody JsonEventList jsonEventList, @Parameter(hidden=true) Authentication authentication) {
        void a2;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = jsonEventList;
        EventsRestController jsonEvents = eventsRestController;
        if (eventsRestController2.messages.isEmpty()) {
            throw new IllegalArgumentException(TagsConfiguration.E((Object)"#)\u001d3\u0007.\t`\u0003%\u001d3\u000f'\u000b3"));
        }
        eventsRestController2 = Flux.fromStream(eventsRestController2.messages.stream().map(a -> new SerializedEvent(a.asEvent())));
        return jsonEvents.I.appendEvent((String)context, (Authentication)a2, (Flux)eventsRestController2);
    }

    private /* synthetic */ void j(SseEmitter sseEmitter) {
        EventsRestController a = sseEmitter;
        EventsRestController a2 = this;
        a2.c((SseEmitter)a);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> j(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication authentication) {
        void jsonEvent2;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = authentication;
        EventsRestController a = eventsRestController;
        k.info(TagsConfiguration.E((Object)"5;\u0013\u0000\u0015=3`<%\u001f5\u000b3\u001a`\u001a/N!\u001e0\u000b.\n`\u000b6\u000b.\u001ah\u001di"), (Object)AuditLog.username((Principal)eventsRestController2), (Object)context);
        return a.I.appendSnapshot(StringUtils.getOrDefault((String)context, (String)"default"), jsonEvent2.asEvent(), (Authentication)ObjectUtils.E((Object)eventsRestController2, (Object)GrpcContextAuthenticationProvider.I));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"snapshot"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    @Deprecated
    public Mono<Void> E(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication authentication) {
        void jsonEvent2;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = authentication;
        EventsRestController a = eventsRestController;
        k.warn(AutoLoadBalancer.E((Object)"F\u0012`)f\u0014@IO\fl\u001cx\u001aiIi\u0006=\bm\u0019x\u0007yIx\u001fx\u0007iAn@=\u001cn\u0000s\u000e=\rx\u0019o\f~\bi\fyI\\9T"), (Object)AuditLog.username((Principal)eventsRestController2), (Object)context);
        return a.j((String)context, (JsonEvent)jsonEvent2, (Authentication)eventsRestController2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(SseEmitter sseEmitter, Runnable runnable) {
        void a;
        Object a2 = runnable;
        EventsRestController a3 = this;
        a.onError(arg_0 -> EventsRestController.E((Runnable)a2, arg_0));
        a.onCompletion(((Runnable)a2)::run);
        a.onTimeout(((Runnable)a2)::run);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(SseEmitter sseEmitter, ObjectMapper objectMapper, SerializedEvent serializedEvent) {
        void a;
        void a2;
        EventsRestController a3 = serializedEvent;
        EventsRestController a4 = this;
        a4.j((SseEmitter)a2, (ObjectMapper)a, (SerializedEvent)a3);
    }

    private static /* synthetic */ void E(Sinks.Many a) {
        a.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(SseEmitter sseEmitter, SerializedEvent serializedEvent) {
        EventsRestController a22 = sseEmitter;
        EventsRestController a = this;
        try {
            void a3;
            a22.send(SseEmitter.event().data((Object)new JsonEvent(a3.E())));
            return;
        }
        catch (Exception a22) {
            a.D.debug(AutoLoadBalancer.E((Object)"X\u0011~\fm\u001dt\u0006sIr\u0007=\u001ax\u0007y\u0000s\u000e=\fk\fs\u001d=D=\u0012`"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    public EventsRestController(EventDispatcher eventDispatcher) {
        EventsRestController a;
        EventsRestController a2 = eventDispatcher;
        EventsRestController eventsRestController = a = this;
        eventsRestController.D = LoggerFactory.getLogger(EventsRestController.class);
        eventsRestController.I = a2;
    }

    private static /* synthetic */ void E(Runnable runnable, Throwable throwable) {
        Throwable a = throwable;
        Runnable a2 = runnable;
        a2.run();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter E(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String string, @RequestParam(value="aggregateId", required=true) String string2, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long l2, @RequestParam(value="initialSequence", defaultValue="0", required=false) long l3, @Parameter(hidden=true) Authentication authentication) {
        long maxSequence;
        void a;
        GetAggregateSnapshotsRequest aggregateId;
        void context;
        void a2;
        EventsRestController eventsRestController = eventsRestController2;
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = (long)a;
        objectArray[4] = maxSequence;
        k.info(AutoLoadBalancer.E((Object)"2f\u0014]\u0012`4=;x\u0018h\fn\u001d=\u000fr\u001b=\u0005t\u001aiIr\u000f=\u001as\bm\u001au\u0006i\u001a=\u0006{I|\u000ez\u001bx\u000e|\u001dxI?\u0012`K1IF\u0012`Df\u0014@"), objectArray);
        EventsRestController eventsRestController2 = new SseEmitter();
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId((String)aggregateId).setInitialSequence((long)a).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        eventsRestController.I.aggregateSnapshots(StringUtils.getOrDefault((String)context, (String)"default"), (Authentication)ObjectUtils.E((Object)a2, (Object)GrpcContextAuthenticationProvider.I), aggregateId).doOnError(arg_0 -> ((SseEmitter)eventsRestController2).completeWithError(arg_0)).doOnComplete(() -> eventsRestController.j((SseEmitter)eventsRestController2)).subscribe(arg_0 -> eventsRestController.E((SseEmitter)eventsRestController2, arg_0));
        return eventsRestController2;
    }
}

