/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.admin.application.api.EventProcessorInfo;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.SubscriptionKey;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final Logger B;
    private final boolean b;
    public static final String d = "Plugins disabled";
    private static final Logger D = AuditLog.getLogger();
    private final PluginController I;
    private final FeatureChecker k;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void E(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.b || !active.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, d);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = this != false ? EventProcessorInfo.E((Object)"z_hY}") : SubscriptionKey.E((Object)"J\u0017V\u0013");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        D.info(SubscriptionKey.E((Object)"8B\u001edCk\u0006H\u0016\\\u0010MCM\f\u0019\u0018DCI\u000fL\u0004P\r\u0019\u0018DLB\u001e\u0017C"), objectArray);
        active.I.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> E(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.b || !pluginsRestController.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, d);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        D.info(SubscriptionKey.E((Object)"8B\u001edCk\u0006H\u0016\\\u0010MC_\fKCZ\fW\u0005P\u0004L\u0011X\u0017P\fWCV\u0005\u0019\u0018DLB\u001e\u0017C"), objectArray);
        try {
            void context;
            return pluginsRestController.I.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.B.warn(EventProcessorInfo.E((Object)"OJ`GlO)_f\u000b{N}Y`N\u007fN)[{DyN{_`Nz\u000boD{\u000brV3Pt"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void E(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        D.info(EventProcessorInfo.E((Object)"prVT\u000b[Nx^lX}\u000b}D)^gBgX}JeG)[e^nBg\u000brV&Pt\u0005)"), objectArray);
        version.I.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    @GetMapping
    public Iterable<PluginInfo> E(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a = pluginsRestController;
        D.info(SubscriptionKey.E((Object)"b\u0018D>\u00191\\\u0012L\u0006J\u0017\u0019\u0017VCU\nJ\u0017\u0019\u0000L\u0011K\u0006W\u0017\u0019\u0013U\u0016^\nW\u0010\u0017C"), (Object)AuditLog.username((Principal)object));
        return a.I.listPlugins();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void E(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.b || !configurationJSON.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, d);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        D.info(EventProcessorInfo.E((Object)"RPtv)ylZ|Nz_)_f\u000b|[mJ}N)HfEoBn^{J}BfE)Do\u000brV&Pt\u0005)"), objectArray);
        configurationJSON.I.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey E(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a = pluginsRestController;
            if (!a.b || !a.k.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, d);
            }
            D.info(SubscriptionKey.E((Object)"8B\u001edCk\u0006H\u0016\\\u0010MCM\f\u0019\nW\u0010M\u0002U\u000f\u0019\u0013U\u0016^\nWCB\u001e\u0017C"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a;
                String string = pluginsRestController2.E(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.I.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a;
        void a2;
        PluginsRestController a3;
        PluginsRestController a4 = featureChecker;
        PluginsRestController pluginsRestController = a3 = this;
        PluginsRestController pluginsRestController2 = a3;
        pluginsRestController2.B = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.b = a2.isPluginsEnabled();
        pluginsRestController.I = a;
        pluginsRestController.k = a4;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void E(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.b || !context.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, d);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        D.info(EventProcessorInfo.E((Object)"RPtv)ylZ|Nz_)_f\u000b|E{NnBz_lY)[e^nBg\u000brV&Pt\u000boD{\u000bjDg_lS}\u000brV'"), objectArray);
        context.I.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    private /* synthetic */ String E(String string) {
        String a = string;
        PluginsRestController a2 = this;
        if (a == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, EventProcessorInfo.E((Object)"ef\u000byG|L`E)[hHbJnN)[{D\u007fBmNm"));
        }
        if (a.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, SubscriptionKey.E((Object)"%P\u000f\\\rX\u000e\\CJ\u000bV\u0016U\u0007\u0019\rV\u0017\u0019\u0000V\rM\u0002P\r\u0019\u0007P\u0011\\\u0000M\fK\u001a\u0019\u0010\\\u0013X\u0011X\u0017V\u0011"));
        }
        int n = a.lastIndexOf(46);
        if (n > 0) {
            return a.substring(0, n) + "-" + System.currentTimeMillis() + a.substring(n);
        }
        return (String)a + "-" + System.currentTimeMillis();
    }
}

