/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.localstorage.query.QueryMetadata;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final QueryDispatcher G;
    private final AccessControlConfiguration L;
    private final FeatureChecker E;
    private final VersionInfoProvider i;
    private final SubscriptionQueryMetricRegistry m;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean f;
    private final CommandDispatcher h;
    private final Topology B;
    private final Function<Predicate<String>, Stream<AxonServer>> b;
    private final boolean d;
    private final EventDispatcher D;
    private final SslConfiguration I;
    private final Map<String, Boolean> k;

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration E() {
        PublicRestController a;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a = new NodeConfiguration(publicRestController.B.getMe());
        PublicRestController publicRestController3 = publicRestController;
        PublicRestController publicRestController4 = a;
        PublicRestController publicRestController5 = publicRestController;
        a.setAuthentication(publicRestController.L.isEnabled());
        a.setSsl(publicRestController5.I.isEnabled());
        publicRestController4.setAdminNode(publicRestController5.B.isAdminNode());
        publicRestController4.setDevelopmentMode(publicRestController.f);
        a.setContextNames(publicRestController3.B.getMyContextNames());
        publicRestController2.setStorageContextNames(publicRestController3.B.getMyStorageContextNames());
        publicRestController2.setPluginsEnabled(publicRestController.d && publicRestController.E.plugins());
        PublicRestController publicRestController6 = a;
        PublicRestController publicRestController7 = publicRestController;
        a.setInitialized(publicRestController.B.initialized());
        a.setMaxApplications(publicRestController7.E.getMaxApplications());
        publicRestController6.setMaxConnections(publicRestController7.E.maxConnections());
        publicRestController6.setMaxContexts(publicRestController.E.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        a.setMaxReplicationGroups(publicRestController.E.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        PublicRestController publicRestController8 = a;
        publicRestController8.setMaxUsers(publicRestController.E.getMaxUsers());
        return publicRestController8;
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> E() {
        PublicRestController a;
        return ((Stream)a.b.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo E(HttpServletRequest httpServletRequest) {
        PublicRestController a = httpServletRequest;
        PublicRestController a2 = this;
        if (a.getUserPrincipal() instanceof Authentication) {
            a = (Authentication)a.getUserPrincipal();
            return new UserInfo(a.getName(), a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo E() {
        PublicRestController a;
        return a.i.get();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo E(@RequestParam(value="context", defaultValue="default", required=false) String string) {
        void a;
        PublicRestController publicRestController = this;
        HubSubscriptionMetrics hubSubscriptionMetrics = publicRestController.m.get((String)a);
        PublicRestController publicRestController2 = this = new StatusInfo();
        publicRestController2.setCommandRate(publicRestController.h.commandRate((String)a));
        publicRestController2.setQueryRate(publicRestController.G.queryRate((String)a));
        if (!a.startsWith(QueryMetadata.E((Object)"\u001b"))) {
            PublicRestController publicRestController3 = this;
            PublicRestController publicRestController4 = publicRestController;
            this.setEventRate(publicRestController.D.eventRate((String)a));
            this.setSnapshotRate(publicRestController4.D.snapshotRate((String)a));
            publicRestController3.setNrOfEvents(publicRestController4.D.getNrOfEvents((String)a));
            publicRestController3.setEventTrackers(publicRestController.D.eventTrackerStatus((String)a));
        }
        PublicRestController publicRestController5 = this;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        this.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        publicRestController5.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        publicRestController5.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> function, Topology topology, CommandDispatcher commandDispatcher, QueryDispatcher queryDispatcher, EventDispatcher eventDispatcher, FeatureChecker featureChecker, MessagingPlatformConfiguration messagingPlatformConfiguration, VersionInfoProvider versionInfoProvider, SubscriptionQueryMetricRegistry subscriptionQueryMetricRegistry) {
        void a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        PublicRestController a9;
        PublicRestController a10;
        PublicRestController publicRestController = publicRestController2;
        PublicRestController publicRestController2 = messagingPlatformConfiguration;
        PublicRestController publicRestController3 = a10 = publicRestController;
        PublicRestController publicRestController4 = a10;
        PublicRestController publicRestController5 = a9;
        PublicRestController publicRestController6 = a10;
        PublicRestController publicRestController7 = a10;
        PublicRestController publicRestController8 = a10;
        a10.b = a8;
        publicRestController8.B = a7;
        publicRestController8.h = a6;
        publicRestController7.G = a5;
        publicRestController7.D = a4;
        publicRestController6.E = a3;
        publicRestController6.I = a9.getSsl();
        a10.L = publicRestController5.getAccesscontrol();
        publicRestController4.d = publicRestController5.isPluginsEnabled();
        publicRestController4.i = a2;
        publicRestController3.m = a;
        publicRestController3.k = a9.getPreview();
    }

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo E() {
        PublicRestController a;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a = new LicenseInfo();
        PublicRestController publicRestController3 = publicRestController;
        a.setExpiryDate(publicRestController.E.getExpiryDate());
        a.setEdition(publicRestController3.E.getEdition());
        publicRestController2.setLicensee(publicRestController3.E.getLicensee());
        publicRestController2.setFeatureList(publicRestController.E.getFeatureList());
        return publicRestController2;
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> E() {
        PublicRestController a;
        return a.B.getMyStorageContextNames();
    }
}

