/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.enterprise.init.UninitializedCheck;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.managed.ManagedAxonServerClientStatusService;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.b;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private static final Logger d = LoggerFactory.getLogger(UserRestController.class);
    private final RoleController D;
    private static final Logger I = AuditLog.getLogger();
    private final UserAdminService k;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> E(@Parameter(hidden=true) Principal principal) {
        void a;
        UserRestController userRestController = this;
        try {
            return userRestController.k.users((Authentication)new PrincipalAuthentication((Principal)a)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            d.info(UninitializedCheck.E((Object)"\u001c!:\u0007g\u0016.)3z2)\"(4z!;.6\">gwg!:"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a;
        UserRestController a2;
        UserRestController a3 = roleController;
        UserRestController userRestController = a2 = this;
        userRestController.k = a;
        userRestController.D = a3;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void E(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.k.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            I.error(ManagedAxonServerClientStatusService.E((Object)" 7\u0006\u0011[\b\u001e \u001e8\u001el\u000e?\u001e>[7\u0006l\u001d-\u0012 \u001e([a[7\u0006"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void E(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a != null && userRestController2.userName.equals(a.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ManagedAxonServerClientStatusService.E((Object)"\u0002\u00148[-\u0017 \u0014;\u001e([8\u0014l\u0018$\u001a\"\u001c)[5\u00149\tl\u0014;\u0015l\u0018>\u001e(\u001e\"\u000f%\u001a \b"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.k.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a = adminUserRole;
            UserRestController a2 = this;
            return new b(a2, (AdminUserRole)a);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a));
    }
}

