/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Sinks.Many<SimpleUpdate> D;
    private final Logger I = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private static final Logger k = AuditLog.getLogger();

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a = contextUpdatedInAdmin;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.k, a.E(), SimpleUpdateState.B);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a = clusterUpdatesService;
        return a.D.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.E((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a = replicationGroupCreated;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.f, a.replicationGroup(), SimpleUpdateState.b);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a;
        a.D = Sinks.many().multicast().onBackpressureBuffer();
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a = axonServerInstanceDisconnected;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.I, a.getNodeName(), SimpleUpdateState.D);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a = replicationGroupUpdated;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.f, a.replicationGroup(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a = leaderStepDown;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.b, a.replicationGroup(), SimpleUpdateState.B);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a;
        void a2;
        ClusterUpdatesService a3 = simpleUpdateState;
        ClusterUpdatesService a4 = this;
        a4.D.emitNext((Object)new SimpleUpdate((UpdateType)a2, (String)a + ":" + a3.name()), (signalType, emitResult) -> {
            SignalType a = emitResult;
            SignalType a2 = signalType;
            if (a == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a = axonServerInstanceConnected;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.I, a.getNodeName(), SimpleUpdateState.d);
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a = contextUnregisteredInAdmin;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.k, a.context(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a = axonServerNodeConnected;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.D, a.getNodeInfo().getHostName(), SimpleUpdateState.d);
    }

    private static /* synthetic */ void E(Authentication a) {
        k.info(ClientEventProcessorInfo.E((Object)"\u007f\u0011Y7\u00049Q\bW\tV\u0003F\u000f@JP\u0005\u0004\tK\u0004P\u000f\\\u001e\u0004\u001fT\u000eE\u001eA\u0019\n"), (Object)AuditLog.username((String)a.username()));
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a = becomeLeader;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.b, a.replicationGroup(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a = contextRegisteredInAdmin;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.k, a.context(), SimpleUpdateState.b);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a = leaderConfirmation;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.b, a.replicationGroup(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a = applicationConnected;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.B, a.B(), SimpleUpdateState.d);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a = applicationDisconnected;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.B, a.c(), SimpleUpdateState.D);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a = replicationGroupDeleted;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.f, a.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a = axonServerNodeDeleted;
        ClusterUpdatesService a2 = this;
        a2.E(UpdateType.D, a.node(), SimpleUpdateState.I);
    }
}

