/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.PluginTool;
import io.axoniq.tools.http.json.PluginConfiguration;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.yaml.snakeyaml.Yaml;

public class ConfigurePlugin {
    private ConfigurePlugin() {
    }

    public static void run(String[] args) throws Throwable {
        ToolResult result;
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.PLUGIN_NAME, CommandOptions.PLUGIN_VERSION, CommandOptions.PLUGIN_CONTEXT, CommandOptions.TOKEN, CommandOptions.PROPERTIES_FILE, CommandOptions.PROPERTIES});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        PluginConfiguration pluginConfiguration = new PluginConfiguration(commandLine.getOptionValue(CommandOptions.PLUGIN_NAME.getOpt()), commandLine.getOptionValue(CommandOptions.PLUGIN_VERSION.getOpt()), commandLine.getOptionValue(CommandOptions.PLUGIN_CONTEXT.getOpt()));
        if (commandLine.hasOption(CommandOptions.PROPERTIES.getOpt())) {
            for (String metadataProperty : commandLine.getOptionValues(CommandOptions.PROPERTIES.getOpt())) {
                String[] keyValue = metadataProperty.split("=", 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Property value must be group:key=value - " + keyValue);
                }
                String[] keyParts = keyValue[0].split(":", 2);
                if (keyParts.length != 2) {
                    throw new IllegalArgumentException("Property value must be group:key=value - " + keyValue);
                }
                pluginConfiguration.addProperty(keyParts[0].trim(), keyParts[1].trim(), keyValue[1].trim());
            }
        }
        if (commandLine.hasOption(CommandOptions.PROPERTIES_FILE.getOpt())) {
            Yaml yaml = new Yaml();
            try (FileInputStream inputStream = new FileInputStream(AxonIQCliUtil.option((CommandLine)commandLine, (Option)CommandOptions.PROPERTIES_FILE));){
                Map obj = (Map)yaml.load((InputStream)inputStream);
                pluginConfiguration.setProperties(obj);
            }
        }
        if ((result = PluginTool.configurePlugin((PluginConfiguration)pluginConfiguration, (String)serverHttpAddress, (boolean)connectInsecure, (String)token)).isFailure()) {
            throw result.getFailure();
        }
    }
}

