/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.UserTool;
import io.axoniq.tools.http.json.User;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ListUsers {
    private ListUsers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        if (AxonIQCliUtil.jsonOutput((CommandLine)commandLine)) {
            ToolResult result = UserTool.listUsersRaw((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.println((String)result.getSuccessValue());
            return;
        } else {
            ToolResult result = UserTool.listUsers((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.printf("%-60s\n", "Name");
            for (User user : (List)result.getSuccessValue()) {
                System.out.printf("%-60s\n", user.getUserName());
            }
        }
    }
}

