create table application_context
(
    id             BIGINT generated by default as identity,
    application_id BIGINT not null,
    context        VARCHAR(255),
    primary key (id),
    CONSTRAINT fk_application_id FOREIGN KEY (application_id) REFERENCES application (id)
);

create table application_context_role
(
    id                     BIGINT generated by default as identity,
    application_context_id BIGINT not null,
    role                   VARCHAR(255),
    CONSTRAINT fk_application_context_id FOREIGN KEY (application_context_id) REFERENCES application_context (id)
);

insert into application_context (application_id, context)
select distinct application_roles.application_id, application_role.context
from application_roles,
     application_role
where application_roles.roles_id = application_role.id;

insert into application_context_role (application_context_id, role)
select distinct application_context.id, application_role.role
from application_roles,
     application_role,
     application_context
where application_roles.roles_id = application_role.id
  and application_roles.application_id = application_context.application_id
  and application_role.context = application_context.context;


