/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.subscription.DirectSubscriptionQueries;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private final Map<String, Boolean> preview;
    private String domain;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private static final Logger logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
    private String pluginPackageDirectory;
    private String pidFileLocation;
    private int grpcBufferedMessages;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private int httpPort;
    private int eventStoreBackgroundThreadCount;
    private int clusterExecutorThreadCount;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private String internalHostname;
    private Duration keepAliveTimeout;
    private String name;
    private int metricsSynchronizationRate;
    private String controldbBackupLocation;
    private String pluginCleanPolicy;
    private int executorThreadCount;
    private int eventStoreProcessorsThreadCount;
    private int port;
    private String hostname;
    private static final int RESERVED = 10000;
    private boolean setWebSocketAllowedOrigins;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private Duration keepAliveTime;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private boolean pluginsEnabled;
    private String internalDomain;
    private String pluginCacheDirectory;
    private Duration minKeepAliveTime;
    private final SystemInfoProvider systemInfoProvider;
    private static final Logger auditLog = AuditLog.getLogger();
    private Duration metricsInterval;
    private String webSocketAllowedOrigins;
    private int maxMessageSize;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private int internalPort;

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public void setMetricsInterval(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsInterval = a2;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = accessControlConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(DirectSubscriptionQueries.A((Object)"B\r`\u000bp\u001d#\rl\u0000w\u001cl\u0002#\rl\u0000e\u0007d\u001bq\u000fw\u0007l\u0000#<F#L8F*-"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(ClientContext.A((Object)"\u001e{<},k\u007f{0v+j0t\u007fq,81w(8$eq"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setPluginCacheDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCacheDirectory = a2;
    }

    public void setPluginCleanPolicy(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCleanPolicy = a2;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsSynchronizationRate = a2;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    private /* synthetic */ void G() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a2;
            a2.preview.forEach((string, bl) -> {
                Boolean a2 = bl;
                String a3 = string;
                if (Boolean.TRUE.equals(a2)) {
                    auditLog.info(DirectSubscriptionQueries.A((Object)">q\u000bu\u0007f\u0019#\u0001eNe\u000bb\u001av\u001cfNx\u0013#\u000bm\u000fa\u0002f\n-"), (Object)a3);
                }
            });
            auditLog.info(DirectSubscriptionQueries.A((Object)"-l\u0000e\u0007d\u001bq\u000fw\u0007l\u0000#\u0007m\u0007w\u0007b\u0002j\u0014f\n#\u0019j\u001akNP=ONx\u0013#\u000fm\n#\u000f`\rf\u001dpN`\u0001m\u001aq\u0001oNx\u0013-"), (Object)AuditLog.enablement((boolean)a2.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a2.accesscontrol.isEnabled()));
        }
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public void setInternalHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalHostname = a2;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public void setPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.port = a2;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    private /* synthetic */ void M() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.A(a2.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setHostname((String)a2);
            messagingPlatformConfiguration.setDomain((String)a4);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        messagingPlatformConfiguration2.A(a2.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a2);
            messagingPlatformConfiguration.setInternalDomain((String)a4);
        });
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.G();
        messagingPlatformConfiguration.M();
        messagingPlatformConfiguration.A();
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a2 = eventTransformationConfiguration;
        MessagingPlatformConfiguration a3 = this;
        a3.eventTransformation = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.setWebSocketAllowedOrigins = a2;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a2 = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a2.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a2.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a2) {
                logger.warn(ClientContext.A((Object)"[0m3|\u007fv0l\u007f|:l:j2q1}\u007fp0k+v>u:89j0u\u007fq1}+8>|;j:k,\"\u007fc\""), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.webSocketAllowedOrigins = a2;
    }

    public void setKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTime = a2;
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public void setName(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.name = a2;
    }

    public void setControldbBackupLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.controldbBackupLocation = a2;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.minKeepAliveTime = a2;
    }

    public void setInternalDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalDomain = a2;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = sslConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(DirectSubscriptionQueries.A((Object)"=P\"#\rl\u0000e\u0007d\u001bq\u000fw\u0007l\u0000#<F#L8F*-"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(ClientContext.A((Object)"K\fT\u007fq,81w(8$eq"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a2) {
                logger.warn(DirectSubscriptionQueries.A((Object)"-l\u001bo\n#\u0000l\u001a#\nf\u001af\u001cn\u0007m\u000b#\u0006l\u001dw\u0000b\u0003fNe\u001cl\u0003#\u0007m\u000bwNb\ng\u001cf\u001dpT#\u0015~"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginsEnabled = a2;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        return a3.preview.getOrDefault(a2, false);
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public void setGrpcBufferedMessages(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.grpcBufferedMessages = a2;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public void setInternalPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.internalPort = a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a2;
        boolean a3 = bl;
        MessagingPlatformConfiguration a4 = this;
        String string3 = a3 = a3 ? ClientContext.A((Object)"6v+}-v>t\u007f") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(DirectSubscriptionQueries.A((Object)"@\u0001v\u0002gNm\u0001wNg\u000bw\u000bq\u0003j\u0000fNbNu\u000fo\u0007gNx\u0013k\u0001p\u001am\u000fn\u000b-"), (Object)a3);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a3 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(ClientContext.A((Object)"L7}\u007fc\"p0k+v>u:87y,8=}:v\u007fk:l\u007fy,8>v\u007fQ\u000f8>|;j:k,6\u007fL7q,82y&8/j0|*{:8*v(y1l:|\u007fj:k*t+kq"), (Object)a3);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            void a5;
            void a6;
            void v1 = a2;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a6)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(DirectSubscriptionQueries.A((Object)"@\u0001m\bj\tv\u001cj\u0000dNg\u0001n\u000fj\u0000#\bq\u0001nNx\u0013k\u0001p\u001am\u000fn\u000b#\u001eq\u0001s\u000bq\u001azT#\u0006l\u001dw\u0000b\u0003fSx\u0013/Ng\u0001n\u000fj\u0000>\u0015~"), objectArray);
                a5.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a3;
            objectArray[1] = a2;
            objectArray[2] = string4;
            objectArray[3] = a6;
            logger.warn(ClientContext.A((Object)"\u0016\u007f1w-q1\u007f\u007f|0u>q18/y-l\u007fw98+p:8$e7w,l1y2}\u007f?$ex\"\u007fp0k+v>u:%$es8;w2y6vbc\""), objectArray);
            a5.accept(string4, a6);
        }
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public void setEventStoreProcessorsThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreProcessorsThreadCount = a2;
    }

    public void setPidFileLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pidFileLocation = a2;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public void setPluginPackageDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginPackageDirectory = a2;
    }

    public void setExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.executorThreadCount = a2;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.domain = a2;
    }

    private /* synthetic */ void A() {
        MessagingPlatformConfiguration a2;
        if (a2.datasourceUrl != null && !a2.datasourceUrl.contains(ClientContext.A((Object)"eu:ue")) && !a2.datasourceUrl.contains(DirectSubscriptionQueries.A((Object)"b\u0016l\u0000p\u000bq\u0018f\u001c.\rl\u0000e\u0007d\na"))) {
            throw new FailedToStartException(ClientContext.A((Object)"\u000bp:8;y+y=y,}\u007fv>u:89w-8\u001e`0v\u007fK:j)}-82m,l\u007fz:8xy'w1k:j)}-5<w1~6\u007f;zx6\u007fQ98&w*8>j:82q8j>l6v889j0u\u007fy180t;}-8)}-k6w18:v,m-}\u007fl7y+8+p:8\u001cw1l-w38\u001bZ\u007fq,86v\u007f?>`0v,}-n:jr{0v+j0t;zx8>v;8*h;y+}\u007fl7}\u007fk/j6v86;y+y,w*j<}qm-t\u007fh-w/}-l&8+w\u007fm,}\u007f|>l>z>k:81y2}\u007f?>`0v,}-n:jr{0v9q8|=?q"));
        }
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreBackgroundThreadCount = a2;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a2 = dataSize;
        MessagingPlatformConfiguration a3 = this;
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)DirectSubscriptionQueries.A((Object)"N\u000f{Nn\u000bp\u001db\tfNp\u0007y\u000b#\u0003v\u001dwNa\u000b#\tq\u000bb\u001af\u001c#\u001ak\u000fmN3"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)ClientContext.A((Object)"\u0012y'82},k>\u007f:8,q%}\u007fu*k+8=}\u007ft:k,8+p>v\u007f*n,h,g+i,h"));
        a3.maxMessageSize = (int)a2.toBytes();
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public void setHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.hostname = a2;
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTimeout = a2;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.clusterExecutorThreadCount = a2;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration a3 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a2;
        a2.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a2;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a2;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a2;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a2;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a3;
    }
}

