/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import io.axoniq.axonserver.util.TimeLimitedCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final RemoteConnections d;
    private volatile boolean B;
    private final Limits H;
    private final AdminConfigurationFactory K;
    private final MessagingPlatformConfiguration M;
    private final AdminNodes J;
    private final ClusterTagsCache b;
    private final Logger E;
    private final CurrentNodeProvider I;
    private final ApplicationEventPublisher k;

    private /* synthetic */ void A(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.J.deleteById((String)a2);
    }

    private /* synthetic */ ClusterNode A(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.E.info(ReplicationRestControllerV2.A((Object)"pfU\"_mUg\u0011yL"), (Object)a3);
        a3 = clusterController.K.clusterNode((NodeInfo)a3);
        return clusterController.J.save((ClusterNode)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.d.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    private /* synthetic */ void A(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.M.getName())) {
            return;
        }
        a3.d.connect((NodeInfo)a2, true);
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.k.publishEvent(a2);
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.d.activeConnections();
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.J.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.b.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.d.disconnect((String)a2);
    }

    public void stop() {
        a.B = false;
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.A();
        a2.B = true;
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.J.findById((String)a2).orElseGet(() -> ((ClusterController)a3).A((String)a2));
        return a3.A((ClusterNode)a2);
    }

    private /* synthetic */ ClusterNode A(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.d.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.A((NodeInfo)a3);
        clusterController.d.updateNodeInfo((NodeInfo)a3);
        clusterController.k.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.d.nodes();
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.d.get((String)a2));
    }

    private /* synthetic */ void A() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.J.findById(clusterController2.M.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.J.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.M.getName();
                a2 = String.format(ReplicationRestControllerV2.A((Object)"ADpCg_v\u0011l^fT\"_c\\g\u0011jPq\u0011aYc_eTf\u001d\"_gF\"_c\\g\u0011'B,\u0011QEcCv\u0011CIm_QTpGgC\"FkEj\u0011pTa^tTpH\"Wk]g\u001f"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.K.clusterNode(clusterController3.M.getName(), clusterController.M.getFullyQualifiedHostname(), clusterController.M.getFullyQualifiedInternalHostname(), clusterController.M.getPort(), clusterController.M.getInternalPort(), clusterController.M.getHttpPort());
            clusterController3.J.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.M.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.M.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.M.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.M.getInternalPort();
            object = String.format(TimeLimitedCache.A((Object)"|\u001eM\u0019Z\u0005KKQ\u0004[\u000e\u0018\u0018\u001f\u0002Q\u001fZ\u0019Q\nSKW\u0004L\u001fQ\nR\u000e\u0010\u001bP\u0019KK\u0017NLQ\u001a\u000f\u0016KW\nLK\\\u0003^\u0005X\u000e[G\u001fKQ\u000eHKI\nS\u001eZ\u0018\u001fNLQ\u001a\u000f\u0011Kl\u001f^\u0019KK~\u0013P\u0005l\u000eM\u001dZ\u0019\u001f\u001cV\u001fWKM\u000e\\\u0004I\u000eM\u0012\u001f\rV\u0007ZE"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.d.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.J.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.I.isAdmin();
    }

    private /* synthetic */ void A(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.d.contains((String)a2) || a3.M.getName().equals(a2)) {
            return;
        }
        a3.H.getMaxClusterSize().ifPresent(arg_0 -> a3.A((String)a2, arg_0));
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.M.getName()) || a3.d.get(a2) != null && a3.d.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.E = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.M = messagingPlatformConfiguration2;
        clusterController6.J = clusterNodeRepository;
        clusterController5.K = adminConfigurationFactory2;
        clusterController5.b = clusterTagsCache2;
        clusterController4.k = applicationEventPublisher2;
        clusterController4.H = limits2;
        clusterController3.d = remoteConnections2;
        clusterController3.I = clusterController2;
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.J.deleteAllByNameNot(clusterController.getName());
        clusterController.d.sync();
    }

    public int getPhase() {
        return 50;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.d.connections();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.B;
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.A(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.M.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.E.info(ReplicationRestControllerV2.A((Object)"epHk_e\u0011v^\"[mXl\u0011uXvY\"RwCpTlE\"_mUg\u0011lPoT8\u0011yL"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.M.getInternalHostname()) && a2.getGrpcInternalPort() == a3.M.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, TimeLimitedCache.A((Object)"|\nQ\u0005P\u001f\u001f\u0001P\u0002QK\\\u0007J\u0018K\u000eMKH\u0002K\u0003\u001f\u0018^\u0006ZKW\u0004L\u001fQ\nR\u000e\u001f\nQ\u000f\u001f\u0002Q\u001fZ\u0019Q\nSKO\u0004M\u001f"));
        }
        ClusterNode clusterNode = a3.J.findById(a2.getNodeName()).orElseGet(() -> a3.A((NodeInfo)a2));
        if (!a3.d.contains(a2.getNodeName())) {
            a3.A((NodeInfo)a2);
        }
        return clusterNode;
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.A((ClusterNode)clusterController.I.get());
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.E.info(TimeLimitedCache.A((Object)"/Z\u0007Z\u001fZKQ\u0004[\u000e\u0005KD\u0016"), a3);
        clusterController2.k.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.M.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.J.deleteAllByNameNot((String)a3);
            clusterController3.d.closeAll();
        } else {
            a2.J.findById((String)a3).ifPresent(arg_0 -> a2.A((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.k.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.d.sync();
    }
}

