/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.cluster.manager.RemoteEventStoreFactory;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final Logger C;
    private static final DataSize e = DataSize.ofMegabytes((long)32L);
    private final ExecutorService d;
    private final List<AxonServerInternalService> B;
    private final LogReplicationService H;
    private final MessagingPlatformConfiguration K;
    private final Supplier<ScheduledExecutorService> M;
    private final ApplicationEventPublisher J;
    private AdvancedTlsX509KeyManager.Closeable b;
    private boolean E;
    private final LeaderElectionService I;
    private Server k;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = ReplicationGroupConfiguration.A((Object)"\u000ez@F3Y");
            if (messagingClusterServer.K.getSsl() != null && messagingClusterServer.K.getSsl().isEnabled()) {
                Object object = messagingClusterServer.K.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(RemoteEventStoreFactory.A((Object)"4c:u<j{z-t;h0i#~'5&h956~'oxx=z<ux}<w0;;t!;&~!"));
                }
                Object object2 = messagingClusterServer.K.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(ReplicationGroupConfiguration.A((Object)"\u0001m\u000f{\tdNt\u0018z\u000ef\u0005g\u0016p\u0012;\u0013f\f;\u0010g\tc\u0001a\u00058\u000bp\u00198\u0006|\fp@{\u000fa@f\u0005a"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.b = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.M.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort(), (ServerCredentials)object);
                string = RemoteEventStoreFactory.A((Object)"\u0006H\u0019;0u4y9~1");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.K.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(e.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.K.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.K));
            messagingClusterServer.B.forEach(arg_0 -> MessagingClusterServer.A((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.I);
            a2.addService((BindableService)messagingClusterServer2.H);
            if (messagingClusterServer2.K.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.K.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.K.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.K.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.d);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupConfiguration.A((Object)"v\f`\u0013a\u0005gMw\u000ff\u00138"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(RemoteEventStoreFactory.A((Object)"6w h!~'6\"t'p0ix"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupConfiguration.A((Object)"v\f`\u0013a\u0005gMw\u000ff\u00138"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(RemoteEventStoreFactory.A((Object)"6w h!~'6\"t'p0ix"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.k = a2.build();
            messagingClusterServer.k.start();
            messagingClusterServer.C.info(ReplicationGroupConfiguration.A((Object)"T\u0018z\u000e53p\u0012c\u0005g@V\f`\u0013a\u0005g@F\u0005g\u0016p\u00125\u0013a\u0001g\u0014p\u00045\u000f{@e\u000fg\u0014/@n\u001d5M5\u001bh"), (Object)messagingClusterServer.K.getInternalPort(), (Object)string);
            messagingClusterServer.J.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.E = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(RemoteEventStoreFactory.A((Object)"\u0006o4i!r;|uZ-t;;\u0006~'m0iuX9n&o0iuH0i#~';3z<w0\u007fu"), (Throwable)a2);
        }
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.E;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void A(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.C = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.K = a8;
        messagingClusterServer3.H = a6;
        messagingClusterServer3.I = a5;
        messagingClusterServer2.B = a4;
        messagingClusterServer2.M = a3;
        messagingClusterServer.J = a2;
        messagingClusterServer.d = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(ReplicationGroupConfiguration.A((Object)"v\f`\u0013a\u0005gMp\u0018p\u0003`\u0014z\u00128")));
    }

    public int getPhase() {
        return 50;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.b != null) {
            messagingClusterServer.b.close();
        }
        messagingClusterServer.d.shutdown();
        try {
            if (!messagingClusterServer.k.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.C.debug(RemoteEventStoreFactory.A((Object)"]:i6~3n9w,;&o:k%r;|uX9n&o0iuH0i#~'"));
                messagingClusterServer2.k.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.C.debug(ReplicationGroupConfiguration.A((Object)"){\u0014p\u0012g\u0015e\u0014p\u00045\u0004`\u0012|\u000er@f\b`\u0014q\u000fb\u000e5\u000fs@|\u000ea\u0005g\u000et\f5!m\u000f{3p\u0012c\u0005g"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.E = false;
        messagingClusterServer.C.info(RemoteEventStoreFactory.A((Object)"Z-t;;\u0006~'m0iuX9n&o0iuH0i#~';&o:k%~1"));
    }
}

