/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalCommandMessageHandler;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.message.query.subscription.DirectSubscriptionQueries;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final RaftGroupRepositoryManager f;
    private final FileSystemMonitor G;
    private final RaftProperties C;
    private final Map<String, Long> e;
    private final Logger d;
    private final LifecycleController B;
    private final GrpcRaftGroupFactory H;
    private volatile boolean K;
    private final Map<String, RaftGroup> M;
    private final AtomicBoolean J;
    private final ReplicationGroupController b;
    private final MessagingPlatformConfiguration E;
    private final ApplicationEventPublisher I;
    public static final String k = "replication-logs";

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.M.keySet();
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.b.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.A((String)a2));
    }

    public int getPhase() {
        return 100;
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.M.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.E.getName();
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.A((String)a3);
        }
        a4.M.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.b.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.I.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.E.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(InternalCommandMessageHandler.A((Object)"\u0006-0.!b+-1b#++&e!007'+6e,*& b,,e,*& 1"));
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.M.get(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.K) {
            throw new IllegalStateException(InternalCommandMessageHandler.A((Object)"\u0011 03'7b66$0175m6*06!-2,e++b50*%7'61"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.M.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.M;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.M.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.A((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, DirectSubscriptionQueries.A((Object)"<f\u001eo\u0007`\u000fw\u0007l\u0000#\tq\u0001v\u001e#\nf\u0002f\u001aj\u0001mNj\u0000#\u001eq\u0001d\u001cf\u001dp"));
                }
                a3 = grpcRaftController.A((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.f.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.I.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.M.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.M();
        long l2 = a2.M();
        if (v0.M() && !a3.I()) {
            grpcRaftController.I.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.I() && !a3.M()) {
            grpcRaftController.I.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).A(), l2));
            return;
        }
        if (a3.g()) {
            grpcRaftController.I.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.G())) {
            grpcRaftController.I.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.G(), l2));
        }
    }

    private /* synthetic */ void A(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.e.put(a2, System.currentTimeMillis() + 2L * (long)a3.C.getMaxElectionTimeout());
    }

    private /* synthetic */ boolean A(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.e.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.d = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.M = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.e = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.J = new AtomicBoolean();
        grpcRaftController6.E = a9;
        grpcRaftController6.f = a8;
        grpcRaftController5.b = a7;
        grpcRaftController5.C = a6;
        grpcRaftController4.I = a5;
        grpcRaftController4.H = a4;
        grpcRaftController3.G = a3;
        grpcRaftController3.B = a2;
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).G();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.A(a2.localNode(), (StateChanged)a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup A(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.M;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.d.info(DirectSubscriptionQueries.A((Object)"\u0015~T#\u0007m\u0007wNq\u000bs\u0002j\rb\u001aj\u0001mNd\u001cl\u001bs"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.M.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.H.create((String)a4, (String)a2);
            a2.localNode().M(arg_0 -> a3.A((RaftGroup)a2, arg_0));
            a3.M.put(a4, a2);
            return a2;
        }
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.K) {
            throw new IllegalStateException(InternalCommandMessageHandler.A((Object)"\f,,6,#)+?#1+*,e-7b6*06!-2,e++b50*%7'61"));
        }
        if (!a3.M.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.E.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.M.get(a2)).localNode();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.d.info(DirectSubscriptionQueries.A((Object)"x\u00139NQ\u000bs\u0002j\rb\u001aj\u0001mNd\u001cl\u001bsNp\u001ab\u001cw\u000bg"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.B.setCleanShutdown();
                grpcRaftController2.J.set(true);
                return;
            }
        } else {
            a3.d.warn(InternalCommandMessageHandler.A((Object)">?\u007fb\u0017'5.,!$6,-+b\"0*75b66$01b##,. &"), (Object)a.groupId(), a2);
        }
    }

    private /* synthetic */ MessagingPlatformException A(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.E.getName() + ": Not a member of " + (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.E.getFullyQualifiedInternalHostname()).setPort(a5.E.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.A((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.d.debug(InternalCommandMessageHandler.A((Object)"\u00111#76e$7-(b,,,6\u0017##6\u00020*75b>?"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.G.unregisterPath(k);
        grpcRaftController.M.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.K = false;
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.K) {
            a2.M.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).A();
            });
        }
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.J.get();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.f.contexts();
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.K;
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.C.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.A((File)a2);
        grpcRaftController2.G.registerPath(k, ((File)a2).toPath(), grpcRaftController.C.minFreeSpace(), grpcRaftController.C.warnFreeSpace());
        a2 = grpcRaftController2.f.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.A(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.K = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.d.info(DirectSubscriptionQueries.A((Object)"\u0015~T#<f\u001eo\u0007`\u000fw\u0007l\u0000#\tq\u0001v\u001e#\u001dw\u000fq\u001aj\u0000d"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.M.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.A((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.d.warn(InternalCommandMessageHandler.A((Object)"98xe\u0004$+)'!b1-e+++1+$.,8 b7'5.,!$6,-+\u00057-02"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.d.info(DirectSubscriptionQueries.A((Object)"<f\u001eo\u0007`\u000fw\u0007l\u0000#\tq\u0001v\u001e#\rl\u0000w\u001cl\u0002o\u000bqNq\u001bm\u0000j\u0000d"));
        if (a2.isEmpty()) {
            grpcRaftController.J.set(true);
        }
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.C.getMaxElectionTimeout();
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().g() || a2.logEntryProcessor().M() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(DirectSubscriptionQueries.A((Object)"'m\u001af\u001cq\u001bs\u001a#\u0019k\u0007o\u000b#\u0019b\u0007w\u0007m\t#\u001alNa\u000b`\u0001n\u000b#\u0002f\u000fg\u000bq"));
            }
        }
        return a2.localNode();
    }
}

