/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.EventProcessorSynchronizer;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import io.axoniq.axonserver.transport.grpc.eventprocessor.EventProcessorMapping;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final AddressValidator K;
    private final Logger M;
    private final FeatureChecker J;
    private final RaftGroupServiceFactory b;
    private final ClusterController E;
    private final LicenseManager I;
    private final TaskPublisher k;

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterChangesHandler a8;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a8 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a8;
        ClusterChangesHandler clusterChangesHandler5 = a8;
        a8.M = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.E = a7;
        clusterChangesHandler5.k = a6;
        clusterChangesHandler4.b = a5;
        clusterChangesHandler4.J = a4;
        clusterChangesHandler3.K = a3;
        clusterChangesHandler3.I = a2;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a3;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a4 = clusterChangesHandler.E.getNode((String)a3);
        if (a4 == null) {
            return;
        }
        if (a4.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup() != null) {
                if (a2.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(EventProcessorSynchronizer.A((Object)"-<\u00076C \u0017:\u000f?C>\u0006>\u00016\u0011s\f5C0\f=\u00176\u001b'\u0010}"));
        }
        clusterChangesHandler.b.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a3).build().toByteArray());
    }

    public void deleteNode(String string) {
        String a2 = string;
        ClusterChangesHandler a3 = this;
        ClusterNode clusterNode = a3.E.getNode(a2);
        if (clusterNode == null) {
            a3.M.info(EventProcessorMapping.A((Object)"F\fn\fv\f\"'m\rgS\"\u0012\u007fI/IL\u0006f\f\"\u0007m\u001d\"\u000fm\u001cl\r,"), (Object)a2);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.A((ClusterController)a3.E, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a2)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a3.k.publishScheduledTask(RaftAdminGroup.A(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
        if (a2.equals(a3.E.getName())) {
            a3.A(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a2;
            ClusterChangesHandler a3 = adminReplicationGroupMember;
            ClusterChangesHandler a4 = this;
            a4.k.publishScheduledTask(RaftAdminGroup.A(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a2, a3.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    private /* synthetic */ byte[] A() {
        ClusterChangesHandler a2;
        return a2.I.readLicense();
    }

    private /* synthetic */ void A(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a3 = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.J.getMaxClusterSize().ifPresent(n -> {
            Integer a2 = n;
            ClusterChangesHandler a3 = this;
            if (a3.E.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.J.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a3 = clusterChangesHandler2.b.getLeader(RaftAdminGroup.A());
        if (!clusterChangesHandler2.E.getName().equals(a3)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a3);
        }
        a3 = clusterChangesHandler.E.getNode(a2.getNodeName());
        if (!(a3 == null || a3.getInternalHostName().equals(a2.getInternalHostName()) && a3.getGrpcInternalPort().equals(a2.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, EventProcessorSynchronizer.A((Object)"\"s\r<\u00076C$\n'\u000bs\u0017;\u0006s\u00102\u000e6C=\u0002>\u0006s\u0002=\u0007s\u0007:\u00055\u0006!\u0006=\u0017s\n=\u00176\u0011=\u0002?C;\f \u0017s\r2\u000e6C2\r7C#\f!\u0017s\u0002?\u00116\u00027\u001as\u0006+\n \u0017 "));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.K.validateAddress(a2.getInternalHostName(), a2.getGrpcInternalPort());
        a3 = clusterChangesHandler3.A();
        clusterChangesHandler3.b.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a2.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a3)).build();
    }
}

