/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupPayload;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupTask;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.message.query.QueryMetricsWebSocket;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import io.grpc.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class ReplicationGroupChangesHandler {
    private final GrpcRaftController H;
    private final Logger K;
    private final TaskPublisher M;
    private final FeatureChecker J;
    private final ClusterController b;
    private final RaftGroupServiceFactory E;
    private final int I = 1;
    private final AdminReplicationGroupController k;

    /*
     * WARNING - void declaration
     */
    public void deleteNodeFromReplicationGroup(String string, String string2, boolean bl) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.K.info(QueryMetricsWebSocket.A((Object)"k#C#[#\u000f(@\"JfI4@+\u000f4J6C/L'[/@(\u000f!])Z6\u000f/A0@-J\"\u000f @4\u000f4J6C/L'[/@(\u000f!])Z6\u0015fT;\u000fk\u000f'A\"\u000f(@\"J|\u000f=R"), a5, (Object)a3);
        if (replicationGroupChangesHandler.E.getLeader((String)a5) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a5 + ": cannot delete node from a replication group when it does not have a leader");
        }
        AdminReplicationGroup adminReplicationGroup = (AdminReplicationGroup)a4.k.findByName((String)a5).orElseThrow(() -> ReplicationGroupChangesHandler.G((String)a5));
        String string3 = (String)adminReplicationGroup.getNodeLabel((String)a3).orElseThrow(() -> ReplicationGroupChangesHandler.A((String)a3, (String)a5));
        if (adminReplicationGroup.getMembers().size() == 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.CANNOT_REMOVE_LAST_NODE, String.format(EventTransformationConfiguration.A((Object)"\n\u0012 \u0018dX7]-\u000ed\u0011%\u000e0]*\u0012 \u0018d\u0014*]6\u00184\u0011-\u001e%\t-\u0012*]#\u000f+\b4]a\u000eh]0\u0012d\u0019!\u0011!\t!]0\u0015!]6\u00184\u0011-\u001e%\t-\u0012*]#\u000f+\b4]1\u000e!]1\u00136\u0018#\u00147\t!\u000fd\u001e+\u00130\u0018<\t"), objectArray));
        }
        if (!LeaderElectionCheck.A((ClusterController)a4.b, (AdminReplicationGroup)adminReplicationGroup, (String)a3)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, String.format(QueryMetricsWebSocket.A((Object)"{.JfA)K#\u000fc\\fL'A(@2\u000f$JfK#C#[#KfI4@+\u000f2G#\u000f4J6C/L'[/@(\u000f!])Z6\u000fc\\fN2\u000f2G/\\fB)B#A2\u0003f]#B'F(F(HfA)K#\\fL'A(@2\u000f#C#L2\u000f'\u000f(J1\u000f*J'K#]"), objectArray));
        }
        void v3 = a3;
        a4.A(adminReplicationGroup, (String)v3);
        CompetableFutureUtils.A((CompletableFuture)a4.A((String)a5, (String)v3, string3, (boolean)a2, 1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, String string2, String string3) {
        void a2;
        void a3;
        Object a4 = string3;
        ReplicationGroupChangesHandler a5 = this;
        try {
            CompetableFutureUtils.A((CompletableFuture)a5.E.getRaftGroupServiceForNode((String)a3).prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4), (long)1L, (TimeUnit)TimeUnit.SECONDS);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = a3;
            a5.K.info(EventTransformationConfiguration.A((Object)"\u0002\u001c-\u0011!\u0019d\t+]7\u0018*\u0019d\r6\u0018i\u0019!\u0011!\t!]?\u0000d\u001b6\u0012)]?\u0000d\t+]?\u0000"), objectArray);
            return;
        }
    }

    private static /* synthetic */ boolean A(String string, NodeInfoWithLabel nodeInfoWithLabel) {
        String a2 = nodeInfoWithLabel;
        String a3 = string;
        if (!a2.getLabel().equals(a3)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void M(String string, String string2, boolean bl, Throwable throwable) {
        Object a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        return a6.A((String)a5, (String)a4, (boolean)a3, (Throwable)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ReplicationGroupConfiguration.Builder A(AdminReplicationGroup adminReplicationGroup) {
        void a2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        ReplicationGroupChangesHandler a3 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getName());
        a2.getMembers().forEach(arg_0 -> ReplicationGroupChangesHandler.A((ReplicationGroupConfiguration.Builder)a3, (AdminReplicationGroup)a2, arg_0));
        return a3;
    }

    private /* synthetic */ String A(String string) {
        Object a2 = string;
        ReplicationGroupChangesHandler a3 = this;
        return (String)a2 + "-" + UUID.randomUUID();
    }

    private /* synthetic */ boolean A() {
        ReplicationGroupChangesHandler a2;
        if (a2.k.findAll().findAny().isEmpty() && a2.b.getRemoteConnections().isEmpty()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<Void> A(String string, String string2, String string3, boolean bl, int n) {
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        try {
            void a2;
            void a3;
            void a4;
            void a5;
            void a6;
            ReplicationGroupChangesHandler a7 = (AdminReplicationGroup)replicationGroupChangesHandler.k.findByName((String)a6).orElseThrow(() -> ReplicationGroupChangesHandler.A((String)a6));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.M((AdminReplicationGroup)a7, (String)a5);
            ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.A((AdminReplicationGroup)a7);
            List<NodeInfoWithLabel> list = builder.getNodesList().stream().filter(arg_0 -> ReplicationGroupChangesHandler.A((String)a4, arg_0)).toList();
            builder.clearNodes();
            builder.addAllNodes(list);
            builder.setPreserveEventstore((boolean)a3);
            return replicationGroupChangesHandler.E.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.A((int)a2, (String)a6, (String)a5, (String)a4, (boolean)a3, arg_0));
        }
        catch (InterruptedException a7) {
            Thread.currentThread().interrupt();
            return CompletableFuture.failedFuture(a7);
        }
        catch (Exception a7) {
            return CompletableFuture.failedFuture(a7);
        }
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ReplicationGroupChangesHandler a2 = leaderConfirmation;
        ReplicationGroupChangesHandler a3 = this;
        long l2 = a3.H.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        try {
            a3.M(a2.replicationGroup());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(String string) {
        block3: {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
            try {
                ReplicationGroupChangesHandler a2 = replicationGroupChangesHandler.H.getRaftNode(RaftAdminGroup.A());
                if (a2.g()) {
                    void a3;
                    replicationGroupChangesHandler.k.findByName((String)a3).ifPresent(arg_0 -> replicationGroupChangesHandler.A((RaftNode)a2, arg_0));
                    return;
                }
            }
            catch (MessagingPlatformException a2) {
                if (ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)a2.getErrorCode())) break block3;
                replicationGroupChangesHandler.K.warn(QueryMetricsWebSocket.A((Object)"\u0003]4@4\u000f%G#L-F(Hf_#A\"F(HfL.N(H#\\"), (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, Collection collection, AdminReplicationGroup adminReplicationGroup, Void void_, Throwable throwable) {
        void a2;
        void a3;
        Object a222 = collection;
        ReplicationGroupChangesHandler a4 = this;
        ReplicationGroupConfiguration.Builder a5 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a3);
        if (a2 != null) {
            void a6;
            Object[] objectArray = new Object[3];
            objectArray[0] = a3;
            objectArray[1] = String.join((CharSequence)EventTransformationConfiguration.A((Object)"Q"), (Iterable<? extends CharSequence>)a222);
            objectArray[2] = a2;
            a4.K.warn(QueryMetricsWebSocket.A((Object)"=R|\u000f\u0005@3C\"\u000f(@2\u000f\"J*J2Jf]#_*F%N2F)AfH4@3_fI4@+\u000f=R"), objectArray);
            a6.getMembers().stream().filter(arg_0 -> ReplicationGroupChangesHandler.A((Collection)a222, arg_0)).forEach(adminReplicationGroupMember -> {
                ReplicationGroupConfiguration.Builder a2 = adminReplicationGroupMember;
                ReplicationGroupConfiguration.Builder a3 = a5;
                a3.addNodes(NodeInfoWithLabel.newBuilder().setLabel(a2.getClusterNodeLabel()).setNode(a2.getClusterNode().toNodeInfo()));
            });
        }
        try {
            a4.E.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a5.build().toByteArray());
            return;
        }
        catch (Exception a222) {
            a4.K.debug(QueryMetricsWebSocket.A((Object)"T;\u0015fj4])]fX.F*JfZ6K'[/A!\u000f%@(I/H3]'[/@(\u000f=R"), (Object)a3, (Object)a222.getMessage());
            return;
        }
    }

    private static /* synthetic */ void A(Map map, ReplicationGroupMember replicationGroupMember) {
        Map a3 = replicationGroupMember;
        Map a4 = map;
        a4.computeIfAbsent(a3.getRole(), a2 -> new HashSet()).add(a3.getNodeName());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(NodeInfo nodeInfo, ClusterNode clusterNode, List list, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = nodeInfo;
        ReplicationGroupChangesHandler a5 = this;
        AdminReplicationGroup adminReplicationGroup = a5.k.findByName((String)a3).orElse(null);
        if (adminReplicationGroup != null) {
            void a6;
            if (adminReplicationGroup.getMemberNames().contains(a4.getNodeName())) {
                a5.K.info(EventTransformationConfiguration.A((Object)"\u00069Gd3+\u0019!]?\u0000d\u00147]%\u00116\u0018%\u0019=])\u0018)\u001f!\u000f"), (Object)adminReplicationGroup, (Object)a4.getNodeName());
                return;
            }
            CompetableFutureUtils.A((CompletableFuture)a5.A(a4.getNodeName(), Role.PRIMARY, (String)a3, (ClusterNode)a6, 1));
            return;
        }
        a5.createReplicationGroup((String)a3, List.of(ReplicationGroupMember.newBuilder().setNodeName(a4.getNodeName()).setPort(a4.getGrpcInternalPort()).setHost(a4.getInternalHostName()).setRole(Role.PRIMARY).build()));
        a2.add(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(ClusterEvents.BecomeLeader becomeLeader, Long l2) {
        void a2;
        ReplicationGroupChangesHandler a3 = becomeLeader;
        ReplicationGroupChangesHandler a4 = this;
        if (a3.term() < a2.longValue()) {
            return;
        }
        a4.M(a3.replicationGroup());
    }

    /*
     * WARNING - void declaration
     */
    public void deleteReplicationGroup(String string, boolean bl) {
        Iterator iterator;
        void a2;
        Object a3 = string;
        ReplicationGroupChangesHandler a4 = this;
        Object object = a3;
        a4.K.info(QueryMetricsWebSocket.A((Object)"\u0002J*J2Jf]#_*F%N2F)AfH4@3_|\u000f=R"), object);
        if (RaftAdminGroup.A((String)object)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(EventTransformationConfiguration.A((Object)"9!\u0011!\t-\u0012*]+\u001bd\u0014*\t!\u000f*\u001c(]6\u00184\u0011-\u001e%\t-\u0012*]#\u000f+\b4]a\u000ed\u0013+\td\u001c(\u0011+\n!\u0019"), objectArray));
        }
        AdminReplicationGroup adminReplicationGroup = a4.k.findByName((String)a3).orElse(null);
        if (adminReplicationGroup == null) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4;
            replicationGroupChangesHandler.K.warn(QueryMetricsWebSocket.A((Object)"\u0005@3C\"\u000f(@2\u000f F(Kf]#_*F%N2F)AfH4@3_fT;\u000f/AfN\"B/Af['M*J5\u0003f\\#A\"F(HfK#C#[#}#_*F%N2F)A\u0001])Z6\u000f2@fN*CfA)K#\\"), a3);
            replicationGroupChangesHandler.b.remoteNodeNames().forEach(arg_0 -> a4.A((String)a3, (boolean)a2, arg_0));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.E.getRaftGroupServiceForNode(replicationGroupChangesHandler2.b.getName()).deleteReplicationGroup((String)a3, (boolean)a2);
            return;
        }
        Collection collection = adminReplicationGroup.getMemberNames();
        CompletableFuture[] completableFutureArray = new CompletableFuture[collection.size()];
        int n = 0;
        Iterator iterator2 = iterator = new HashSet(collection).iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator.next();
            completableFutureArray[n] = a4.E.getRaftGroupServiceForNode(string2).deleteReplicationGroup((String)a3, (boolean)a2).exceptionally(arg_0 -> a4.M(string2, (String)a3, (boolean)a2, arg_0));
            CompletableFuture completableFuture = completableFutureArray[n];
            ++n;
            completableFuture.thenAccept(void_ -> {
                String a2 = string2;
                Collection a3 = collection;
                a3.remove(a2);
            });
            iterator2 = iterator;
        }
        CompetableFutureUtils.A((CompletableFuture)CompletableFuture.allOf(completableFutureArray).whenComplete((arg_0, arg_1) -> a4.A((String)a3, collection, adminReplicationGroup, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(AdminReplicationGroup adminReplicationGroup, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.A((String)a4, a3.getName(), (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage A(int n, String string, String string2, Role role, ClusterNode clusterNode, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.K.warn(QueryMetricsWebSocket.A((Object)"=R|\u000f4J2]?\u000f'K\"F(HfA)K#\u000f=R"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.A((String)a7, (Role)a6, (String)a8, (ClusterNode)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    private static /* synthetic */ MessagingPlatformException G(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(EventTransformationConfiguration.A((Object)"\u0016\u00184\u0011-\u001e%\t-\u0012*]#\u000f+\b4]a\u000ed\u0013+\td\u001b+\b*\u0019"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Set<String> set, Role role) {
        void a2;
        ReplicationGroupChangesHandler a3 = role;
        ReplicationGroupChangesHandler a4 = this;
        a4.J.getNrOfNodes((Role)a3).ifPresent(arg_0 -> a4.A((Role)a3, (Set)a2, arg_0));
    }

    public void init(List<String> list) {
        List<String> a2 = list;
        Object a3 = this;
        if (!a3.A()) {
            throw new MessagingPlatformException(ErrorCode.ALREADY_MEMBER_OF_CLUSTER, QueryMetricsWebSocket.A((Object)"a)K#\u000f/\\fN*]#N\"VfB#B$J4\u000f)IfL*Z5[#]f@4\u000f/A/[/N*F<J\"\u000f$J @4J"));
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a3;
        replicationGroupChangesHandler.K.info(EventTransformationConfiguration.A((Object)"4*\u00140\u0014%\u0011-\u0007%\t-\u0012*]+\u001bd\t,\u00147]*\u0012 \u0018d\n-\t,]\"\u0012(\u0011+\n-\u0013#]'\u0012*\t!\u00050\u000e~]?\u0000"), (Object)a2);
        replicationGroupChangesHandler.A(RaftAdminGroup.A());
        a2.forEach(string -> {
            ReplicationGroupConfiguration a2;
            ReplicationGroupChangesHandler replicationGroupChangesHandler;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler = this;
            ReplicationGroupChangesHandler a3 = replicationGroupChangesHandler2.b.getMe();
            String string2 = replicationGroupChangesHandler2.A(a3.getName());
            RaftGroup raftGroup = replicationGroupChangesHandler2.H.initRaftGroup((String)a2, string2, a3.getName());
            a3 = a3.toNodeInfo();
            a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a2).addNodes(NodeInfoWithLabel.newBuilder().setNode((NodeInfo)a3).setRole(Role.PRIMARY).setLabel(string2)).build();
            CompetableFutureUtils.A((CompletableFuture)replicationGroupChangesHandler2.H.waitForLeader(replicationGroupChangesHandler.H.getRaftGroup(RaftAdminGroup.A())).A(ReplicationGroupConfiguration.class.getName(), a2.toByteArray()));
            replicationGroupChangesHandler.H.waitForLeader(raftGroup);
        });
    }

    private static /* synthetic */ MessagingPlatformException M(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(EventTransformationConfiguration.A((Object)"\u0016\u00184\u0011-\u001e%\t-\u0012*]#\u000f+\b4]a\u000ed\u0013+\td\u001b+\b*\u0019"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string2, Collection<ReplicationGroupMember> collection) {
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.k.findByName((String)a4).ifPresent(arg_0 -> ReplicationGroupChangesHandler.A((String)a4, arg_0));
        a5.A();
        a4 = new EnumMap(Role.class);
        a3.forEach(arg_0 -> ReplicationGroupChangesHandler.A((Map)a4, arg_0));
        a4.forEach((role, set) -> {
            void a2;
            Object a3 = set;
            ReplicationGroupChangesHandler a4 = this;
            a4.A((Set)a3, (Role)a2);
        });
        a4 = a3.stream().map(ReplicationGroupMember::getNodeName).filter(string -> {
            Object a2 = string;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.b.getNode((String)a2) == null) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (!a4.isEmpty()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(QueryMetricsWebSocket.A((Object)"\b@\"Jn\\o\u000fc\\fA)[fI)Z(K"), objectArray));
        }
        if (a3.stream().noneMatch(a2 -> a2.getRole().equals((Object)Role.PRIMARY))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, EventTransformationConfiguration.A((Object)"3+]4\u000f-\u0010%\u000f=]*\u0012 \u00187]4\u000f+\u000b-\u0019!\u0019"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationGroupChangesHandler(AdminReplicationGroupController adminReplicationGroupController, ClusterController clusterController, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, TaskPublisher taskPublisher, GrpcRaftController grpcRaftController) {
        ReplicationGroupChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReplicationGroupChangesHandler a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = replicationGroupChangesHandler2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = grpcRaftController;
        ReplicationGroupChangesHandler replicationGroupChangesHandler3 = a8 = replicationGroupChangesHandler;
        ReplicationGroupChangesHandler replicationGroupChangesHandler4 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler5 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler6 = a8;
        replicationGroupChangesHandler6.I = 1;
        replicationGroupChangesHandler6.K = LoggerFactory.getLogger(ReplicationGroupChangesHandler.class);
        replicationGroupChangesHandler5.k = a7;
        replicationGroupChangesHandler5.b = a6;
        replicationGroupChangesHandler4.E = a5;
        replicationGroupChangesHandler4.J = a4;
        replicationGroupChangesHandler3.M = a3;
        replicationGroupChangesHandler3.H = a2;
    }

    @EventListener
    @Order(value=5)
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ReplicationGroupChangesHandler a2 = becomeLeader;
        ReplicationGroupChangesHandler a3 = this;
        a3.H.currentTerm(a2.replicationGroup()).ifPresent(arg_0 -> a3.A((ClusterEvents.BecomeLeader)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(AdminReplicationGroup adminReplicationGroup, String string) throws InterruptedException, ExecutionException {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = replicationGroupChangesHandler.E.getLeader(a3.getName());
        if (a3.getMembers().size() > 1 && a2.equals(a4)) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.K.info(EventTransformationConfiguration.A((Object)"?\u0000~](\u0018%\u0019!\u000fd\u00147]?\u0000"), (Object)a3, a4);
            replicationGroupChangesHandler2.E.getRaftGroupService(a3.getName()).transferLeadership(a3.getName()).get();
            a4 = replicationGroupChangesHandler.E.getLeader(a3.getName());
            Object object = a4;
            for (int i2 = 25; (object == null || ((String)a4).equals(a2)) && i2 > 0; --i2) {
                Thread.sleep(250L);
                object = a4 = replicationGroupChangesHandler.E.getLeader(a3.getName());
            }
            if (a4 == null || ((String)a4).equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.OTHER, QueryMetricsWebSocket.A((Object)"\u000b@0F(HfC#N\"J4\u000f2@f@2G#]fA)K#\u000f N/C#K"));
            }
            replicationGroupChangesHandler.K.info(EventTransformationConfiguration.A((Object)"?\u0000~](\u0018%\u0019!\u000fd\u001e,\u001c*\u001a!\u0019d\t+]?\u0000"), (Object)a3, a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Node A(ClusterNode clusterNode, String string, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = clusterNode;
        ReplicationGroupChangesHandler a5 = this;
        return Node.newBuilder().setNodeId((String)a3).setHost(a4.getInternalHostName()).setPort(a4.getGrpcInternalPort().intValue()).setNodeName(a4.getName()).setRole(RoleUtils.A((Role)a2)).build();
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Void> addNodeToReplicationGroup(String string, String string2, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.K.info(EventTransformationConfiguration.A((Object)"< \u0019d\u0013+\u0019!]6\u00185\b!\u000e0]-\u00132\u0012/\u0018 ]\"\u00126]*\u0012 \u0018~]?\u0000dPd\u001c*\u0019d\u001e+\u00130\u0018<\t~]?\u0000"), a5, (Object)a3);
        if (!replicationGroupChangesHandler.b.isActive((String)a5)) {
            throw new MessagingPlatformException(ErrorCode.AXONSERVER_NODE_NOT_CONNECTED, (String)a5 + ": cannot add node to a replication group when it is not active");
        }
        if (a4.E.getLeader((String)a3) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a3 + ": cannot add node to a replication group when it does not have a leader");
        }
        ClusterNode clusterNode = a4.b.getNode((String)a5);
        if (clusterNode == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(QueryMetricsWebSocket.A((Object)"a)K#\u000fc\\fA)[fI)Z(K"), objectArray));
        }
        Object object = a5;
        a4.A(Collections.singleton(object), (Role)a2);
        return a4.A((String)object, (Role)a2, (String)a3, clusterNode, 1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Role role, Set set, Integer n) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Set a5 = set;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        int n2 = replicationGroupChangesHandler.k.nrOfNodesInRole((Role)a3, a5);
        Object[] objectArray = new Object[4];
        objectArray[0] = n2;
        objectArray[1] = a3;
        objectArray[2] = a5;
        objectArray[3] = a2;
        replicationGroupChangesHandler.K.debug(QueryMetricsWebSocket.A((Object)"T;\u000f(@\"J5\u000f1F2Gf])C#\u000f=RfI)Z(KfX.F*Jf[4V/A!\u000f2@fN\"KfT;\u0003fB'WfN*C)X#KfF5\u000f=R"), objectArray);
        if (n2 + a5.size() > a2.intValue()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = a5.size();
            objectArray2[1] = a3;
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, String.format(EventTransformationConfiguration.A((Object)"1-\u001e!\u00137\u0018d\u0019+\u00187]*\u00120]%\u0011(\u00123]%\u0019 \u0014*\u001adX ])\u00126\u0018d\u0013+\u0019!U7Td\n-\t,]6\u0012(\u0018~]a\u000e"), objectArray2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(RaftNode raftNode, AdminReplicationGroup adminReplicationGroup) {
        ReplicationGroupChangesHandler a2 = adminReplicationGroup;
        ReplicationGroupChangesHandler a3 = this;
        if (a2.isChangePending()) {
            void a4;
            a2 = a3.A((AdminReplicationGroup)a2).setPending(false).build();
            a4.A(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void A(String string, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        ReplicationGroupChangesHandler a4 = this;
        a4.deleteReplicationGroup((String)a2, false);
        throw MessagingPlatformException.create((Throwable)a3);
    }

    private /* synthetic */ void M() {
        ReplicationGroupChangesHandler a2;
        if (a2.b.nodes().count() > (long)a2.J.getMaxClusterSize().orElse(1).intValue()) {
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, QueryMetricsWebSocket.A((Object)"{)@fB'A?\u000f(@\"J5\u000f/AfL*Z5[#]"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void A(String string, String string2, boolean bl, Throwable throwable) {
        void a2;
        void a3;
        void a4;
        Throwable a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = throwable2;
        Throwable throwable2 = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        if (!Status.UNAVAILABLE.getCode().equals((Object)Status.fromThrowable((Throwable)a5).getCode())) {
            if (a5 instanceof RuntimeException) {
                throw (RuntimeException)a5;
            }
            throw new MessagingPlatformException(ErrorCode.OTHER, a5.getMessage(), a5);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a4;
        objectArray[1] = a3;
        objectArray[2] = Status.fromThrowable((Throwable)a5);
        a6.K.warn(EventTransformationConfiguration.A((Object)"\u0007\u00121\u0011 ]*\u00120] \u0018(\u00180\u0018d\u000f!\r(\u0014'\u001c0\u0014+\u0013d\u001a6\u00121\rd\u00069]\"\u000f+\u0010d\u00069]7\t%\t1\u000ed\u00069Qd\r1\u001f(\u00147\u0015-\u0013#]6\u00180\u000f=]0\u001c7\u0016"), objectArray);
        a6.M.publishScheduledTask(RaftAdminGroup.A(), DeleteReplicationGroupTask.class.getName(), (Object)new DeleteReplicationGroupPayload((String)a3, (String)a4, (boolean)a2), Duration.ofSeconds(1L));
        return null;
    }

    private /* synthetic */ void A() {
        ReplicationGroupChangesHandler a2;
        a2.J.getMaxReplicationGroups().ifPresent(n -> {
            Integer a2 = n;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.k.count() > a2) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, QueryMetricsWebSocket.A((Object)"\u000bN>F+Z+\u000f(Z+M#]f@ \u000f4J6C/L'[/@(\u000f!])Z6\\f]#N%G#K"));
            }
        });
        a2.M();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(AdminReplicationGroup adminReplicationGroup, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = a3.getMemberNames();
        Collection collection = replicationGroupChangesHandler.k.getNodeNames(RaftAdminGroup.A());
        Object object = a4 = new HashSet(a4);
        object.addAll(collection);
        object.forEach(arg_0 -> replicationGroupChangesHandler.A((AdminReplicationGroup)a3, (String)a2, arg_0));
    }

    private static /* synthetic */ boolean A(Collection collection, AdminReplicationGroupMember adminReplicationGroupMember) {
        Collection a2 = adminReplicationGroupMember;
        Collection a3 = collection;
        return a3.contains(a2.getClusterNode().getName());
    }

    private static /* synthetic */ MessagingPlatformException A(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(QueryMetricsWebSocket.A((Object)"\u0014J6C/L'[/@(\u000f!])Z6\u000fc\\fA)[fI)Z(K"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public void createReplicationGroup(String string, Collection<ReplicationGroupMember> collection) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        replicationGroupChangesHandler.A((String)a3, (Collection)a2);
        ArrayList arrayList = new ArrayList();
        AtomicReference a4 = new AtomicReference();
        a2.forEach(replicationGroupMember -> {
            void a2;
            void a3;
            ReplicationGroupChangesHandler a4;
            ReplicationGroupChangesHandler a5 = replicationGroupMember;
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
            ClusterNode clusterNode = replicationGroupChangesHandler.b.getNode(a5.getNodeName());
            String string = replicationGroupChangesHandler.A(a5.getNodeName());
            a5 = replicationGroupChangesHandler.A(clusterNode, string, a5.getRole());
            if (a3.get() == null && Role.PRIMARY.equals((Object)a5.getRole())) {
                a3.set(a5);
            }
            a2.add(a5);
        });
        CompetableFutureUtils.A((CompletableFuture)((CompletableFuture)replicationGroupChangesHandler.E.getRaftGroupServiceForNode(((Node)a4.get()).getNodeName()).initReplicationGroup((String)a3, arrayList).thenAccept(replicationGroupConfiguration -> {
            ReplicationGroupChangesHandler a2 = replicationGroupConfiguration;
            ReplicationGroupChangesHandler a3 = this;
            a2 = a2.toBuilder().setPending(false).build();
            a3.E.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        })).exceptionally(arg_0 -> replicationGroupChangesHandler.A((String)a3, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage A(int n, String string, String string2, String string3, boolean bl, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.K.warn(EventTransformationConfiguration.A((Object)"?\u0000~]6\u00180\u000f=] \u0018(\u00180\u0014*\u001ad\u0013+\u0019!]?\u0000"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.A((String)a8, (String)a7, (String)a6, (boolean)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<Void> A(String string, Role role, String string2, ClusterNode clusterNode, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler a62;
        void a7;
        ReplicationGroupChangesHandler replicationGroupChangesHandler;
        block3: {
            replicationGroupChangesHandler = this;
            try {
                a62 = (AdminReplicationGroup)replicationGroupChangesHandler.k.findByName((String)a7).orElseThrow(() -> ReplicationGroupChangesHandler.M((String)a7));
                if (!a62.getMemberNames().contains(a5)) break block3;
                replicationGroupChangesHandler.K.info(EventTransformationConfiguration.A((Object)"?\u0000d\u001c(\u000f!\u001c \u0004d\u001e+\u00130\u001c-\u00137]*\u0012 \u0018~]?\u0000"), (Object)a7, (Object)a5);
                return CompletableFuture.completedFuture(null);
            }
            catch (MessagingPlatformException a62) {
                return CompletableFuture.failedFuture(a62);
            }
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
        ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.A((AdminReplicationGroup)a62);
        String string3 = replicationGroupChangesHandler2.A((String)a5);
        builder.addNodes(NodeInfoWithLabel.newBuilder().setNode(a4.toNodeInfo()).setLabel(string3).setRole((Role)a3));
        return replicationGroupChangesHandler2.E.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.A((int)a2, (String)a7, (String)a5, (Role)a3, (ClusterNode)a4, arg_0));
    }

    private static /* synthetic */ void A(String string, AdminReplicationGroup adminReplicationGroup) {
        String a2 = adminReplicationGroup;
        String a3 = string;
        Object[] objectArray = new Object[1];
        objectArray[0] = a3;
        throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_EXISTS, String.format(EventTransformationConfiguration.A((Object)"/!\r(\u0014'\u001c0\u0014+\u0013d\u001a6\u00121\rdX7]%\u00116\u0018%\u0019=]!\u0005-\u000e0\u000e"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public List<String> joinReplicationGroups(NodeInfo nodeInfo, List<String> list) {
        void a2;
        List<String> a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = new LinkedList();
        if (a3.isEmpty()) {
            a3 = replicationGroupChangesHandler.k.findAll().map(AdminReplicationGroup::getName).toList();
        }
        ClusterNode clusterNode = replicationGroupChangesHandler.b.getNode(a2.getNodeName());
        a3.forEach(arg_0 -> replicationGroupChangesHandler.A((NodeInfo)a2, clusterNode, (List)a4, arg_0));
        return a4;
    }

    private static /* synthetic */ MessagingPlatformException A(String string, String string2) {
        String a2 = string2;
        String a3 = string;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3;
        objectArray[1] = a2;
        return new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(QueryMetricsWebSocket.A((Object)"\b@\"Jf\n5\u000f(@2\u000f @3A\"\u000f/Af]#_*F%N2F)A\u0001])Z6\u000fc\\"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, boolean bl, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.E.getRaftGroupServiceForNode((String)a4).deleteReplicationGroup((String)a3, (boolean)a2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void A(ReplicationGroupConfiguration.Builder builder, AdminReplicationGroup adminReplicationGroup, AdminReplicationGroupMember adminReplicationGroupMember) {
        void a2;
        ReplicationGroupConfiguration.Builder a3 = adminReplicationGroupMember;
        ReplicationGroupConfiguration.Builder a4 = builder;
        a4.setPending(a2.isChangePending()).addNodes(NodeInfoWithLabel.newBuilder().setNode(a3.getClusterNode().toNodeInfo()).setLabel(a3.getClusterNodeLabel()).setRole(a3.getRole()).build());
    }
}

