/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final LicenseAccessController C;
    private final ExecutorService e;
    private AdvancedTlsX509KeyManager.Closeable d;
    private final MessagingPlatformConfiguration B;
    private final Supplier<ScheduledExecutorService> H;
    private final MeterFactory K;
    private final AxonServerAccessController M;
    private boolean J;
    private final Logger b;
    private Server E;
    private final List<ServerTransportFilter> I;
    private final List<AxonServerClientService> k;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.b = LoggerFactory.getLogger(Gateway.class);
        gateway6.B = a8;
        gateway5.k = a7;
        gateway5.I = a6;
        gateway4.M = a5;
        gateway4.C = a4;
        a9.H = a3;
        gateway3.K = a2;
        gateway3.e = Executors.newFixedThreadPool(a9.B.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(EventStoreTransformationRestController.A((Object)"\u00101\u0007 Z&\u000f&\u00146\u0003,\u0005n")));
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.d != null) {
            gateway.d.close();
        }
        Gateway gateway2 = gateway;
        gateway2.e.shutdown();
        if (gateway2.J) {
            try {
                if (!gateway.E.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.b.debug(ClientVersionsCache.A((Object)"(Y\u001cU\u000bP\u001bZ\u0002ONE\u001aY\u001eF\u0007X\t\u0016-Z\u001bE\u001aS\u001c\u0016=S\u001c@\u000bD"));
                    gateway3.E.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.b.debug(EventStoreTransformationRestController.A((Object)">-\u0003&\u00051\u00023\u0003&\u0013c\u00136\u0005*\u0019$W0\u001f6\u0003'\u00184\u0019c\u0018%W\u0004%\u00134c\u0004&\u00055\u00121"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.J = false;
        gateway.b.info(ClientVersionsCache.A((Object)"w\u0016Y\u0000\u0016=S\u001c@\u000bDNq\u000fB\u000bA\u000fONE\u001aY\u001eF\u000bR"));
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.J;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = EventStoreTransformationRestController.A((Object)"\u0019,W\u0010$\u000f");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.B.getSsl() != null && gateway.B.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.d = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.B.getSsl().getPrivateKeyFile()), new File(gateway.B.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.H.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = ClientVersionsCache.A((Object)"e=zNS\u0000W\fZ\u000bR");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.B.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.B.getPort());
            }
            if (gateway2.B.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.B.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.B.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.k.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.B.getGrpcBufferedMessages()));
            if (gateway.B.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.M, gateway5.K));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.C));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.B.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.B.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.B.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.e);
            gateway.I.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.E = a2.build();
            gateway.E.start();
            gateway.b.info(EventStoreTransformationRestController.A((Object)"6;\u0018-W\u0010\u00121\u0001&\u0005c0\"\u0003&\u0000\"\u000ec\u00047\u00161\u0003&\u0013c\u0018-W3\u00181\u0003yW8\ncZc\f>"), (Object)gateway.B.getPort(), (Object)string);
            gateway.J = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(ClientVersionsCache.A((Object)"e\u001aW\u001cB\u0007X\t\u0016/N\u0001XNe\u000bD\u0018S\u001c\u0016)W\u001aS\u0019W\u0017\u0016\bW\u0007Z\u000bR"), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public int getPhase() {
        return 200;
    }

    public boolean isAutoStartup() {
        return true;
    }
}

