/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final ApplicationEventPublisher K;
    private final Map<ClientStreamIdentification, Instant> M;
    private final Logger J;
    private final Clock b;
    private final Publisher<PlatformOutboundInstruction> E;
    private final Map<ClientStreamIdentification, ClientInformation> I;
    private final long k;

    private static /* synthetic */ void A(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.A((BiConsumer)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.A((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.J.debug(ReplicationRestControllerV2.A((Object)"rjTaZk_e\u0011a^l_gRvTf\u0011a]kTlEq\u0011cCg\u0011qEk]n\u0011c]kGg\u001f,\u001f"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.b).minus(heartbeatMonitor3.k, ChronoUnit.MILLIS);
        heartbeatMonitor3.M.forEach((arg_0, arg_1) -> heartbeatMonitor.A((Instant)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.A(), a2.G());
        a3.I.put(clientStreamIdentification, new ClientInformation(a2.M(), a2.I(), a2.A()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.I.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.I.get(a4);
            String string = clientInformation.E;
            String string2 = clientInformation.I;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.k;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.J.info(ReplicationRestControllerV2.A((Object)"rnXg_v\u0011k_cRvXtXvH\"UgEgRvTf\u0011d^p\u0011o^pT\"EjPl\u0011yL\"\\k]nXqTa^lUq\u001f\"rnXg_v\u000b\"J\u007f\u001d\"]cBvpaEkGkE{\u000b\"J\u007f\u001d\"Ek\\g^wE8\u0011yL,\u0011"), objectArray);
            a5.K.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.k)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void A(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.J = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.I = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.M = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.J.trace(RestResponse.A((Object)"(.\u00019\u0014\t\u0005*\u0014k\u0012.\u0003.\t=\u0005/@-\u0012$\rk\u001b6"), (Object)a3);
            heartbeatMonitor.M.put(a3, Instant.now(a2.b));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.b = a5;
        heartbeatMonitor5.K = a4;
        heartbeatMonitor4.k = a3;
        heartbeatMonitor4.E = a2;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.g(), a2.I());
        a3.M.remove(a2);
        a3.I.remove(a2);
        a3.J.debug(RestResponse.A((Object)"3?\u000f;@&\u000f%\t?\u000f9\t%\u0007k\b.\u00019\u0014)\u0005*\u0014k\u0006$\u0012k\u0003'\t.\u000e?@0\u001de"), (Object)a2);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.E.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }
}

