/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage;

import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.QueryOptions;
import io.axoniq.axonserver.localstorage.Registration;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventStorageEngine {
    public Optional<SerializedEvent> getLastEvent(String var1, long var2, long var4);

    public Flux<Long> transformContents(int var1, Flux<EventWithToken> var2);

    default public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        EventStorageEngine a2 = backupIndexConfig;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException();
    }

    public void query(QueryOptions var1, Predicate<EventWithToken> var2);

    public long size();

    public long nextToken();

    public long getFirstToken();

    default public void validateTransaction(long l2, List<Event> eventStorageEngine) {
        Object a2 = eventStorageEngine;
        eventStorageEngine = this;
    }

    default public void close(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine eventStorageEngine = this;
    }

    default public long getLastToken() {
        return -1L;
    }

    default public void init(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine a3 = this;
        a3.init(a2, 0L);
    }

    default public Mono<Void> deleteOldVersions() {
        return Mono.error((Throwable)new UnsupportedOperationException(EventStoreTransformationRestController.A((Object)"\u0013&\u001b&\u0003&$&\u0010.\u0012-\u00030Mc83\u00121\u00167\u001e,\u0019c\u0019,\u0003c\u00046\u00073\u00181\u0003&\u0013c\u0015:W7\u001f*\u0004c25\u0012-\u0003\u0010\u0003,\u0005\"\u0010&2-\u0010*\u0019&")));
    }

    public void processEventsPerAggregateHighestFirst(String var1, long var2, long var4, int var6, Predicate<SerializedEvent> var7, Consumer<SerializedEvent> var8);

    public Optional<Long> getLastSequenceNumber(String var1, SearchHint ... var2);

    public CloseableIterator<SerializedEventWithToken> getGlobalIterator(long var1);

    default public Optional<Long> getLastSequenceNumber(String string, SearchHint searchHint, long l2) {
        Object a2 = string;
        EventStorageEngine a3 = this;
        return a3.getLastSequenceNumber((String)a2, new SearchHint[0]);
    }

    default public Stream<String> getBackupFilenames(long l2, int n, boolean bl) {
        boolean bl2 = bl;
        EventStorageEngine a2 = this;
        throw new UnsupportedOperationException();
    }

    default public long getFirstCompletedSegment() {
        return -1L;
    }

    public long getTokenAt(long var1);

    public Registration registerCloseListener(Runnable var1);

    default public byte transactionVersion() {
        return 0;
    }

    public EventTypeContext getType();

    public CloseableIterator<SerializedTransactionWithToken> transactionIterator(long var1, long var3);

    default public long store(List<Event> list) {
        Object a2 = list;
        EventStorageEngine a3 = this;
        return a3.store((List)a2, 0);
    }

    default public boolean validateSnapshot(SerializedEvent serializedEvent) {
        EventStorageEngine a2 = serializedEvent;
        EventStorageEngine a3 = this;
        return true;
    }

    default public long store(List<Event> list, int n) {
        int a2 = n;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException(ReplicationGroupConfiguration.A((Object)"F\u0014z\u0012p@z\u0010p\u0012t\u0014|\u000f{@{\u000fa@f\u0015e\u0010z\u0012a\u0005q"));
    }

    public void processEventsPerAggregate(String var1, long var2, long var4, long var6, Consumer<SerializedEvent> var8);

    public Flux<SerializedEvent> eventsPerAggregate(String var1, long var2, long var4, long var6);

    public void init(boolean var1, long var2);

    default public Registration registerEventListener(BiConsumer<Long, List<Event>> biConsumer) {
        Object a2 = biConsumer;
        EventStorageEngine a3 = this;
        return () -> {};
    }
}

