/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.D;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final Synchronizer B;
    private final Gauge H;
    private final MeterFactory K;
    private static final Logger d = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final EventTransformer M;
    private final FileSystemMonitor J;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> b;
    protected final AtomicLong E;
    protected final AtomicReference<WritePosition> I;
    private Path k;

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.A(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion A(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.A((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::A).filter(arg_0 -> WritableFileStorageTier.A((long)a3, arg_0)).max(FileVersion::A).orElse((FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.b.remove(a2.I);
        d.debug(MeterFactory.A((Object)" \f\u0006\t\r\tH\u0002\u001e\b\u001aM\u0013\u0010DM\u001a\b\u0005\f\u0001\u0003\u0001\u0003\u000fM\u001b\b\u000f\u0000\r\u0003\u001c\u001eRM\u0013\u0010"), (Object)a2.I, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.A((long)((StorageProperties)writableFileStorageTier.I.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.b.get(a2);
        if (a3 != null) {
            return a3.A();
        }
        return (Integer)writableFileStorageTier.A(arg_0 -> WritableFileStorageTier.A((Long)a2, arg_0), (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.A(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.A(a5.A());
                a5 = writableFileStorageTier3.A(a5, (StorageProperties)a4);
                writableFileStorageTier3.A((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.A());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.M();
                a4 = writableFileStorageTier4.A(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.h.remove(a5);
                a6 = a5.A();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.A();
                        if (eventInformation.A()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.A().getAggregateSequenceNumber(), eventInformation.A(), a6);
                            a222.computeIfAbsent(eventInformation.A().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.A();
                writableFileStorageTier2.E.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.h.addToActiveSegment(Long.valueOf(a5.A()), a222);
        a4.A(n, 0);
        a3 = new WritePosition(a6, n, a5.A(), a4, Long.valueOf(a5.A()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.I.set(a3);
        writableFileStorageTier6.B.M((WritePosition)a3);
        d.info(MeterFactory.A((Object)"\u0013\u0010RM;\b\u000f\u0000\r\u0003\u001c\u001eH\u0004\u0006\u0004\u001c\u0004\t\u0001\u0001\u0017\r\t"), (Object)writableFileStorageTier2.F);
    }

    private static /* synthetic */ Optional M(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition A(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.A(a5, (int)a3, (int)a2);
    }

    private /* synthetic */ void M() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.A((SortedSet)a2);
        }
        d.info(EventTransformationConfiguration.A((Object)"\u00069Gd4*\u0019!\u0005d\u0012*] \u00147\u0016d\u00147]1\rd\t+] \u001c0\u0018"), (Object)writableFileStorageTier.F);
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.J);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.J.unregisterPath(writableFileStorageTier2.A());
        writableFileStorageTier.K.remove((Meter)a3.H);
        writableFileStorageTier2.B.M();
        writableFileStorageTier.b.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.A(0L);
            if (a2 != false) {
                void a5;
                a4.M(a5.longValue());
            }
        });
        a3.A((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.h.cleanup(bl2);
        if (bl2) {
            FileUtils.A((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.A((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.A(arg_0 -> WritableFileStorageTier.A((long)a2, arg_0), Optional.empty());
    }

    protected Optional<EventSource> A(long a2) {
        WritableFileStorageTier a3;
        if (a3.b.containsKey(a2)) {
            return Optional.of((EventSource)a3.b.get(a2));
        }
        return Optional.empty();
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.b.values().stream().mapToLong(a2 -> a2.J.capacity()).sum() + (Long)a3.A(StorageTier::size, (Object)0L);
    }

    public long G() {
        WritableFileStorageTier a2;
        return a2.E.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.M.A((List)a3, writableFileStorageTier.J, writableFileStorageTier.k, (arg_0, arg_1, arg_2) -> a5.A((Map)a2, arg_0, arg_1, arg_2));
    }

    private static /* synthetic */ boolean A(long a2, FileVersion a3) {
        if (a3.A() < a2) {
            return true;
        }
        return false;
    }

    private /* synthetic */ int A(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.F + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    /*
     * WARNING - void declaration
     */
    public void G(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.b.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.b.firstKey()).longValue()) {
            d.info(MeterFactory.A((Object)"\u0013\u0010RM.\u0002\u001a\u000e\u0001\u0003\u000fM\u0006\b\u0010\u0019H\u001e\r\n\u0005\b\u0006\u0019H\u0019\u0007M\n\bH\u000e\u001a\b\t\u0019\r\t"), (Object)writableFileStorageTier.F);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.I.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.I.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.A(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.M(a22.getSegmentSize())) {
                d.debug(EventTransformationConfiguration.A((Object)"\u00069Gd>6\u0018%\t-\u0013#]*\u00183]7\u0018#\u0010!\u00130]?\u0000"), (Object)writableFileStorageTier.F, (Object)writePosition2.k);
                WritePosition writePosition3 = writePosition2;
                writePosition3.M.A(writePosition3.J, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.A(new FileVersion(writePosition2.k, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.I.set(writePosition2.A((WritableEventSource)a3, 0));
                writableFileStorageTier2.B.A(new WritePosition(writePosition2.k, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.k), writePosition2.H));
            }
        }
        writableFileStorageTier.A();
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.A(arg_0 -> WritableFileStorageTier.A((String)a2, arg_0), (Object)Flux.empty());
    }

    public long A(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.J.checkFreeSpace(writableFileStorageTier2.k);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.A((List)a2, a222);
        WritePosition a222 = a2.A();
        writableFileStorageTier2.A(a222, a2.A(), hashMap);
        writableFileStorageTier.h.addToActiveSegment(a222.I, hashMap);
        writableFileStorageTier.E.set(a222.k + (long)a2.A().size() - 1L);
        writableFileStorageTier.B.A(a222);
        return a222.k;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new D(a4, (WritePosition)a3), () -> a4.M((WritePosition)a3));
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.I = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.E = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.b = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.K = a6;
        writableFileStorageTier3.J = a4;
        writableFileStorageTier3.M = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.B = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.h.complete(new FileVersion(a3.I.longValue(), 0));
            writableFileStorageTier.A(arg_0 -> writableFileStorageTier.A((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.A();
        stringArray[2] = "type";
        stringArray[3] = a10.A().name();
        a11.H = a6.gauge((MetricName)BaseMetricName.i, Tags.of((String[])stringArray), (Object)a11.B, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.E.get() - (double)a2.A();
        });
    }

    private static /* synthetic */ Stream M(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource A(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.I.get();
            File file = storageProperties.dataFile(writableFileStorageTier.J, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.b.remove(a4.A());
                    if (object != null) {
                        object.A(0L);
                    }
                    FileUtils.A((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.A() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.J, new FileVersion(a4.A(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.b.remove(a4.A());
                    if (a32222 != null) {
                        a32222.A(0L);
                    }
                    FileUtils.A((File)object);
                }
            }
            object = new RandomAccessFile(file, MeterFactory.A((Object)"\u001a\u001a"));
            a32222 = ((RandomAccessFile)object).getChannel();
            d.info(EventTransformationConfiguration.A((Object)"\u00069Gd24\u0018*\u0014*\u001ad\u001b-\u0011!]?\u0000"), (Object)writableFileStorageTier.F, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.A(), a4.A(), writableFileStorageTier.M, storageProperties);
            writableFileStorageTier.b.put(a4.A(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.F + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.A(arg_0 -> WritableFileStorageTier.A((long)a2, a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction A(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.M);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.A((List)a3);
        WritePosition a22 = writableFileStorageTier.A(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void A(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.I.get();
        File file = new File(writableFileStorageTier.J);
        FileUtils.A((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.h.init();
        writableFileStorageTier2.A((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.k = file.toPath();
        writableFileStorageTier2.J.registerPath(writableFileStorageTier.A(), writableFileStorageTier.k, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    private static /* synthetic */ Boolean A(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.b.containsKey((long)a2)) {
            return a4.A((long)a2, a3);
        }
        return (Boolean)a4.A(arg_0 -> WritableFileStorageTier.A((long)a2, a3, arg_0), (Object)true);
    }

    private static /* synthetic */ Optional A(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.A((long)a2, a3.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> A(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.b.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.A((File)a3.M(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).A())));
            }), (Stream)a5.A(arg_0 -> WritableFileStorageTier.A((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.A(arg_0 -> WritableFileStorageTier.M((long)a2, a4, arg_0), Stream.empty());
    }

    private static /* synthetic */ Optional A(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean A(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.b.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.A(0L);
        }
        if (a4.h.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.A((File)a4.M(a3))) {
            return true;
        }
        return false;
    }

    public long M() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.I.get()).k;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition A(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(MeterFactory.A((Object)"!\u0001\u0004\b\u000f\f\u0004M\u001c\u001f\t\u0003\u001b\f\u000b\u0019\u0001\u0002\u0006M\u001b\u0004\u0012\bRMM\t"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.I.getAndUpdate(arg_0 -> WritableFileStorageTier.A((int)a3, n4, (int)a2, arg_0))).M(n4) && !a4.G((int)a2)) continue;
            d.debug(EventTransformationConfiguration.A((Object)"\u00069Gd>6\u0018%\t-\u0013#]*\u00183]7\u0018#\u0010!\u00130]?\u0000"), (Object)a5.F, (Object)a4.k);
            WritePosition writePosition = a4;
            writePosition.M.A(writePosition.J, -1);
            WritableEventSource writableEventSource = a5.A(new FileVersion(a4.k, (int)a2), n4 + 5 + 4, true);
            a5.I.set(a4.A(writableEventSource, (int)a2));
        } while (!a4.A(n4) || a4.G((int)a2));
        return a4;
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.b.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion A(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.h.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.A((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.A();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.A());
            try {
                while (a42222.hasNext()) {
                    a42222.A();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.b.remove(a3.A());
            a2.A(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.b.remove(a3.A());
        a2.A(0L);
        return new FileVersion(l2, 0);
    }

    private static /* synthetic */ Integer A(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    private static /* synthetic */ void A(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    private static /* synthetic */ Stream A(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.b.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.A();
            byteBufferEventSource2.A(0L);
        }
        writableFileStorageTier.A((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.A((long)a2, arg_0));
    }

    private /* synthetic */ void A() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.b.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.F + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    protected Optional<EventSource> A(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.A(a2.A());
    }

    public int A() {
        WritableFileStorageTier a2;
        return a2.b.size();
    }

    private /* synthetic */ void A(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        d.warn(MeterFactory.A((Object)"\u0016\u0015WH/\u001d\u0001\u0003@\u000b\u001f\r\f\u001c\u0004\u0006\nH\u0004\u0006\t\r\u0015H\b\u0006\u0019\u001a\u0004\r\u001eH\u000b\u0007\u001fH\u0016\u0015M\u001b\b\u000f\u0000\r\u0003\u001c\u001e"), (Object)a3.F, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.h.canBatchIndexParallel() && ((StorageProperties)a3.I.get()).isBulkIndexAllowParallel()) {
            d.info(EventTransformationConfiguration.A((Object)"?\u0000~]\r\u0013 \u0018<\u0014*\u001ad\n-\t,]4\u001c6\u001c(\u0011!\u0011d\u000e1\r4\u00126\t"), (Object)a3.F);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.A(arg_0 -> WritableFileStorageTier.A((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.A());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.A();
                        if (!eventInformation.A()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.A().getAggregateSequenceNumber(), eventInformation.A(), eventInformation.A());
                        hashMap.computeIfAbsent(eventInformation.A().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.h.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.F;
            objectArray[1] = a3.h.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.I.get()).isBulkIndexAllowParallel();
            d.info(MeterFactory.A((Object)"\u0016\u0015WH$\u0006\t\r\u0015\u0001\u0003\u000fM\u001b\b\u0019\u0018\r\u0003\u001c\u0004\t\u0001\u0004\u0014HE-\u001b\t\u0001\u001d\f\u001c\u0004\u0007\u0003H\u0002\u000eM\u0018\f\u001a\f\u0004\u0001\r\u0001H\u0004\u0006\t\r\u0015\u0001\u0003\u000fWH\u0004\u0006\t\r\u0015+\f\u0018\f\n\u0004\u0004\u0004\u001c\u0004\r\u001eR\u0016\u0015MNKH\u000e\u0007\u0003\u001c\b\u0010\u0019;\b\u001c\u0019\u0001\u0003\u000f\u001eR\u0016\u0015D"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.A(arg_0 -> WritableFileStorageTier.A((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.A());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.A();
                        if (!eventInformation.A()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.A().getAggregateSequenceNumber(), eventInformation.A(), eventInformation.A());
                        hashMap.computeIfAbsent(eventInformation.A().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.h.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        d.warn(EventTransformationConfiguration.A((Object)"\u00069Gd?1\u0011/P'\u000f!\u001c0\u0014*\u001ad\u0014*\u0019!\u0005d\t+\u0012/]?\u0000"), (Object)a3.F, (Object)Duration.between(instant, Instant.now()));
    }

    public void initSegments(long a2) {
    }

    public long A() {
        WritableFileStorageTier a3;
        return (Long)a3.A((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.A((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.A((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.A(arg_0 -> WritableFileStorageTier.M((FileVersion)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ Flux A(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    private /* synthetic */ String A() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.F + "-" + writableFileStorageTier.F.A().name().toLowerCase();
    }
}

