/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.enterprise.cluster.EventProcessorSynchronizer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.xref.D;
import io.axoniq.axonserver.localstorage.file.xref.Index;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ReadOnlyJumpSkipIndexManager
implements IndexManager {
    protected final Supplier<IndexManager> l;
    private static final Logger L = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);
    protected final ConcurrentSkipListMap<FileVersion, Index> F;
    protected final AtomicLong A;
    protected final ConcurrentNavigableMap<Long, Integer> f;
    protected final String G;
    protected static final ScheduledExecutorService C;
    protected final AtomicLong e;
    protected ScheduledFuture<?> d;
    protected final EventType B;
    protected final MeterFactory.RateMeter H;
    protected final Supplier<StorageProperties> K;
    protected final String M;
    protected final String J;
    public static final String b = "index";
    protected final AtomicBoolean E;
    protected static final Serializer<JumpSkipIndexEntries> I;
    protected final MeterFactory.RateMeter k;

    private static /* synthetic */ boolean A(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validIndex(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        boolean a3 = false;
        try {
            StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.K.get();
            a3 = storageProperties.newIndex(readOnlyJumpSkipIndexManager.G, (FileVersion)a2).exists();
            return a3;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = readOnlyJumpSkipIndexManager.J;
            objectArray[1] = a2;
            objectArray[2] = exception;
            L.warn(EventProcessorSynchronizer.A((Object)"\u0018.Ys%2\n?\u00067C'\fs\u00152\u000f:\u00072\u00176C:\r7\u0006+C5\f!C \u00064\u000e6\r'Ys\u0018."), objectArray);
            return a3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(File file, File file2) {
        void a2;
        File a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.J;
        objectArray[1] = a3.getAbsolutePath();
        objectArray[2] = a2.getAbsolutePath();
        L.debug(CommandRegistrationCache.A((Object)"\r&L{$>\u0018:\u001b2\u0018<V/\u001e>V/\u00136\u00064\u0004:\u0004\"V2\u0018?\u0013#V \u000b{\u00024V \u000b"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    protected Index M(FileVersion fileVersion2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            return readOnlyJumpSkipIndexManager.F.computeIfAbsent(a2, fileVersion -> {
                ReadOnlyJumpSkipIndexManager a2 = fileVersion;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return new Index(a3, (FileVersion)a2);
            }).A();
        }
        catch (IndexNotFoundException a3) {
            readOnlyJumpSkipIndexManager.F.remove(a2);
            throw a3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReadOnlyJumpSkipIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        ReadOnlyJumpSkipIndexManager a7;
        Object a8 = string;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a7 = this;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = a7;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager3 = a7;
        a7.F = new ConcurrentSkipListMap();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager4 = a7;
        readOnlyJumpSkipIndexManager3.f = new ConcurrentSkipListMap(Comparator.reverseOrder());
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager5 = a7;
        a7.e = new AtomicLong();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager6 = a7;
        a7.E = new AtomicBoolean(false);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager7 = a7;
        a7.A = new AtomicLong();
        readOnlyJumpSkipIndexManager2.J = a8;
        readOnlyJumpSkipIndexManager2.K = a6;
        readOnlyJumpSkipIndexManager.G = a5;
        readOnlyJumpSkipIndexManager.B = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8;
        stringArray[2] = "type";
        stringArray[3] = a4.name();
        a8 = Tags.of((String[])stringArray);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager8 = a7;
        readOnlyJumpSkipIndexManager8.k = a3.rateMeter((MetricName)BaseMetricName.a, (Tags)a8);
        readOnlyJumpSkipIndexManager8.H = a3.rateMeter((MetricName)BaseMetricName.n, (Tags)a8);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager9 = a7;
        readOnlyJumpSkipIndexManager9.l = a2;
        readOnlyJumpSkipIndexManager9.M = ((StorageProperties)a6.get()).getNewIndexSuffix();
        C.scheduleAtFixedRate(() -> a7.M(), 10L, 10L, TimeUnit.SECONDS);
    }

    public long size() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a2 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.l.get();
        if (a2 != null) {
            return readOnlyJumpSkipIndexManager.A.get() + a2.size();
        }
        return readOnlyJumpSkipIndexManager.A.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(FileVersion fileVersion, Throwable throwable) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4.J;
        objectArray[1] = a3.A();
        objectArray[2] = a3.A();
        objectArray[3] = a2;
        L.warn(EventProcessorSynchronizer.A((Object)"\u0018.Ys&!\u0011<\u0011s\u0014;\n?\u0006s\u00020\u0017:\u00152\u0017:\r4C \u00064\u000e6\r'C(\u001es\u00156\u0011 \n<\rs\u0018."), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean A(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3;
        void a4;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntries;
        ReadOnlyJumpSkipIndexManager a5 = readOnlyJumpSkipIndexManager;
        if (a4 >= a3.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void A(FileVersion fileVersion, Void void_) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.f.put(a2.A(), a2.A());
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Collections.singletonList(((StorageProperties)a3.K.get()).newIndex(a3.G, (FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        Object a222 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.J;
        objectArray[1] = a3.B;
        objectArray[2] = a2;
        L.info(EventProcessorSynchronizer.A((Object)"\u0018.Ys\u0000!\u00062\u00176C(\u001es\n=\u00076\u001bs\u0005<\u0011s\u0018."), objectArray);
        StorageProperties storageProperties = (StorageProperties)a3.K.get();
        Object object = a222 == null ? Collections.emptyMap() : a222;
        a222 = a3.A((FileVersion)a2, (Map)object);
        object = storageProperties.newIndex(a3.G, (FileVersion)a2);
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(((File)a222).toPath(), ((File)object).toPath(), copyOptionArray);
            a3.A.addAndGet(((File)object).length());
            a3.f.put(a2.A(), a2.A());
            return;
        }
        catch (IOException a222) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a3.G, (FileVersion)a2), (Throwable)a222);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void A(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = this;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        if (a3.A((FileVersion)a4)) {
            a3.M((FileVersion)a4, (Map)a2);
            return;
        }
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a3.l.get();
        if (readOnlyJumpSkipIndexManager != null) {
            readOnlyJumpSkipIndexManager.A((FileVersion)a4, (Map)a2);
        }
    }

    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        ReadOnlyJumpSkipIndexManager a2 = searchHint;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> A(FileVersion fileVersion, File file) {
        void a3;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        ReadOnlyJumpSkipIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.A((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).doOnNext(arg_0 -> a5.A((FileVersion)a4, arg_0)).flatMap(arg_0 -> a5.A((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.A((FileVersion)a4, arg_0)).doOnError(arg_0 -> a5.A((FileVersion)a4, arg_0));
    }

    private static /* synthetic */ Mono A(File file, File file2, File file3) {
        File a2 = file2;
        File a3 = file;
        return FileUtils.A((File)a3, (File)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected FileVersion A(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        NavigableSet<Long> a3 = readOnlyJumpSkipIndexManager.f.keySet().tailSet((long)a2, true);
        if (a3.isEmpty()) {
            throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.J + ": Index for token not found: " + (long)a2);
        }
        return new FileVersion(((Long)a3.first()).longValue(), ((Integer)readOnlyJumpSkipIndexManager.f.get(a3.first())).intValue());
    }

    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(CommandRegistrationCache.A((Object)"\u0014\u0006>\u0004:\u00022\u00195V4\u00187\u000f{\u0005.\u0006+\u0019)\u0002>\u0012{\u00104\u0004{\u0006)\u001f6\u0017)\u000f{\u001f5\u0012>\u000e{\u001b:\u0018:\u0011>\u0004"));
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(CommandRegistrationCache.A((Object)"9+\u0013)\u0017/\u001f4\u0018{\u00195\u001a\"V(\u0003+\u00064\u0004/\u0013?V4\u0018{\u0006)\u001f6\u0017)\u000f{\u001f5\u0012>\u000e{\u001b:\u0018:\u0011>\u0004"));
    }

    private /* synthetic */ File A(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.K.get()).newIndex(a3.G, (FileVersion)a2);
    }

    /*
     * Exception decompiling
     */
    protected void A(File var1_2, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ JumpSkipIndexEntries A(FileVersion fileVersion, String string) {
        void a2;
        void a3;
        int n;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        int n2 = n = 3;
        while (n2 > 0) {
            try {
                ReadOnlyJumpSkipIndexManager a4 = readOnlyJumpSkipIndexManager.M((FileVersion)a3);
                return a4.A((String)a2);
            }
            catch (DBException a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.J;
                objectArray[1] = a3;
                objectArray[2] = a4;
                L.debug(CommandRegistrationCache.A((Object)"\r&L{?5\u0012>\u000e{2\u0019V>\u000e8\u0013+\u00022\u00195V \u000b"), objectArray);
                n2 = --n;
            }
            catch (IllegalAccessError a4) {
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.J;
                objectArray[1] = a3;
                objectArray[2] = a4;
                L.debug(EventProcessorSynchronizer.A((Object)"(\u001eiC:\u000f?\u00064\u0002?C2\u00000\u0006 \u0010s\u0018."), objectArray);
                n2 = --n;
            }
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.J + ": Index not found for segment " + (FileVersion)a3 + ", aggregate " + (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        if (a4.f.containsKey(a3.A())) {
            return a4.A((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.l.get();
        if (indexManager != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.J;
            objectArray[1] = a3.A();
            objectArray[2] = a3.A();
            L.debug(CommandRegistrationCache.A((Object)"\r&L{\u00178\u00022\u0000:\u0002>V \u000b{\u00104\u0004{\r&V2\u0018{\u0018>\u000e/V/\u001f>\u0004"), objectArray);
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(FileVersion fileVersion, HTreeMap hTreeMap, String string, List list) {
        void a2;
        int n;
        List a3;
        void a4;
        JumpSkipIndexEntries a5;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = list2;
        List list2 = list;
        ReadOnlyJumpSkipIndexManager a6 = readOnlyJumpSkipIndexManager;
        a5 = a6.A((FileVersion)a5, (String)a4);
        IndexEntry indexEntry = (IndexEntry)a3.get(0);
        Integer[] integerArray = new Integer[a3.size()];
        int n2 = n = 0;
        while (n2 < a3.size()) {
            int n3 = n++;
            integerArray[n3] = ((IndexEntry)a3.get(n3)).A();
            n2 = n;
        }
        a2.put((Object)a4, (Object)new JumpSkipIndexEntries(a5.A(), indexEntry.M(), integerArray));
    }

    public void complete(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        fileVersion = this;
    }

    private static /* synthetic */ File A(File a2) {
        return a2;
    }

    protected void M() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager = this;
        while (readOnlyJumpSkipIndexManager2.F.size() > ((StorageProperties)readOnlyJumpSkipIndexManager.K.get()).getMaxIndexesInMemory()) {
            Map.Entry a2 = readOnlyJumpSkipIndexManager.F.pollFirstEntry();
            L.debug(CommandRegistrationCache.A((Object)" \u000baV\u0018\u001a4\u00052\u0018<V2\u0018?\u0013#V \u000b"), (Object)readOnlyJumpSkipIndexManager.J, a2.getKey());
            readOnlyJumpSkipIndexManager.d = C.schedule(() -> ((Index)a2.getValue()).close(), 2L, TimeUnit.SECONDS);
            readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Index A(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        L.debug(CommandRegistrationCache.A((Object)":4\u00190\u001f5\u0011{\u00104\u0004{\r&Z{\u001f5\u0012>\u000e>\u0005aV \u000b"), (Object)((long)a2), (Object)readOnlyJumpSkipIndexManager.f);
        Object a3 = (Integer)readOnlyJumpSkipIndexManager.f.get((long)a2);
        if (a3 != null) {
            return readOnlyJumpSkipIndexManager.M(new FileVersion((long)a2, ((Integer)a3).intValue()));
        }
        a3 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.l.get();
        if (a3 != null) {
            L.debug(EventProcessorSynchronizer.A((Object)"\u0018.Ys\u0005:\r7C:\r7\u0006+C5\f!C(\u001es\n=C=\u0006+\u0017s\u0017:\u0006!"), (Object)readOnlyJumpSkipIndexManager.J, (Object)((long)a2));
            return a3.A((long)a2);
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.J + ": Index not found: " + (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected File A(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        void a2;
        File a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2;
        block9: {
            ReadOnlyJumpSkipIndexManager a222;
            block7: {
                readOnlyJumpSkipIndexManager2 = this;
                a222 = (StorageProperties)readOnlyJumpSkipIndexManager2.K.get();
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = a222.newIndex(readOnlyJumpSkipIndexManager2.G, (FileVersion)a3);
                objectArray[2] = a2.keySet();
                L.debug(CommandRegistrationCache.A((Object)" \u000baV8\u0004>\u0017/\u0013{\r&Z{\u001d>\u000f(V \u000b"), objectArray);
                a3 = a222.newIndexTemp(readOnlyJumpSkipIndexManager2.G, a3.A());
                try {
                    Files.deleteIfExists(a3.toPath());
                }
                catch (IOException a222) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, EventProcessorSynchronizer.A((Object)"\u0015\u0002:\u000f6\u0007s\u0017<C7\u0006?\u0006'\u0006s\u00176\u000e#\f!\u0002!\u001as\n=\u00076\u001bs\u0005:\u000f6"), (Throwable)a222);
                }
                a222 = DBMaker.fileDB((File)a3).fileMmapEnable().cleanerHackEnable().make();
                HTreeMap hTreeMap = a222.hashMap(b, (Serializer)Serializer.STRING, I).create();
                try {
                    hTreeMap.putAll((Map)a2);
                    a222.commit();
                    if (hTreeMap == null) break block7;
                    readOnlyJumpSkipIndexManager = a222;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block9;
            }
            readOnlyJumpSkipIndexManager = a222;
        }
        readOnlyJumpSkipIndexManager.close();
        File file = a3;
        readOnlyJumpSkipIndexManager2.A(file, a2.size());
        return file;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            void a2;
            void a3;
            ReadOnlyJumpSkipIndexManager a4;
            long a5;
            long l4 = a5 = a5;
            while (l4 >= (Long)readOnlyJumpSkipIndexManager.f.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a4 = readOnlyJumpSkipIndexManager2.A(a5);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.M((FileVersion)a4).A((String)a3);
                if (jumpSkipIndexEntries == null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = readOnlyJumpSkipIndexManager.J;
                    objectArray[1] = a3;
                    objectArray[2] = a4;
                    L.debug(EventProcessorSynchronizer.A((Object)"\u0018.Ys\u0006=\u0017!\n6\u0010s\u0005<\u0011s\u0018.C=\f'C5\f&\r7C:\rs\u00106\u0004>\u0006=\u0017s\u0018."), objectArray);
                    return null;
                }
                if (jumpSkipIndexEntries.firstSequenceNumber() < a2) {
                    JumpSkipIndexEntries jumpSkipIndexEntries2 = jumpSkipIndexEntries;
                    return new SegmentIndexEntries((FileVersion)a4, jumpSkipIndexEntries2.range(jumpSkipIndexEntries2.firstSequenceNumber(), (long)a2, EventType.E.equals((Object)readOnlyJumpSkipIndexManager.B)));
                }
                l4 = jumpSkipIndexEntries.A();
            }
            a4 = (IndexManager)readOnlyJumpSkipIndexManager.l.get();
            if (a4 == null) return null;
            return a4.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, a5);
        }
        catch (IndexNotFoundException a5) {
            L.debug(CommandRegistrationCache.A((Object)"\r&L{\u001f5\u0012>\u000e{\u00184\u0002{\u00104\u00035\u0012"), (Object)readOnlyJumpSkipIndexManager.J, (Object)a5);
        }
        return null;
    }

    private /* synthetic */ void A(FileVersion fileVersion, File file) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        L.debug(EventProcessorSynchronizer.A((Object)"(\u001eiC\u0012\u0000'\n%\u0002'\n=\u0004s\n=\u00076\u001bs\u0005<\u0011s\u0005:\u000f6\u00156\u0011 \n<\rs\u0018."), (Object)a3.J, (Object)a2);
    }

    protected void A() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        readOnlyJumpSkipIndexManager.e.set(readOnlyJumpSkipIndexManager.f.keySet().stream().skip(((StorageProperties)a2.K.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    private /* synthetic */ boolean A(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.K.get()).dataFile(a3.G, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StorageProperties storageProperties;
        block10: {
            StorageProperties storageProperties2;
            block8: {
                Map<String, List> a2;
                void a32;
                int a222 = n;
                ReadOnlyJumpSkipIndexManager a4 = this;
                storageProperties2 = (StorageProperties)a4.K.get();
                Object a222 = new FileVersion((long)a32, a222);
                if (a2 == null) {
                    a2 = Collections.emptyMap();
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a222;
                objectArray[1] = storageProperties2.newIndex(a4.G, (long)a32);
                objectArray[2] = a2.keySet();
                L.debug(CommandRegistrationCache.A((Object)" \u000baV8\u0004>\u0017/\u0013{\r&Z{\u001d>\u000f(V \u000b"), objectArray);
                a222 = storageProperties2.newTransformedIndex(a4.G, (FileVersion)a222);
                try {
                    Files.deleteIfExists(((File)a222).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, EventProcessorSynchronizer.A((Object)"\u0015\u0002:\u000f6\u0007s\u0017<C7\u0006?\u0006'\u0006s\u0017!\u0002=\u00105\f!\u000e6\u0007s\n=\u00076\u001bs\u0005:\u000f6"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.fileDB((File)a222).fileMmapEnable().cleanerHackEnable().make();
                a222 = storageProperties2.hashMap(b, (Serializer)Serializer.STRING, I).createOrOpen();
                try {
                    Integer n2 = (Integer)a4.f.get((long)a32);
                    FileVersion a32 = new FileVersion((long)a32, n2.intValue());
                    a2.forEach((arg_0, arg_1) -> a4.A(a32, (HTreeMap)a222, arg_0, arg_1));
                    if (a222 == null) break block8;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a222 != null) {
                            try {
                                a222.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable a32) {
                                throwable.addSuppressed(a32);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a222.close();
                break block10;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Mono.defer(() -> a3.A((FileVersion)a2));
    }

    public void init() {
        File[] fileArray = this;
        if (!fileArray.E.get()) {
            int n2;
            File[] a2 = new File(fileArray.G).listFiles(file -> {
                File a2 = file;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return a2.getName().endsWith(a3.M);
            });
            if (a2 == null) {
                return;
            }
            int n3 = a2.length;
            int n4 = n2 = 0;
            while (n4 < n3) {
                File file2 = a2[n2];
                FileVersion fileVersion = FileUtils.A((String)file2.getName());
                fileArray.f.compute(fileVersion.A(), (l2, n) -> {
                    Integer a2 = n;
                    FileVersion a3 = fileVersion;
                    return a2 == null ? a3.A() : Math.max(a3.A(), a2);
                });
                fileArray.A.addAndGet(file2.length());
                n4 = ++n2;
            }
            fileArray.A();
            fileArray.E.set(true);
        }
    }

    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> readOnlyJumpSkipIndexManager) {
        Object a2 = readOnlyJumpSkipIndexManager;
        readOnlyJumpSkipIndexManager = this;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ File A(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return a2.newIndex(a4.G, new FileVersion(((Long)a3.getKey()).longValue(), ((Integer)a3.getValue()).intValue()));
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return a3.M((FileVersion)a2).A();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        long a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        try {
            void a4;
            void a5;
            void a6;
            ReadOnlyJumpSkipIndexManager a7;
            void a8;
            while (a3 >= a8 && a3 >= (Long)readOnlyJumpSkipIndexManager.f.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a7 = readOnlyJumpSkipIndexManager2.A(a3);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.A((FileVersion)a7, (String)a2);
                if (jumpSkipIndexEntries != null) {
                    IndexEntries indexEntries = jumpSkipIndexEntries.range((long)a6, (long)a5, EventType.E.equals((Object)readOnlyJumpSkipIndexManager.B));
                    if (!indexEntries.isEmpty()) {
                        treeMap.put((FileVersion)a7, indexEntries);
                        if (readOnlyJumpSkipIndexManager.A((long)a6, (long)(a4 -= (long)indexEntries.size()), (IndexEntries)jumpSkipIndexEntries)) {
                            return treeMap;
                        }
                    }
                    if (jumpSkipIndexEntries.A() >= a7.A()) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.J;
                        objectArray[1] = readOnlyJumpSkipIndexManager.B;
                        objectArray[2] = a2;
                        objectArray[3] = a7;
                        throw new MessagingPlatformException(ErrorCode.INDEX_READ_ERROR, String.format(EventProcessorSynchronizer.A((Object)"v\u0010iC\u001a\r%\u0002?\n7C:\r7\u0006+C6\r'\u0011*C5\f!Cv\u0010sF C:\rs\u00106\u0004>\u0006=\u0017sF Os\u000f:\r8\u0010s\u0017<C=\u0006$\u0006!C'\f8\u0006="), objectArray));
                    }
                    a3 = jumpSkipIndexEntries.A();
                    continue;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.J;
                objectArray[1] = a2;
                objectArray[2] = a7;
                L.warn(CommandRegistrationCache.A((Object)"\r&L{\u001f5\u0000:\u001a2\u0012{\u0006)\u0013-\u001f4\u0003(V/\u00190\u00135V,\u001e2\u001a>V)\u0013:\u00122\u0018<V>\u0000>\u0018/\u0005{\u00104\u0004{\r&Z{\u0017<\u0011)\u0013<\u0017/\u0013{\u00184\u0002{\u00104\u00035\u0012{\u001f5V(\u0013<\u001b>\u0018/V \u000bwV8\u00195\u00022\u0018.\u0013{\u001f5V+\u0004>\u00002\u0019.\u0005{\u0005>\u00116\u00135\u0002"), objectArray);
                a3 = a7.A() - 1L;
            }
            a7 = (IndexManager)readOnlyJumpSkipIndexManager.l.get();
            if (a7 == null) return treeMap;
            treeMap.putAll(((IndexManager)readOnlyJumpSkipIndexManager.l.get()).lookupAggregateInClosedSegments((String)a2, (long)a6, (long)a5, (long)a4, (long)a8, a3));
            return treeMap;
        }
        catch (IndexNotFoundException a7) {
            Object[] objectArray = new Object[4];
            objectArray[0] = readOnlyJumpSkipIndexManager.J;
            objectArray[1] = a2;
            objectArray[2] = a3;
            objectArray[3] = readOnlyJumpSkipIndexManager.f;
            L.warn(EventProcessorSynchronizer.A((Object)"\u0018.Ys\u0006!\u0011<\u0011s\u00116\u00027\n=\u0004s\u0006%\u0006=\u0017 C5\f!C(\u001e\u007fC#\u00116\u0015:\f&\u0010s\u0017<\b6\rs\u0018.Os\n=\u00076\u001b6\u0010s\u0018."), objectArray);
        }
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        readOnlyJumpSkipIndexManager.F.forEach((fileVersion, index) -> {
            FileVersion a2 = index;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        readOnlyJumpSkipIndexManager.F.clear();
        if (a2 != false) {
            readOnlyJumpSkipIndexManager.f.keySet().forEach(arg_0 -> readOnlyJumpSkipIndexManager.removeAllVersions(arg_0));
        }
        if (readOnlyJumpSkipIndexManager.d != null && !readOnlyJumpSkipIndexManager.d.isDone()) {
            readOnlyJumpSkipIndexManager.d.cancel(true);
        }
        try {
            ReadOnlyJumpSkipIndexManager a3 = (IndexManager)readOnlyJumpSkipIndexManager.l.get();
            if (a3 != null) {
                a3.cleanup((boolean)a2);
                return;
            }
        }
        catch (Exception a3) {
            L.info(CommandRegistrationCache.A((Object)"\r&L{57\u0013:\u0018.\u0006{\u0019=V2\u0018?\u0013#V=\u00172\u001a>\u0012"), (Object)readOnlyJumpSkipIndexManager.J, (Object)a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a4 = (StorageProperties)readOnlyJumpSkipIndexManager.K.get();
        return readOnlyJumpSkipIndexManager.f.entrySet().stream().filter(arg_0 -> ReadOnlyJumpSkipIndexManager.A((long)a3, (int)a2, arg_0)).map(arg_0 -> readOnlyJumpSkipIndexManager.A((StorageProperties)a4, arg_0));
    }

    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntry;
        ReadOnlyJumpSkipIndexManager a2 = readOnlyJumpSkipIndexManager;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono A(File file, File file2) {
        void a2;
        Object a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return Mono.fromSupplier(() -> ReadOnlyJumpSkipIndexManager.A((File)a2)).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).doOnNext(arg_0 -> a4.A((File)a3, arg_0)).flatMap(arg_0 -> ReadOnlyJumpSkipIndexManager.A((File)a2, (File)a3, arg_0));
    }

    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        Object a2 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(EventProcessorSynchronizer.A((Object)"\n\f&C0\u0002=C<\r?\u001as\u0000!\u00062\u00176C2\rs\n=\u00076\u001bs\u0005!\f>C'\u000b6C\u0003\u0011:\u000e2\u0011*)&\u000e#08\n#*=\u00076\u001b\u001e\u0002=\u00024\u0006!"));
    }

    MeterFactory.RateMeter A() {
        ReadOnlyJumpSkipIndexManager a2;
        return a2.k;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.K.get();
        Integer n = (Integer)readOnlyJumpSkipIndexManager.f.remove((long)a2);
        if (n != null) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < n) {
                FileVersion fileVersion = new FileVersion((long)a2, a3);
                if (storageProperties.newIndex(readOnlyJumpSkipIndexManager.G, fileVersion).exists()) {
                    readOnlyJumpSkipIndexManager.remove(fileVersion);
                }
                n2 = ++a3;
            }
            return readOnlyJumpSkipIndexManager.remove(new FileVersion((long)a2, n.intValue()));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono A(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        Object a3 = ((StorageProperties)readOnlyJumpSkipIndexManager.K.get()).newTransformedIndex(readOnlyJumpSkipIndexManager.G, (FileVersion)a2);
        return readOnlyJumpSkipIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    public boolean remove(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a22 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Index index = (Index)a3.F.remove(a22);
        if (index != null) {
            L.debug(CommandRegistrationCache.A((Object)"\u0018\u001a4\u0005>V2\u0018?\u0013#V \u000b"), (Object)a22);
            index.close();
        }
        a3.f.remove(a22.A(), a22.A());
        if (L.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.hashCode();
            objectArray[1] = a22;
            objectArray[2] = a3.f.keySet();
            L.debug(EventProcessorSynchronizer.A((Object)"(\u001eiC\u0017\u0006?\u0006'\u00067C \u00064\u000e6\r'C(\u001e\u007fC!\u0006>\u0002:\r:\r4C \u00064\u000e6\r'\u0010s\u0018."), objectArray);
        }
        File file = ((StorageProperties)a3.K.get()).newIndex(a3.G, (FileVersion)a22);
        long l2 = file.length();
        boolean a22 = FileUtils.A((File)file);
        if (a22) {
            a3.A.addAndGet(-l2);
        }
        return a22;
    }

    static {
        I = new D();
        C = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(CommandRegistrationCache.A((Object)"\u001c([2\u0018?\u0013#[6\u00175\u0017<\u0013)[")));
    }

    public void addExistingIndex(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.f.put(a2.A(), a2.A());
        a3.A();
    }
}

