/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.D;
import io.axoniq.axonserver.rest.json.QueryResponseJson;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger k = AuditLog.getLogger();

    public static String username(Principal a2) {
        if (a2 == null) {
            return QueryResponseJson.A((Object)"ml?b?t<b$~o");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + D.k.A()[2].getName()));
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return SerializedEventWithToken.A((Object)"$? 3-4%");
        }
        return QueryResponseJson.A((Object)"I\u0018^\u0010O\u001dH\u0015");
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
        }
    }

    public AuditLog() {
        AuditLog a2;
    }

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            k.info(SerializedEventWithToken.A((Object)"-\u001e\u0006\u0018\u000fQ\u0016\u0018\u0015\u0019A\u0004\u0012\u0014\u0013\u001f\u0000\u001c\u0004QC\n\u001cSO"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            k.error(QueryResponseJson.A((Object)"\u001db6d?-&d%eqx\"h#c0`4-sv,/qK\u0010D\u001dH\u00157qv,"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (k.isDebugEnabled()) {
            k.debug(a2.toString());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return SerializedEventWithToken.A((Object)"]\u0010\u000f\u001e\u000f\b\f\u001e\u0014\u0002_");
        }
        return StringUtils.sanitize((String)a2);
    }
}

