/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.access.user.ReplicationGroupUserController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.rest.json.QueryResponseJson;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final NonReplacingConstraintCache<String, ActiveQuery> H;
    private final Map<String, AtomicInteger> K;
    private final QueryInterceptors M;
    private final QueryRegistrationCache J;
    private final DispatchQueueMetrics b;
    private final QueryMetricsRegistry E;
    private final Logger I;
    private final FlowControlQueues<QueryInstruction> k;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.J.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.E.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.A((String)v0, a5.M(), () -> QueryDispatcher.A((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.H.remove(a2)) != null) {
            a2.M();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.A((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.A((String)a3)) {
                queryDispatcher.H.remove((Object)a4.A());
            }
            long l2 = System.currentTimeMillis() - a4.A();
            if (a4.A()) {
                void a5;
                queryDispatcher.E.addHandlerResponseTime(a4.A(), a4.M(), (String)a5, a4.G(), l2);
                return;
            }
        } else {
            queryDispatcher.I.debug(QueryResponseJson.A((Object)"\u001fbq%<b#hx-8c7b#`0y8b?-7b#-*pqb?-2b<}=h%h5"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.I.debug(ReplicationGroupUserController.A((Object)"hbF}Gh_dEj\u000bzByC-N\u007fYbY-_eN-HbF`^cBnJyBbE-\\d_e\u000bl\u000b~[hHdMdH-ClEiGhY-pnGdNc_^_\u007fNlFDO0Ppv!\u000bkD\u007f\u000byCh\u000b|^hYt\u000bVBi\u0016vVP\u0005-n\u007fYbY-HbOh\u0011-Pp\u0005-n\u007fYbY@N~XlLh\u0011-Pp\u0005"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.H.get(a5);
        if (activeQuery != null && activeQuery.A((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.H.remove(a5);
        }
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.k;
    }

    private /* synthetic */ boolean A(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.A((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.M((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.A(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.A(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).M();
        queryDispatcher2.K.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.E.gauge((MetricName)BaseMetricName.E, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.A((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.A((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.G(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.A();
            if (a4.A()) {
                void a5;
                queryDispatcher.E.addEndToEndResponseTime(a4.A(), a4.M(), (String)a5, clientStreamIdentification.M(), a4.M(), l2);
            }
            if (a4.A((QueryResponse)a3, (String)a2) && a4.M()) {
                a4.A((String)a2);
                return;
            }
        } else {
            queryDispatcher.I.debug(ReplicationGroupUserController.A((Object)"CD-\u0003`D\u007fN$\u000bdEkD\u007fFl_dDc\u000bkD\u007f\u000bvV"), (Object)a3.getRequestIdentifier());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery A(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.H.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.H.get(a2);
        }
        return activeQuery;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.M((QueryHandler)a3, a4.A(), a4.e(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.A((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.A((String)a5, (String)a6, (String)a4, arg_0 -> a7.A((String)a3, (String)a6, (long)a2, arg_0));
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.K.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.E.remove((MetricName)BaseMetricName.E, (String)a2);
        queryDispatcher.E.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.I.trace(ReplicationGroupUserController.A((Object)"odX}JyHeBcL-ZxN\u007fR-Pp\u0005#\u0005"), (Object)a2.A());
            a2.A();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.I.debug(QueryResponseJson.A((Object)"H#\u007f>\u007fqi$\u007f8c6-5d\"}0y2e8c6->kq|$h#tqv,#qN0c2h=a8c6-&d%eqh#\u007f>\u007f\u007f"), (Object)a2.A(), (Object)a3);
            a2.A(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.H.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.A((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.K.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.I = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.K = new ConcurrentHashMap();
        queryDispatcher4.J = registrationCache;
        queryDispatcher4.E = queryDispatcher2;
        queryDispatcher3.H = queryCache;
        queryDispatcher3.M = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.b = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.ua, (MetricName)BaseMetricName.q, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.k = new FlowControlQueues(Comparator.comparing(QueryInstruction::A).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.b, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.fa, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.I.debug(ReplicationGroupUserController.A((Object)"HY\u007fD\u007f\u000biB~[l_nCdEj\u000bkGb\\-ZxN\u007fR-BcXyYxHyBbE-_b\u000byJ\u007fLh_-HaBhEy\u000bvV"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String A(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.J.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)String.format(QueryResponseJson.A((Object)"N=d4c%-t~qc>yqk>x?iqz9d=hq}#b2h\"~8c67q(\""), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.A(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.A(queryRequest));
        try {
            if (queryDispatcher.H.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)ReplicationGroupUserController.A((Object)"\\^hYt\u000bzByC-Xx[}GdNi\u000bDo-JaYhJiR-[\u007fN~Nc_"))).build());
                a3.accept(QueryResponseJson.A((Object)"\u0015x!a8n0y4D5"));
                return;
            }
            queryDispatcher.A((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.A(string.M(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.A(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.M.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.A((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(QueryResponseJson.A((Object)"C>N=d4c%"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.I.warn(ReplicationGroupUserController.A((Object)"Pp\u0011-MlBaNi\u000byD-OdX}JyHe\u000b|^hYt\u000bvV"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(QueryResponseJson.A((Object)"K0d=h5"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.A((QueryRequest)a2));
            if (queryDispatcher.H.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)ReplicationGroupUserController.A((Object)"\\^hYt\u000bzByC-Xx[}GdNi\u000bDo-JaYhJiR-[\u007fN~Nc_"))).build());
            a3.accept(QueryResponseJson.A((Object)"\u0015x!a8n0y4D5"));
            return;
        }
        queryDispatcher.A(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void A(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.A((String)a3, (String)a4, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.H.get(a2)) != null) {
            void a4;
            a2.A().forEach(arg_0 -> a3.A((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> A(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.A((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.J.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.J.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.A((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.E.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    private /* synthetic */ boolean A(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.M.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.I.warn(ReplicationGroupUserController.A((Object)"Pp\u0011-nuHh[yBbE-Bc\u000b\u007fN~[bE~N-Bc_hYnN}_bY"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.A((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }
}

