/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.rest.json.QueryResponseJson;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private static final Logger M = AuditLog.getLogger();
    private final boolean J;
    private final PluginController b;
    public static final String E = "Plugins disabled";
    private final Logger I;
    private final FeatureChecker k;

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.I = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.J = a3.isPluginsEnabled();
        pluginsRestController.b = a2;
        pluginsRestController.k = a5;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void A(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.J || !context.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        M.info(ContextClusterMetrics.A((Object)"?C\u0019eDj\u0001I\u0011]\u0017LDL\u000b\u0018\u0011V\u0016]\u0003Q\u0017L\u0001JDH\bM\u0003Q\n\u0018\u001fEKC\u0019\u0018\u0002W\u0016\u0018\u0007W\nL\u0001@\u0010\u0018\u001fEJ"), objectArray);
        context.b.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    private /* synthetic */ String A(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ContextClusterMetrics.A((Object)"v\u000b\u0018\u0014T\u0011_\rVDH\u0005[\u000fY\u0003]DH\u0016W\u0012Q\u0000]\u0000"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, QueryResponseJson.A((Object)"\u0017d=h?l<hq~9b$a5-?b%-2b?y0d?-5d#h2y>\u007f(-\"h!l#l%b#"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    @GetMapping
    public Iterable<PluginInfo> A(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        M.info(QueryResponseJson.A((Object)"V*p\f-\u0003h x4~%-%bqa8~%-2x#\u007f4c%-!a$j8c\"#q"), (Object)AuditLog.username((Principal)object));
        return a2.b.listPlugins();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> A(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.J || !pluginsRestController.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        M.info(QueryResponseJson.A((Object)"\nv,Pq_4|$h\"yqk>\u007fqn>c7d6x#l%d>cqb7-*p~v,#q"), objectArray);
        try {
            void context;
            return pluginsRestController.b.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.I.warn(ContextClusterMetrics.A((Object)"\"Y\rT\u0001\\DL\u000b\u0018\u0016]\u0010J\r]\u0012]DH\u0016W\u0014]\u0016L\r]\u0017\u0018\u0002W\u0016\u0018\u001fE^C\u0019"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void A(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        M.info(ContextClusterMetrics.A((Object)"c\u001fE9\u00186]\u0015M\u0001K\u0010\u0018\u0010WDM\nQ\nK\u0010Y\bTDH\bM\u0003Q\n\u0018\u001fEKC\u0019\u0016D"), objectArray);
        version.b.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void A(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.J || !active.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? ContextClusterMetrics.A((Object)"\u0017L\u0005J\u0010") : QueryResponseJson.A((Object)"~%b!");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        M.info(QueryResponseJson.A((Object)"\nv,Pq_4|$h\"yqy>-*pq}=x6d?-*p~v,#q"), objectArray);
        active.b.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey A(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.J || !a2.k.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
            }
            M.info(QueryResponseJson.A((Object)"\nv,Pq_4|$h\"yqy>-8c\"y0a=-!a$j8cqv,#q"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.A(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.b.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void A(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.J || !configurationJSON.k.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, E);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        M.info(ContextClusterMetrics.A((Object)"?C\u0019eDj\u0001I\u0011]\u0017LDL\u000b\u0018\u0011H\u0000Y\u0010]D[\u000bV\u0002Q\u0003M\u0016Y\u0010Q\u000bVDW\u0002\u0018\u001fEKC\u0019\u0016D"), objectArray);
        configurationJSON.b.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }
}

