/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.localstorage.query.ExpressionRegistry;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTaskManager
implements SmartLifecycle {
    private static final String a = "true";
    private final MeterFactory l;
    private static final String L = "replicationGroup";
    protected static final Logger F;
    private static final String A = "transient";
    protected final Tasks f;
    protected final ScheduledTaskExecutor G;
    private static final String C = "false";
    protected final AtomicLong e;
    private final long d;
    protected static final long B;
    private boolean H;
    protected final Predicate<String> K;
    protected final ScheduledExecutorService M;
    protected final Supplier<Set<String>> J;
    private final Map<String, Gauge> b;
    protected final Clock E;
    protected final PlatformTransactionManager I;
    protected final Map<String, Map<String, ScheduledFuture<?>>> k;

    protected boolean isTransient(Throwable throwable) {
        Throwable a2 = throwable;
        BaseTaskManager a3 = this;
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof TransientException) {
            return true;
        }
        return a3.isTransient(a2.getCause());
    }

    protected abstract CompletableFuture<Void> processResult(String var1, String var2, TaskStatus var3, long var4, long var6, String var8);

    private /* synthetic */ Number M(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.A((String)a2);
    }

    protected void schedule(Task task) {
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.k.computeIfAbsent(a3.getReplicationGroup(), a2 -> new ConcurrentHashMap()).computeIfAbsent(a3.getTaskId(), arg_0 -> a4.A((Task)a3, arg_0));
    }

    protected void saveAndSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.b.computeIfAbsent(a2.getReplicationGroup(), string -> {
            Object a2 = string;
            BaseTaskManager a3 = this;
            return a3.l.gauge((MetricName)BaseMetricName.La, Tags.of((String)L, (String)a2), () -> a3.M((String)a2));
        });
        new TransactionTemplate(a3.I).execute(arg_0 -> a3.A((Task)a2, arg_0));
        F.debug(ClusterTemplateController.A((Object)"'~f#\bb/h|p?k9g)o9g|x!"), (Object)a2.getReplicationGroup(), (Object)a2.getTaskId());
        a3.doScheduleTask((Task)a2);
    }

    protected void doScheduleTask(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        if (a3.K.test(a2.getReplicationGroup()) && a2.getTimestamp() < a3.e.get() && TaskStatus.SCHEDULED.equals((Object)a2.getStatus())) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTimestamp();
            objectArray[2] = a3.e;
            F.debug(ExpressionRegistry.A((Object)"*\u0017kJ0\u000e5\u0003?\rq\u001e0\u0019:J%\u0005q\u00192\u00024\u000e$\u00064\u0018q\u001e8\u00074J*\u0017q\b4\f>\u00184J*\u0017"), objectArray);
            a3.schedule((Task)a2);
        }
    }

    private /* synthetic */ void M(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.A((Task)a2);
    }

    private /* synthetic */ Number A(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.f.countByContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(Task task, long l2, Void void_) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.completed((Task)a3, (long)a2);
    }

    private static /* synthetic */ Void G(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        F.warn(ClusterTemplateController.A((Object)"x!9|E=j0f8#(l|s.l?f/p|q9p)o(#:l.#(b/h|x!9|x!"), objectArray);
        return null;
    }

    private /* synthetic */ void M() {
        BaseTaskManager a2;
        F.debug(ExpressionRegistry.A((Object)"#?\u0003%J7\u000f%\t9>0\u0019:8$\u0004?\u000f#Fq\u001d8\u00045\u0005&JlJ*\u0017"), (Object)a2.d);
        a2.M.scheduleWithFixedDelay(() -> {
            BaseTaskManager a2;
            if (!a2.H) {
                return;
            }
            try {
                BaseTaskManager baseTaskManager = a2;
                long l2 = baseTaskManager.e.getAndSet(baseTaskManager.E.millis() + a2.d);
                ((Set)baseTaskManager.J.get()).forEach(string -> {
                    void a2;
                    void a3;
                    BaseTaskManager baseTaskManager = this;
                    List a4 = baseTaskManager.f.findScheduled((String)a3, (long)a2, baseTaskManager.e.get());
                    Object[] objectArray = new Object[4];
                    objectArray[0] = a3;
                    objectArray[1] = a4.size();
                    objectArray[2] = (long)a2;
                    objectArray[3] = baseTaskManager.e.get();
                    F.debug(ExpressionRegistry.A((Object)"\u0011,Pq\u00192\u00024\u000e$\u00068\u00046J*\u0017q\u001e0\u0019:\u0019q\b4\u001e&\u000f4\u0004q\u0011,J0\u00045J*\u0017"), objectArray);
                    a4.forEach(arg_0 -> baseTaskManager.schedule(arg_0));
                });
                return;
            }
            catch (Exception exception) {
                F.warn(ClusterTemplateController.A((Object)"F$`9s(j3m|e9w?k5m;#/`4f8v0f8#(b/h//|t5o0#(q%#=d=j2#0b(f."), (Throwable)exception);
                return;
            }
        }, 0L, a2.d, TimeUnit.MILLISECONDS);
    }

    protected String asString(Throwable throwable) {
        Object a2 = throwable;
        BaseTaskManager a3 = this;
        return MessagingPlatformException.create((Throwable)a2).getMessage();
    }

    private /* synthetic */ ScheduledFuture A(Task task, String string) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.M.schedule(() -> a3.M((Task)a2), a3.A((Task)a2), TimeUnit.MILLISECONDS);
    }

    public boolean isRunning() {
        BaseTaskManager a2;
        return a2.H;
    }

    static {
        B = TimeUnit.MINUTES.toMillis(1L);
        F = LoggerFactory.getLogger(BaseTaskManager.class);
    }

    /*
     * WARNING - void declaration
     */
    protected void error(Task task, Throwable throwable) {
        CompletableFuture completableFuture;
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        if (a4.isTransient((Throwable)a2)) {
            BaseTaskManager baseTaskManager;
            BaseTaskManager baseTaskManager2 = a3;
            long l2 = Math.min(baseTaskManager2.getRetryInterval() * 2L, B);
            if (baseTaskManager2.getRetryInterval() < B) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getPayload().getType();
                objectArray[2] = l2;
                F.info(ClusterTemplateController.A((Object)"x!9|E=j0f8#(l|f$f?v(f|w=p7#{x!$r#|Q9w.z5m;#5m|x!#1pr-r"), objectArray);
                baseTaskManager = a4;
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getTaskId();
                objectArray[2] = a3.getTaskExecutor();
                objectArray[3] = a2.getMessage();
                objectArray[4] = l2;
                F.warn(ExpressionRegistry.A((Object)"*\u0017kJ\u0017\u000b8\u00064\u000eq\u001e>J4\u00124\t$\u001e4J%\u000b\"\u0001q\u0011,Pq\u0011,J|J*\u0017\u007fJ\u0003\u000f%\u0018(\u0003?\rq\u0003?J*\u0017q\u0007\"D\u007fD"), objectArray);
                baseTaskManager = a4;
            }
            CompletableFuture completableFuture2 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.SCHEDULED, a4.newSchedule((Task)a3), l2, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = L;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = A;
            stringArray[5] = a;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            a4.l.counter((MetricName)BaseMetricName.A, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture2;
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2;
            F.warn(ClusterTemplateController.A((Object)"'~f#\u001ab5o9g|w3#9{9`)w9#(b/h|x!9|x!"), objectArray);
            BaseTaskManager baseTaskManager = a4;
            CompletableFuture completableFuture3 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.FAILED, a4.E.millis(), 0L, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = L;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = A;
            stringArray[5] = C;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            baseTaskManager.l.counter((MetricName)BaseMetricName.A, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture3;
        }
        completableFuture.exceptionally(arg_0 -> BaseTaskManager.G((Task)a3, arg_0));
    }

    private /* synthetic */ Task A(Task task, TransactionStatus transactionStatus) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.f.save((Task)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void M(Task task, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        BaseTaskManager a4 = this;
        a4.error((Task)a2, (Throwable)a3);
        return null;
    }

    public void stop() {
        BaseTaskManager a2;
        a2.H = false;
        F.info(ClusterTemplateController.A((Object)"P(l,#\bb/h\u0011b2b;f."));
        a2.M.shutdown();
    }

    public void start() {
        BaseTaskManager a2;
        a2.H = true;
        a2.M();
    }

    private /* synthetic */ void A(Task task) {
        BaseTaskManager a2;
        BaseTaskManager a3 = task;
        BaseTaskManager baseTaskManager = a2 = this;
        long l2 = baseTaskManager.E.millis();
        baseTaskManager.k.getOrDefault(a3.getReplicationGroup(), Collections.emptyMap()).remove(a3.getTaskId());
        if (F.isDebugEnabled()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2.E.millis() - a3.getTimestamp();
            F.debug(ExpressionRegistry.A((Object)"*\u0017kJ\u0014\u00124\t$\u001e4J%\u000b\"\u0001q\u0011,Pq\u0011,J!\u00060\u0004?\u000f5J4\u00124\t$\u001e8\u0005?J*\u0017<\u0019q\u000b6\u0005"), objectArray);
        }
        try {
            ((CompletableFuture)a2.G.executeTask((Task)a3).thenAccept(arg_0 -> a2.A((Task)a3, l2, arg_0))).exceptionally(arg_0 -> a2.M((Task)a3, arg_0));
            return;
        }
        catch (Exception exception) {
            a2.error((Task)a3, (Throwable)exception);
            return;
        }
    }

    protected long newSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.E.millis() + Math.min(a2.getRetryInterval(), B);
    }

    /*
     * WARNING - void declaration
     */
    protected void unschedule(String string, String string2) {
        void a2;
        Object a3 = string;
        BaseTaskManager a4 = this;
        if ((a3 = (ScheduledFuture)a4.k.getOrDefault(a3, Collections.emptyMap()).remove(a2)) != null) {
            a3.cancel(false);
        }
    }

    private /* synthetic */ long A(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a2.getTimestamp() - a3.E.millis();
    }

    /*
     * WARNING - void declaration
     */
    protected void completed(Task task, long l2) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.COMPLETED, a4.E.millis(), 0L, null).exceptionally(arg_0 -> BaseTaskManager.A((Task)a3, arg_0));
        String[] stringArray = new String[4];
        stringArray[0] = L;
        stringArray[1] = a3.getReplicationGroup();
        stringArray[2] = "request";
        stringArray[3] = a3.getTaskExecutor();
        a4.l.timer((MetricName)BaseMetricName.Wa, Tags.of((String[])stringArray)).record(a4.E.millis() - a2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public BaseTaskManager(ScheduledTaskExecutor scheduledTaskExecutor, Tasks tasks, Supplier<Set<String>> supplier, Predicate<String> predicate, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduledExecutorService, MeterFactory meterFactory, Clock clock) {
        void meterFactory2;
        void scheduler;
        void platformTransactionManager2;
        void raftLeaderTest;
        void leaderForGroupProvider;
        void taskRepository;
        void taskExecutor;
        BaseTaskManager a2;
        BaseTaskManager baseTaskManager = object;
        Object object = clock;
        BaseTaskManager baseTaskManager2 = a2 = baseTaskManager;
        BaseTaskManager baseTaskManager3 = a2;
        BaseTaskManager baseTaskManager4 = a2;
        BaseTaskManager baseTaskManager5 = a2;
        BaseTaskManager baseTaskManager6 = a2;
        BaseTaskManager baseTaskManager7 = a2;
        a2.k = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager8 = a2;
        baseTaskManager7.b = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager9 = a2;
        baseTaskManager6.e = new AtomicLong();
        baseTaskManager6.d = Duration.ofMinutes(5L).toMillis();
        baseTaskManager5.G = taskExecutor;
        baseTaskManager5.f = taskRepository;
        baseTaskManager4.J = leaderForGroupProvider;
        baseTaskManager4.K = raftLeaderTest;
        baseTaskManager3.I = platformTransactionManager2;
        baseTaskManager3.M = scheduler;
        baseTaskManager2.l = meterFactory2;
        baseTaskManager2.E = object;
    }

    private static /* synthetic */ Void A(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        F.warn(ExpressionRegistry.A((Object)"*\u0017kJ\u0017\u000b8\u00064\u000eq\u001e>J!\u0018>\t4\u0019\"J#\u000f\"\u001f=\u001eq\f>\u0018q\t>\u0007!\u00064\u001e4\u000eq\u001e0\u0019:J*\u0017kJ*\u0017"), objectArray);
        return null;
    }
}

