/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.ApplicationTool;
import io.axoniq.tools.http.json.Application;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class RegisterApplication {
    private static final int MIN_LENGTH = 16;

    private RegisterApplication() {
    }

    public static void run(String[] args) throws Throwable {
        ToolResult result;
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.APPLICATION, CommandOptions.APPLICATION_ROLES, CommandOptions.APPLICATION_DESCRIPTION, CommandOptions.TOKEN, CommandOptions.PROPERTIES, CommandOptions.SET_TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        if (commandLine.hasOption(CommandOptions.SET_TOKEN.getOpt()) && commandLine.getOptionValue(CommandOptions.SET_TOKEN.getOpt()).length() < 16) {
            System.err.printf("Token must be at least %d characters", 16);
            return;
        }
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        Application application = new Application(commandLine.getOptionValue(CommandOptions.APPLICATION.getOpt()), commandLine.getOptionValue(CommandOptions.APPLICATION_DESCRIPTION.getOpt()), commandLine.getOptionValue(CommandOptions.SET_TOKEN.getOpt()), commandLine.getOptionValues(CommandOptions.APPLICATION_ROLES.getOpt()));
        if (commandLine.hasOption(CommandOptions.PROPERTIES.getOpt())) {
            for (String metadataProperty : commandLine.getOptionValues(CommandOptions.PROPERTIES.getOpt())) {
                String[] keyValue = metadataProperty.split("=", 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Property value must be key=value - " + keyValue);
                }
                application.getMetaData().put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        if (!(result = ApplicationTool.registerApplication((Application)application, (String)serverHttpAddress, (boolean)connectInsecure, (String)token)).isSuccess()) {
            throw result.getFailure();
        }
        System.out.println("AccessToken is: " + (String)result.getSuccessValue());
        System.out.println("Please note this token as this will only be provided once!");
    }
}

