/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.destination.remote;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.axoniq.axonserver.connector.event.EventStream;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.migration.destination.EventStoreStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"axoniq.migration.destination"}, havingValue="REMOTE", matchIfMissing=true)
public class RemoteEventStoreStrategy
implements EventStoreStrategy {
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final Cache<String, Long> sequenceCache = Caffeine.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).maximumSize(10000L).build();

    public void storeEvents(List<Event> events) throws Exception {
        this.axonServerConnectionManager.getConnection().eventChannel().appendEvents(events.toArray(new Event[0])).get(30L, TimeUnit.SECONDS);
    }

    public void appendSnapshot(Event snapshot) throws Exception {
        this.axonServerConnectionManager.getConnection().eventChannel().appendSnapshot(snapshot).get(30L, TimeUnit.SECONDS);
    }

    public String getLastEventId() throws Exception {
        Long lastToken = (Long)this.axonServerConnectionManager.getConnection().eventChannel().getLastToken().get();
        if (lastToken == null || lastToken == -1L) {
            return null;
        }
        try (EventStream stream = this.axonServerConnectionManager.getConnection().eventChannel().openStream(lastToken - 1L, 1);){
            String string = ((EventWithToken)stream.next()).getEvent().getMessageIdentifier();
            return string;
        }
    }

    public Long getNextSequenceNumber(String aggregate, Long current) throws Exception {
        Long currentValue = (Long)this.sequenceCache.get((Object)aggregate, agg -> {
            try {
                return (Long)this.axonServerConnectionManager.getConnection().eventChannel().findHighestSequence(agg).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        Long newValue = currentValue == null ? 0L : currentValue + 1L;
        this.sequenceCache.put((Object)aggregate, (Object)newValue);
        return newValue;
    }

    public void rollback() {
        this.sequenceCache.cleanUp();
    }

    public RemoteEventStoreStrategy(AxonServerConnectionManager axonServerConnectionManager) {
        this.axonServerConnectionManager = axonServerConnectionManager;
    }
}

