/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.jpa.AdminContextJpa;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupMemberJpa;
import io.axoniq.axonserver.configuration.admin.jpa.ClusterNodeJpa;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

@Entity
@Table(name="adm_replication_group", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class AdminReplicationGroupJpa
implements AdminReplicationGroup {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminReplicationGroupMemberJpa> members;
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="replicationGroup", fetch=FetchType.EAGER)
    private Set<AdminContextJpa> contexts;
    @Id
    private String replicationGroupId;
    private String name;
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;

    public void removeContext(AdminContext adminContext) {
        AdminReplicationGroupJpa a2 = adminContext;
        AdminReplicationGroupJpa a3 = this;
        a2.setReplicationGroup(null);
        a3.contexts.remove(a2);
    }

    public void setMembers(Set<AdminReplicationGroupMember> set) {
        Set<AdminReplicationGroupMember> a2 = set;
        AdminReplicationGroupJpa a3 = this;
        if (a2 != null) {
            a3.members = a2.stream().map(adminReplicationGroupMember -> {
                AdminReplicationGroupJpa a2 = adminReplicationGroupMember;
                AdminReplicationGroupJpa a3 = this;
                if (a2 instanceof AdminReplicationGroupMemberJpa) {
                    return (AdminReplicationGroupMemberJpa)a2;
                }
                throw new IllegalArgumentException("Expecting AdminReplicationGroupMemberJpa, got: " + a2.getClass());
            }).collect(Collectors.toSet());
            return;
        }
        a3.members = null;
    }

    public Set<AdminReplicationGroupMember> getMembers() {
        AdminReplicationGroupJpa a2;
        return new HashSet<AdminReplicationGroupMember>(a2.members);
    }

    @PrePersist
    public void prePersist() {
        AdminReplicationGroupJpa a2;
        if (a2.replicationGroupId == null) {
            a2.replicationGroupId = UUID.randomUUID().toString();
        }
    }

    AdminReplicationGroupJpa(String string) {
        AdminReplicationGroupJpa a2;
        Object a3 = string;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2 = this;
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a2;
        adminReplicationGroupJpa.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa3 = a2;
        adminReplicationGroupJpa.contexts = new HashSet();
        adminReplicationGroupJpa.name = a3;
    }

    protected AdminReplicationGroupJpa() {
        AdminReplicationGroupJpa a2;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
        a2.members = new HashSet();
        AdminReplicationGroupJpa adminReplicationGroupJpa2 = a2;
        adminReplicationGroupJpa.contexts = new HashSet();
    }

    public Date getPendingSince() {
        AdminReplicationGroupJpa a2;
        return a2.pendingSince;
    }

    public void setName(String string) {
        Object a2 = string;
        AdminReplicationGroupJpa a3 = this;
        a3.name = a2;
    }

    public int hashCode() {
        AdminReplicationGroupJpa a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = a2.name;
        return Objects.hash(objectArray);
    }

    public String getReplicationGroupId() {
        AdminReplicationGroupJpa a2;
        return a2.replicationGroupId;
    }

    public boolean isChangePending() {
        AdminReplicationGroupJpa a2;
        if (a2.changePending != null && a2.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    public void addMember(AdminReplicationGroupMember adminReplicationGroupMember) {
        AdminReplicationGroupJpa a2 = adminReplicationGroupMember;
        AdminReplicationGroupJpa a3 = this;
        a2 = a3.D((AdminReplicationGroupMember)a2);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.members.add(a2);
    }

    public String getName() {
        AdminReplicationGroupJpa a2;
        return a2.name;
    }

    private static /* synthetic */ boolean D(AdminReplicationGroupMember adminReplicationGroupMember, AdminReplicationGroupMemberJpa adminReplicationGroupMemberJpa) {
        AdminReplicationGroupMember a2 = adminReplicationGroupMemberJpa;
        AdminReplicationGroupMember a3 = adminReplicationGroupMember;
        return a2.getClusterNode().getName().equals(a3.getClusterNode().getName());
    }

    public void setChangePending(boolean bl) {
        boolean a2 = bl;
        AdminReplicationGroupJpa a3 = this;
        boolean bl2 = a2;
        a3.changePending = bl2;
        if (bl2) {
            AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
            adminReplicationGroupJpa.pendingSince = new Date();
            return;
        }
        a3.pendingSince = null;
    }

    public boolean equals(Object object) {
        Object a2 = this;
        Object a3 = object;
        if (a2 == a3) {
            return true;
        }
        if (a3 == null || a2.getClass() != a3.getClass()) {
            return false;
        }
        a3 = (AdminReplicationGroupJpa)a3;
        return Objects.equals(a2.name, ((AdminReplicationGroupJpa)a3).name);
    }

    public Set<? extends AdminContext> getContexts() {
        AdminReplicationGroupJpa a2;
        return a2.contexts;
    }

    public void setReplicationGroupId(String string) {
        Object a2 = string;
        AdminReplicationGroupJpa a3 = this;
        a3.replicationGroupId = a2;
    }

    public void clearContexts() {
        AdminReplicationGroupJpa a2;
        a2.contexts.clear();
    }

    public void setPendingSince(Date date) {
        Object a2 = date;
        AdminReplicationGroupJpa a3 = this;
        a3.pendingSince = a2;
    }

    public AdminContext addContext(String string) {
        Object a2 = string;
        AdminReplicationGroupJpa a3 = this;
        a2 = new AdminContextJpa((String)a2);
        AdminReplicationGroupJpa adminReplicationGroupJpa = a3;
        a2.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        Object object = a2;
        adminReplicationGroupJpa.contexts.add(object);
        return object;
    }

    @PreRemove
    public void preRemove() {
        AdminReplicationGroupJpa a2;
        new HashSet(a2.members).forEach(adminReplicationGroupMember -> {
            AdminReplicationGroupJpa a2 = adminReplicationGroupMember;
            AdminReplicationGroupJpa a3 = this;
            ((ClusterNodeJpa)a2.getClusterNode()).removeReplicationGroup((AdminReplicationGroup)a3);
        });
        a2.members.clear();
    }

    public void addContext(AdminContext adminContext) {
        AdminReplicationGroupJpa a2;
        AdminReplicationGroupJpa a3 = adminContext;
        AdminReplicationGroupJpa adminReplicationGroupJpa = a2 = this;
        a3.setReplicationGroup((AdminReplicationGroup)adminReplicationGroupJpa);
        adminReplicationGroupJpa.contexts.add((AdminContextJpa)a3);
    }

    public void setContexts(Set<AdminContext> set) {
        Set<AdminContext> a2 = set;
        AdminReplicationGroupJpa a3 = this;
        a3.contexts = a2.stream().map(adminContext -> {
            AdminReplicationGroupJpa a2 = adminContext;
            AdminReplicationGroupJpa a3 = this;
            if (a2 instanceof AdminContextJpa) {
                return (AdminContextJpa)a2;
            }
            return new AdminContextJpa(a2.getName());
        }).collect(Collectors.toSet());
    }

    public void removeMember(AdminReplicationGroupMember adminReplicationGroupMember) {
        AdminReplicationGroupJpa a2 = adminReplicationGroupMember;
        AdminReplicationGroupJpa a3 = this;
        a3.members.stream().filter(arg_0 -> AdminReplicationGroupJpa.D((AdminReplicationGroupMember)a2, arg_0)).findFirst().ifPresent(adminReplicationGroupMemberJpa -> {
            AdminReplicationGroupJpa a2 = adminReplicationGroupMemberJpa;
            AdminReplicationGroupJpa a3 = this;
            AdminReplicationGroupJpa adminReplicationGroupJpa = a2;
            adminReplicationGroupJpa.setReplicationGroup(null);
            adminReplicationGroupJpa.getClusterNode().getReplicationGroups().remove(a2);
            a2.setClusterNode(null);
            a3.members.remove(a2);
        });
    }
}

