/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.rest.json.SerializedObjectJson;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final ClusterTagsCache L;
    private final ApplicationEventPublisher F;
    private final CurrentNodeProvider b;
    private final Logger l;
    private final Limits g;
    private final AdminNodes m;
    private final MessagingPlatformConfiguration A;
    private volatile boolean f;
    private final AdminConfigurationFactory K;
    private final RemoteConnections e;

    private /* synthetic */ void D() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.m.findById(clusterController2.A.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.m.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.A.getName();
                a2 = String.format(ProcessingInstructionHelper.D((Object)"\u0006\u00017\u0006 \u001a1T+\u001b!\u0011e\u001a$\u0019 T-\u00156T&\u001c$\u001a\"\u0011!Xe\u001a \u0003e\u001a$\u0019 T`\u0007kT\u0016\u0000$\u00061T\u0004\f*\u001a\u0016\u00117\u0002 \u0006e\u0003,\u0000-T7\u0011&\u001b3\u00117\re\u0012,\u0018 Z"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.K.clusterNode(clusterController3.A.getName(), clusterController.A.getFullyQualifiedHostname(), clusterController.A.getFullyQualifiedInternalHostname(), clusterController.A.getPort(), clusterController.A.getInternalPort(), clusterController.A.getHttpPort());
            clusterController3.m.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.A.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.A.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.A.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.A.getInternalPort();
            object = String.format(SerializedObjectJson.D((Object)"k*Z-M1\\\u007fF0L:\u000f,\b6F+M-F>D\u007f@0[+F>E:\u0007/G-\\\u007f\u0000z[e\r;\u0001\u007f@>[\u007fK7I1O:Ls\b\u007fF:_\u007f^>D*M,\bz[e\r;\u0006\u007f{+I-\\\u007fi'G1{:Z)M-\b(A+@\u007fZ:K0^:Z&\b9A3Mq"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.D();
        a2.f = true;
    }

    public int getPhase() {
        return 50;
    }

    private /* synthetic */ void D(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.A.getName())) {
            return;
        }
        a3.e.connect((NodeInfo)a2, true);
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.A.getName()) || a3.e.get(a2) != null && a3.e.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.e.connections();
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.l.info(SerializedObjectJson.D((Object)"\u001bM3M+M\u007fF0L:\u0012\u007fS\""), a3);
        clusterController2.F.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.A.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.m.deleteAllByNameNot((String)a3);
            clusterController3.e.closeAll();
        } else {
            a2.m.findById((String)a3).ifPresent(arg_0 -> a2.D((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.F.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.e.sync();
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.D((NodeInfo)a3);
        clusterController.e.updateNodeInfo((NodeInfo)a3);
        clusterController.F.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.e.get((String)a2));
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.b.isAdmin();
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.D((ClusterNode)clusterController.b.get());
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.e.activeConnections();
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.D(clusterController.m.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.e.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.m.deleteAllByNameNot(clusterController.getName());
        clusterController.e.sync();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.m.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.L.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.e.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    private /* synthetic */ void D(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.m.deleteById((String)a2);
    }

    public void stop() {
        a.f = false;
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.e.disconnect((String)a2);
    }

    private /* synthetic */ void D(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.e.contains((String)a2) || a3.A.getName().equals(a2)) {
            return;
        }
        a3.g.getMaxClusterSize().ifPresent(arg_0 -> a3.D((String)a2, arg_0));
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.D(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.A.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.l.info(ProcessingInstructionHelper.D((Object)" 7\r,\u001a\"T1\u001be\u001e*\u001d+T2\u001d1\u001ce\u00170\u00067\u0011+\u0000e\u001a*\u0010 T+\u0015(\u0011\u007fT>\t"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.A.getInternalHostname()) && a2.getGrpcInternalPort() == a3.A.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, SerializedObjectJson.D((Object)"k>F1G+\b5G6F\u007fK3],\\:Z\u007f_6\\7\b,I2M\u007f@0[+F>E:\b>F;\b6F+M-F>D\u007fX0Z+"));
        }
        ClusterNode clusterNode = a3.m.findById(a2.getNodeName()).orElseGet(() -> a3.D((NodeInfo)a2));
        if (!a3.e.contains(a2.getNodeName())) {
            a3.D((NodeInfo)a2);
        }
        return clusterNode;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.e.nodes();
    }

    private /* synthetic */ ClusterNode D(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.l.info(ProcessingInstructionHelper.D((Object)"5!\u0010e\u001a*\u0010 T>\t"), (Object)a3);
        a3 = clusterController.K.clusterNode((NodeInfo)a3);
        return clusterController.m.save((ClusterNode)a3);
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.f;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.F.publishEvent(a2);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.l = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.A = messagingPlatformConfiguration2;
        clusterController6.m = clusterNodeRepository;
        clusterController5.K = adminConfigurationFactory2;
        clusterController5.L = clusterTagsCache2;
        clusterController4.F = applicationEventPublisher2;
        clusterController4.g = limits2;
        clusterController3.e = remoteConnections2;
        clusterController3.b = clusterController2;
    }
}

