/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.component.version.ClientVersionUpdate;
import io.axoniq.axonserver.config.EnterpriseSwaggerConfiguration;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final ExecutorService M;
    private final MessagingPlatformConfiguration C;
    private Server L;
    private final LogReplicationService F;
    private final Supplier<ScheduledExecutorService> b;
    private static final DataSize l = DataSize.ofMegabytes((long)32L);
    private AdvancedTlsX509KeyManager.Closeable g;
    private final LeaderElectionService m;
    private boolean A;
    private final ApplicationEventPublisher f;
    private final Logger K;
    private final List<AxonServerInternalService> e;

    public int getPhase() {
        return 50;
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.g != null) {
            messagingClusterServer.g.close();
        }
        messagingClusterServer.M.shutdown();
        try {
            if (!messagingClusterServer.L.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.K.debug(EnterpriseSwaggerConfiguration.D((Object)"=9\t5\u001e0\u000e:\u0017/[%\u000f9\u000b&\u00128\u001cv8:\u000e%\u000f3\tv(3\t \u001e$"));
                messagingClusterServer2.L.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.K.debug(ClientVersionUpdate.D((Object)"y~DuBbE`DuT0TeBy^w\u0010cXeDt_g^0_v\u0010y^dUb^q\\0qh_~cuBfUb"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.A = false;
        messagingClusterServer.K.info(EnterpriseSwaggerConfiguration.D((Object)":.\u00148[\u0005\u001e$\r3\tv8:\u000e%\u000f3\tv(3\t \u001e$[%\u000f9\u000b&\u001e2"));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void D(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = ClientVersionUpdate.D((Object)"^\u007f\u0010Cc\\");
            if (messagingClusterServer.C.getSsl() != null && messagingClusterServer.C.getSsl().isEnabled()) {
                Object object = messagingClusterServer.C.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(EnterpriseSwaggerConfiguration.D((Object)"7\u00039\u0015?\nx\u001a.\u00148\b3\t \u001e$U%\b:U5\u001e$\u000f{\u0018>\u001a?\u0015{\u001d?\u00173[8\u0014\"[%\u001e\""));
                }
                Object object2 = messagingClusterServer.C.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(ClientVersionUpdate.D((Object)"Qh_~Ya\u001eqH\u007f^cUbFuB>Cc\\>@bYfQdU=[uI=Vy\\u\u0010~_d\u0010cUd"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.g = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.b.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.C.getInternalPort(), (ServerCredentials)object);
                string = EnterpriseSwaggerConfiguration.D((Object)"\u0005(\u001a[3\u00157\u0019:\u001e2");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.C.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.C.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(l.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.C.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.C));
            messagingClusterServer.e.forEach(arg_0 -> MessagingClusterServer.D((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.m);
            a2.addService((BindableService)messagingClusterServer2.F);
            if (messagingClusterServer2.C.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.C.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.C.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.C.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.M);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ClientVersionUpdate.D((Object)"s\\eCdUb\u001dr_cC="))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(EnterpriseSwaggerConfiguration.D((Object)"5\u0017#\b\"\u001e$V!\u0014$\u00103\t{"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ClientVersionUpdate.D((Object)"s\\eCdUb\u001dr_cC="))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(EnterpriseSwaggerConfiguration.D((Object)"5\u0017#\b\"\u001e$V!\u0014$\u00103\t{"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.L = a2.build();
            messagingClusterServer.L.start();
            messagingClusterServer.K.info(ClientVersionUpdate.D((Object)"QH\u007f^0cuBfUb\u0010S\\eCdUb\u0010CUbFuB0CdQbDuT0_~\u0010`_bD*\u0010kM0\u001d0Km"), (Object)messagingClusterServer.C.getInternalPort(), (Object)string);
            messagingClusterServer.f.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.A = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(EnterpriseSwaggerConfiguration.D((Object)"\u0005\u000f7\t\"\u00128\u001cv:.\u00148[\u0005\u001e$\r3\tv8:\u000e%\u000f3\tv(3\t \u001e$[0\u001a?\u00173\u001fv"), (Throwable)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.K = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.C = a8;
        messagingClusterServer3.F = a6;
        messagingClusterServer3.m = a5;
        messagingClusterServer2.e = a4;
        messagingClusterServer2.b = a3;
        messagingClusterServer.f = a2;
        messagingClusterServer.M = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(ClientVersionUpdate.D((Object)"s\\eCdUb\u001duHuSeD\u007fB=")));
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.A;
    }
}

