/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalNode;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteNodesProvider;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.internal.ConnectorCommand;
import io.axoniq.axonserver.grpc.internal.ConnectorResponse;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.rest.SubscriptionQueryMetricRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class RemoteConnections
implements SmartLifecycle {
    private final Map<ConnectorResponse.ResponseCase, Set<BiConsumer<RemoteConnection, ConnectorResponse>>> B;
    private final ApplicationEventPublisher a;
    private static final BiConsumer<RemoteConnection, ConnectorResponse> G = (remoteConnection, connectorResponse) -> {
        RemoteConnection a2 = connectorResponse;
        connectorResponse = remoteConnection;
    };
    private boolean E;
    private final StubFactory H;
    private final long c;
    private final ScheduledExecutorService M;
    private static final Logger C = LoggerFactory.getLogger(RemoteConnections.class);
    private final AtomicBoolean L;
    private final Set<String> F;
    private final XStreamEventSerializer b;
    private final CurrentNodeProvider l;
    private final ChannelExceptionHandler g;
    private final AtomicInteger m;
    private final RemoteNodesProvider A;
    private final ClusterConfiguration f;
    private final Map<String, RemoteConnection> K;
    private static final int e = 10;

    private static /* synthetic */ void D(ConnectorCommand connectorCommand, RemoteConnection remoteConnection) {
        ConnectorCommand a2 = remoteConnection;
        ConnectorCommand a3 = connectorCommand;
        a2.publish(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(String string, RemoteConnection remoteConnection) {
        void a2;
        Object a3 = string;
        RemoteConnections a4 = this;
        a2.disconnect();
        if (!a4.F.contains(a3)) {
            a4.K.remove(a3);
        }
    }

    public void closeAll() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.F.clear();
        remoteConnections.K.forEach((string, remoteConnection) -> {
            String a2 = remoteConnection;
            String a3 = string;
            a2.close();
        });
        a2.K.clear();
    }

    public void setReadyForConnections(boolean bl) {
        RemoteConnections a2;
        boolean a3 = bl;
        RemoteConnections remoteConnections = a2 = this;
        remoteConnections.L.set(a3);
        remoteConnections.K.forEach((string, remoteConnection) -> {
            RemoteConnection a2 = remoteConnection;
            boolean a3 = a3;
            a2.setReadyForConnections(a3);
        });
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        RemoteConnections a2 = replicationGroupDeleted;
        RemoteConnections a3 = this;
        C.debug(NodeConfiguration.D((Object)"rKPBIMAZIAN\u000eG\\O[P\u000eDKLKTKD\u0014\u0000U]"), (Object)a2.replicationGroup());
        a3.M.schedule(() -> a3.sync(), 100L, TimeUnit.MILLISECONDS);
    }

    public RemoteConnection get(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return (RemoteConnection)a3.K.get(a2);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        RemoteConnections a2 = replicationGroupUpdated;
        RemoteConnections a3 = this;
        a3.sync();
    }

    public Collection<RemoteConnection> connections() {
        RemoteConnections a2;
        return a2.K.values();
    }

    public void publish(ConnectorCommand connectorCommand) {
        RemoteConnections a2 = connectorCommand;
        RemoteConnections a3 = this;
        a3.K.values().forEach(arg_0 -> RemoteConnections.D((ConnectorCommand)a2, arg_0));
    }

    public void updateNodeInfo(NodeInfo nodeInfo) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.K.get(a2.getNodeName())).ifPresent(arg_0 -> RemoteConnections.D((NodeInfo)a2, arg_0));
    }

    public boolean isRunning() {
        RemoteConnections a2;
        return a2.E;
    }

    public void start() {
        RemoteConnections a2;
        a2.M.scheduleWithFixedDelay(() -> a2.checkConnections(), a2.f.getConnectionCheckDelay(), a2.f.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a2.E = true;
    }

    public void stop() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.M.shutdown();
        remoteConnections.closeAll();
        remoteConnections.E = false;
    }

    private static /* synthetic */ void D(NodeInfo nodeInfo, RemoteConnection remoteConnection) {
        NodeInfo a2 = remoteConnection;
        NodeInfo a3 = nodeInfo;
        ((RemoteConnectionImpl)a2).D(a3);
    }

    public void disconnect(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.K.get(a2)).ifPresent(arg_0 -> a3.A((String)a2, arg_0));
    }

    public int size() {
        RemoteConnections a2;
        return a2.K.size();
    }

    public void close(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.K.remove(a2)).ifPresent(RemoteConnection::close);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(NodeInfo nodeInfo, boolean bl) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        if (!a3.K.containsKey(a2.getNodeName())) {
            void a4;
            RemoteConnections remoteConnections = a3;
            RemoteConnections remoteConnections2 = a3;
            RemoteConnectionImpl remoteConnectionImpl = new RemoteConnectionImpl(remoteConnections2, new InternalNode(a2.getNodeName(), a2.getInternalHostName(), a2.getGrpcInternalPort()), remoteConnections2.L.get());
            a3.K.put(a2.getNodeName(), remoteConnectionImpl);
            if (a4 != false) {
                remoteConnectionImpl.D();
            }
        }
    }

    public Stream<RemoteConnection> activeConnections() {
        RemoteConnections a2;
        return a2.K.values().stream().filter(RemoteConnection::isConnected);
    }

    public void sync() {
        RemoteConnections remoteConnections = this;
        Set set = (Set)remoteConnections.A.get();
        TreeSet a2 = new TreeSet(remoteConnections.F);
        RemoteConnections remoteConnections2 = remoteConnections;
        remoteConnections2.F.clear();
        set.forEach(internalNode -> {
            RemoteConnectionImpl a2;
            RemoteConnections a3;
            RemoteConnections a4 = internalNode;
            RemoteConnections remoteConnections = a3 = this;
            a2.remove(a4.name());
            remoteConnections.F.add(a4.name());
            if (!remoteConnections.K.containsKey(a4.name())) {
                RemoteConnections remoteConnections2 = a3;
                a2 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a4, remoteConnections2.L.get());
                a3.K.put(a4.name(), a2);
                C.debug(NodeConfiguration.D((Object)"sWNM\u0000\u0003\u0000GNGT\u000eCAN@EMTGO@\u0000\u0013\u0000U]"), (Object)a4);
                a2.D();
            }
        });
        C.debug(SubscriptionQueryMetricRestController.D((Object)"W*j0$~$>e=e4asg<j=a0p:k=ws9s\u007f.(sp<$!a>k%as9s\u007f."), (Object)remoteConnections.F, (Object)a2);
        a2.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.K.get(a2)).ifPresent(arg_0 -> a3.L((String)a2, arg_0));
        });
    }

    public Set<String> nodes() {
        RemoteConnections a2;
        return a2.K.keySet();
    }

    public void checkConnections() {
        RemoteConnections a2;
        a2.F.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.K.get(a2)).ifPresent(RemoteConnection::checkConnection);
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, RemoteConnection remoteConnection) {
        void a2;
        RemoteConnections a3 = remoteConnection;
        RemoteConnections a4 = this;
        a3.close();
        a4.K.remove(a2);
    }

    /*
     * WARNING - void declaration
     */
    public RemoteConnections(ClusterConfiguration clusterConfiguration, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, StubFactory stubFactory, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer xStreamEventSerializer, RemoteNodesProvider remoteNodesProvider, CurrentNodeProvider currentNodeProvider) {
        void a2;
        void remoteNodesProvider2;
        void xStreamEventSerializer2;
        void channelExceptionHandler2;
        void stubFactory2;
        void applicationEventPublisher2;
        RemoteConnections clusterConfiguration2;
        RemoteConnections remoteConnections = remoteConnections2;
        RemoteConnections remoteConnections2 = clusterConfiguration;
        RemoteConnections remoteConnections3 = clusterConfiguration2 = remoteConnections;
        RemoteConnections remoteConnections4 = clusterConfiguration2;
        RemoteConnections remoteConnections5 = clusterConfiguration2;
        RemoteConnections remoteConnections6 = clusterConfiguration2;
        clusterConfiguration2.K = new ConcurrentHashMap();
        RemoteConnections remoteConnections7 = clusterConfiguration2;
        remoteConnections6.m = new AtomicInteger(10);
        RemoteConnections remoteConnections8 = clusterConfiguration2;
        clusterConfiguration2.F = new HashSet();
        RemoteConnections remoteConnections9 = clusterConfiguration2;
        clusterConfiguration2.L = new AtomicBoolean();
        RemoteConnections remoteConnections10 = clusterConfiguration2;
        clusterConfiguration2.M = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(SubscriptionQueryMetricRestController.D((Object)"0h&w'a!)!a0k=j6g'")));
        RemoteConnections remoteConnections11 = clusterConfiguration2;
        clusterConfiguration2.B = new ConcurrentHashMap();
        remoteConnections5.f = remoteConnections2;
        remoteConnections5.a = applicationEventPublisher2;
        remoteConnections4.H = stubFactory2;
        remoteConnections4.c = remoteConnections2.getConnectionWaitTime();
        remoteConnections3.g = channelExceptionHandler2;
        remoteConnections3.b = xStreamEventSerializer2;
        clusterConfiguration2.A = remoteNodesProvider2;
        clusterConfiguration2.l = a2;
        clusterConfiguration2.registerResponseHandler(ConnectorResponse.ResponseCase.CONFIRMATION, G);
    }

    /*
     * WARNING - void declaration
     */
    public void registerResponseHandler(ConnectorResponse.ResponseCase responseCase, BiConsumer<RemoteConnection, ConnectorResponse> biConsumer) {
        void a3;
        Object a4 = biConsumer;
        RemoteConnections a5 = this;
        a5.B.computeIfAbsent(a3, a2 -> new CopyOnWriteArraySet()).add(a4);
    }

    @EventListener
    public void on(ReplicationServerStarted replicationServerStarted) {
        RemoteConnections a2 = replicationServerStarted;
        RemoteConnections a3 = this;
        ((Set)a3.A.get()).forEach(internalNode -> {
            void a2;
            RemoteConnections remoteConnections;
            RemoteConnections remoteConnections2 = remoteConnections = this;
            RemoteConnections a3 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a2, remoteConnections2.L.get());
            remoteConnections.K.put(a2.name(), a3);
            remoteConnections.F.add(a2.name());
            a3.D();
        });
    }

    public boolean contains(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return a3.K.containsKey(a2);
    }
}

