/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.EnterpriseSwaggerConfiguration;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.transport.rest.LoadBalancingManagementRestController;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    public static final String H = "replication-logs";
    private final AtomicBoolean c;
    private final RaftProperties M;
    private final RaftGroupRepositoryManager C;
    private volatile boolean L;
    private final Map<String, RaftGroup> F;
    private final FileSystemMonitor b;
    private final GrpcRaftGroupFactory l;
    private final Map<String, Long> g;
    private final ReplicationGroupController m;
    private final MessagingPlatformConfiguration A;
    private final ApplicationEventPublisher f;
    private final Logger K;
    private final LifecycleController e;

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.F.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.D(a2.localNode(), (StateChanged)a3);
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.L;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.D();
        long l2 = a2.A();
        if (v0.A() && !a3.a()) {
            grpcRaftController.f.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.a() && !a3.A()) {
            grpcRaftController.f.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).D(), l2));
            return;
        }
        if (a3.h()) {
            grpcRaftController.f.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.A())) {
            grpcRaftController.f.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.A(), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.A.getFullyQualifiedInternalHostname()).setPort(a5.A.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.D((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.K.debug(EnterpriseSwaggerConfiguration.D((Object)"\u0005\u000f7\t\"[0\t9\u0016v\u00128\u0012\")7\u001d\"<$\u0014#\u000bv\u0000+"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.F.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().h() || a2.logEntryProcessor().A() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(LoadBalancingManagementRestController.D((Object)"\\xasgd`fa6b~|zp6bw|b|xr6ay5tpuz{p6ystrpd"));
            }
        }
        return a2.localNode();
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.M.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.D((File)a2);
        grpcRaftController2.b.registerPath(H, ((File)a2).toPath(), grpcRaftController.M.minFreeSpace(), grpcRaftController.M.warnFreeSpace());
        a2 = grpcRaftController2.C.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.D(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.L = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.K.info(LoadBalancingManagementRestController.D((Object)"nk/6Gsez|utb|y{6rdzce6fbtda\u007f{q"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.F.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.D((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.K.warn(EnterpriseSwaggerConfiguration.D((Object)"-\u0006l[\u0010\u001a?\u00173\u001fv\u000f9[?\u0015?\u000f?\u001a:\u0012,\u001ev\t3\u000b:\u00125\u001a\"\u00129\u0015\u0011\t9\u000e&"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.K.info(LoadBalancingManagementRestController.D((Object)"Gsez|utb|y{6rdzce6vy{bgyyzpd5d`x{\u007f{q"));
        if (a2.isEmpty()) {
            grpcRaftController.c.set(true);
        }
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.A.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(EnterpriseSwaggerConfiguration.D((Object)"89\u000e:\u001fv\u00159\u000fv\u001d?\u00152[5\u000e$\t3\u0015\"[8\u00142\u001ev\u00128[8\u00142\u001e%"));
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.D((String)a3);
        }
        a4.F.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.m.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.f.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.K.info(LoadBalancingManagementRestController.D((Object)"mh,5Dpfy\u007fvwa\u007fzx5qgy`f5eawgbpr"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.e.setCleanShutdown();
                grpcRaftController2.c.set(true);
                return;
            }
        } else {
            a3.K.warn(EnterpriseSwaggerConfiguration.D((Object)"\u0000+Av)3\u000b:\u00125\u001a\"\u00129\u0015v\u001c$\u0014#\u000bv\b\"\u001a$\u000fv\u001d7\u0012:\u001e2"), (Object)a.groupId(), a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.L) {
            throw new IllegalStateException(EnterpriseSwaggerConfiguration.D((Object)"\u0005\u001e$\r3\tv\b\"\u001a$\u000f#\u000by\b>\u000e\"\u001f9\f8[?\u0015v\u000b$\u00141\t3\b%"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.F.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.F;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.F.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.D((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, LoadBalancingManagementRestController.D((Object)"Gsez|utb|y{6rdzce6qsysa\u007fzx5\u007f{6edzqgsfe"));
                }
                a3 = grpcRaftController.D((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.L) {
            throw new IllegalStateException(EnterpriseSwaggerConfiguration.D((Object)"28\u0012\"\u00127\u0017?\u00017\u000f?\u00148[9\tv\b>\u000e\"\u001f9\f8[?\u0015v\u000b$\u00141\t3\b%"));
        }
        if (!a3.F.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.A.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.F.get(a2)).localNode();
    }

    private /* synthetic */ boolean D(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.g.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.A.getName();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.C.contexts();
    }

    private /* synthetic */ void D(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.g.put(a2, System.currentTimeMillis() + 2L * (long)a3.M.getMaxElectionTimeout());
    }

    public int getPhase() {
        return 100;
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.K = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.F = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.g = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.c = new AtomicBoolean();
        grpcRaftController6.A = a9;
        grpcRaftController6.C = a8;
        grpcRaftController5.m = a7;
        grpcRaftController5.M = a6;
        grpcRaftController4.f = a5;
        grpcRaftController4.l = a4;
        grpcRaftController3.b = a3;
        grpcRaftController3.e = a2;
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.M.getMaxElectionTimeout();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.L) {
            a2.F.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).D();
            });
        }
    }

    private /* synthetic */ MessagingPlatformException D(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.A.getName() + ": Not a member of " + (String)a2);
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.c.get();
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.m.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.D((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup D(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.F;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.K.info(LoadBalancingManagementRestController.D((Object)"nk/6|x|b5dpfy\u007fvwa\u007fzx5qgy`f"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.F.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.l.create((String)a4, (String)a2);
            a2.localNode().D(arg_0 -> a3.D((RaftGroup)a2, arg_0));
            a3.F.put(a4, a2);
            return a2;
        }
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.F.get(a2);
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).D();
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.b.unregisterPath(H);
        grpcRaftController.F.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.L = false;
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.C.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.f.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.F.keySet();
    }
}

