/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.access.application.ReplicationGroupApplicationController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.AutoRebalancing;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.metric.MeterFactory;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private AdvancedTlsX509KeyManager.Closeable M;
    private boolean C;
    private final MeterFactory L;
    private final LicenseAccessController F;
    private Server b;
    private final Logger l;
    private final Supplier<ScheduledExecutorService> g;
    private final List<AxonServerClientService> m;
    private final List<ServerTransportFilter> A;
    private final MessagingPlatformConfiguration f;
    private final AxonServerAccessController K;
    private final ExecutorService e;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = AutoRebalancing.D((Object)"lu\"IQV");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.f.getSsl() != null && gateway.f.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.M = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.f.getSsl().getPrivateKeyFile()), new File(gateway.f.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.g.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = ReplicationGroupApplicationController.D((Object)"r|m\u000fDA@MMJE");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.f.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.f.getPort());
            }
            if (gateway2.f.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.f.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.f.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.m.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.f.getGrpcBufferedMessages()));
            if (gateway.f.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.K, gateway5.L));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.F));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.f.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.f.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.f.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.e);
            gateway.A.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.b = a2.build();
            gateway.b.start();
            gateway.l.info(AutoRebalancing.D((Object)"Cbmt\"Ight\u007fp:E{v\u007fu{{:qnchv\u007ff:mt\"jmhv \"a\u007f:/:yg"), (Object)gateway.f.getPort(), (Object)string);
            gateway.C = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(ReplicationGroupApplicationController.D((Object)"r[@]UFOH\u0001nY@O\u000frJSYD]\u0001h@[DX@V\u0001I@FMJE"), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.l = LoggerFactory.getLogger(Gateway.class);
        gateway6.f = a8;
        gateway5.m = a7;
        gateway5.A = a6;
        gateway4.K = a5;
        gateway4.F = a4;
        a9.g = a3;
        gateway3.L = a2;
        gateway3.e = Executors.newFixedThreadPool(a9.f.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(AutoRebalancing.D((Object)"ehry/\u007fz\u007faovup7")));
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.C;
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.M != null) {
            gateway.M.close();
        }
        Gateway gateway2 = gateway;
        gateway2.e.shutdown();
        if (gateway2.C) {
            try {
                if (!gateway.b.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.l.debug(ReplicationGroupApplicationController.D((Object)"iN]BJGZMCX\u000fR[N_QFOH\u0001lMZR[D]\u0001|D]WJS"));
                    gateway3.b.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.l.debug(AutoRebalancing.D((Object)"Ktv\u007fphwjv\u007ff:fopsl}\"ijov~mml:m|\"]PJA:q\u007fplgh"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.C = false;
        gateway.l.info(ReplicationGroupApplicationController.D((Object)"`WNA\u0001|D]WJS\u000ffNUJVNX\u000fR[N_QJE"));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public int getPhase() {
        return 200;
    }
}

