/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.integration.rsocket.RsocketEventPublishers;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.query.QueryDefinition;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"}, matchIfMissing=true)
public class HeartbeatMonitor {
    private final Publisher<PlatformOutboundInstruction> l;
    private final long g;
    private final Logger m;
    private final Map<ClientStreamIdentification, Instant> A;
    private final Map<ClientStreamIdentification, ClientInformation> f;
    private final ApplicationEventPublisher K;
    private final Clock e;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.f.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.f.get(a4);
            String string = clientInformation.e;
            String string2 = clientInformation.K;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.g;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.m.info(RsocketEventPublishers.D((Object)"_,u%r4<)r!\u007f4u6u4e`x%h%\u007f4y$<&s2<-s2y`h(}.<;a`q)p,u3y#s.x32`_,u%r4&`g=0`p!o4]#h)j)h9&`g=0`h)q%s5hz<;an<"), objectArray);
            a5.K.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.f)));
        }
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.m.debug(RsocketEventPublishers.D((Object)"_(y#w)r'<#s.r%\u007f4y$<#p)y.h3<!n%<3h)p,<!p)j%2n2"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.e).minus(heartbeatMonitor3.g, ChronoUnit.MILLIS);
        heartbeatMonitor3.A.forEach((arg_0, arg_1) -> heartbeatMonitor.D((Instant)a2, arg_0, arg_1));
    }

    private static /* synthetic */ void D(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.D((BiConsumer)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.a(), a2.D());
        a3.f.put(clientStreamIdentification, new ClientInformation(a2.L(), a2.l(), a2.a()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.D(), a2.a());
        a3.A.remove(a2);
        a3.f.remove(a2);
        a3.m.debug(QueryDefinition.D((Object)"y\u001dE\u0019\n\u0004E\u0007C\u001dE\u001bC\u0007MIB\fK\u001b^\u000bO\b^IL\u0006XII\u0005C\fD\u001d\n\u0012WG"), (Object)a2);
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.D((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void D(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.m = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.f = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.A = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.m.trace(QueryDefinition.D((Object)"b\fK\u001b^+O\b^IX\fI\fC\u001fO\r\n\u000fX\u0006GIQ\u0014"), (Object)a3);
            heartbeatMonitor.A.put(a3, Instant.now(a2.e));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.e = a5;
        heartbeatMonitor5.K = a4;
        heartbeatMonitor4.g = a3;
        heartbeatMonitor4.l = a2;
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:1000}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.l.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }
}

